/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.builder;

import cn.coostack.cooparticlesapi.utils.ImageUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\tJ\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcn/coostack/cooparticlesapi/utils/builder/RGBImagePointBuilder;", "", "image", "Lnet/minecraft/resources/ResourceLocation;", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "getImage", "()Lnet/minecraft/resources/ResourceLocation;", "scale", "", "step", "build", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nRGBImagePointBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RGBImagePointBuilder.kt\ncn/coostack/cooparticlesapi/utils/builder/RGBImagePointBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n640#2:39\n1#3:40\n*S KotlinDebug\n*F\n+ 1 RGBImagePointBuilder.kt\ncn/coostack/cooparticlesapi/utils/builder/RGBImagePointBuilder\n*L\n33#1:39\n33#1:40\n*E\n"})
public final class RGBImagePointBuilder {
    @NotNull
    private final ResourceLocation image;
    private double scale;
    private double step;

    public RGBImagePointBuilder(@NotNull ResourceLocation image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.image = image;
        this.scale = 1.0;
        this.step = 0.01;
    }

    @NotNull
    public final ResourceLocation getImage() {
        return this.image;
    }

    @NotNull
    public final RGBImagePointBuilder scale(double scale) {
        this.scale = scale;
        return this;
    }

    @NotNull
    public final RGBImagePointBuilder step(double step) {
        this.step = step;
        return this;
    }

    @NotNull
    public final Map<RelativeLocation, Integer> build() {
        Map<RelativeLocation, Integer> map;
        BufferedImage bufferedImage = ImageUtil.INSTANCE.loadFromIdentifier(this.image);
        if (bufferedImage == null) {
            return new HashMap();
        }
        BufferedImage picture = bufferedImage;
        BufferedImage scaled = ImageUtil.INSTANCE.scale(this.scale, picture);
        double offsetX = (double)scaled.getWidth() * this.step / 2.0;
        double offsetZ = (double)scaled.getHeight() * this.step / 2.0;
        Map<RelativeLocation, Integer> $this$onEach$iv = ImageUtil.INSTANCE.toPointsWithRGBA(scaled, this.step);
        boolean $i$f$onEach = false;
        Map<RelativeLocation, Integer> $this$onEach_u24lambda_u242$iv = map = $this$onEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<RelativeLocation, Integer>> iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<RelativeLocation, Integer> element$iv;
            Map.Entry<RelativeLocation, Integer> it = element$iv = iterator.next();
            boolean bl2 = false;
            RelativeLocation relativeLocation = it.getKey();
            relativeLocation.setX(relativeLocation.getX() - offsetX);
            relativeLocation = it.getKey();
            relativeLocation.setZ(relativeLocation.getZ() - offsetZ);
        }
        return map;
    }
}

