/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer;

import cn.coostack.cooparticlesapi.network.packet.PacketRenderEntityS2C;
import cn.coostack.cooparticlesapi.network.particle.ServerControler;
import cn.coostack.cooparticlesapi.renderer.server.ServerRenderEntityManager;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001aB\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u0004\u0018\u000109J\u0010\u0010:\u001a\u0004\u0018\u0001092\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u0002072\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010>\u001a\u000207J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@J\u0010\u0010B\u001a\u0002072\u0006\u0010C\u001a\u00020\u0000H\u0016J\r\u0010\u001a\u001a\u000207H\u0000\u00a2\u0006\u0002\bDJ\b\u0010E\u001a\u000207H&J\u0014\u0010F\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u00000GH&J\b\u0010I\u001a\u00020JH&J\b\u0010K\u001a\u000207H&J\u0010\u0010L\u001a\u0002072\u0006\u0010M\u001a\u00020\u0005H\u0016J \u0010L\u001a\u0002072\u0006\u0010N\u001a\u00020\u00112\u0006\u0010O\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u0011H\u0016J\u0010\u0010Q\u001a\u0002072\u0006\u0010M\u001a\u00020RH\u0016J\u0018\u0010S\u001a\u0002072\u0006\u0010M\u001a\u00020R2\u0006\u0010T\u001a\u00020\u0011H\u0016J\u0010\u0010U\u001a\u0002072\u0006\u0010T\u001a\u00020\u0011H\u0016J\b\u0010V\u001a\u000207H\u0016J\b\u0010W\u001a\u00020\u0000H\u0016J\u0018\u0010X\u001a\u0002072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J&\u0010Y\u001a\u0002072\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020]2\u0006\u0010_\u001a\u00020@J(\u0010`\u001a\u0002072\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020]2\u0006\u0010_\u001a\u00020@H&R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001dR\u001e\u0010\"\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0019\"\u0004\b2\u0010\u001dR\u001a\u00103\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0019\"\u0004\b5\u0010\u001d\u00a8\u0006b"}, d2={"Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "Lcn/coostack/cooparticlesapi/network/particle/ServerControler;", "world", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V", "getWorld", "()Lnet/minecraft/world/level/Level;", "setWorld", "(Lnet/minecraft/world/level/Level;)V", "getPos", "()Lnet/minecraft/world/phys/Vec3;", "setPos", "(Lnet/minecraft/world/phys/Vec3;)V", "renderRange", "", "getRenderRange", "()D", "setRenderRange", "(D)V", "client", "", "getClient", "()Z", "init", "getInit", "setInit", "(Z)V", "alwaysToggle", "getAlwaysToggle", "setAlwaysToggle", "value", "lastRenderPos", "getLastRenderPos", "age", "", "getAge", "()I", "setAge", "(I)V", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "dirty", "getDirty", "setDirty", "canceled", "getCanceled", "setCanceled", "tick", "", "getTogglePacket", "Lcn/coostack/cooparticlesapi/network/packet/PacketRenderEntityS2C;", "getPacket", "method", "Lcn/coostack/cooparticlesapi/network/packet/PacketRenderEntityS2C$Method;", "setPosition", "markDirty", "getTime", "", "delta", "loadProfileFromEntity", "another", "init$cooparticlesapi_neoforge_1_21_1", "initialize", "getCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "getRenderID", "Lnet/minecraft/resources/ResourceLocation;", "release", "teleportTo", "to", "x", "y", "z", "rotateParticlesToPoint", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "rotateToWithAngle", "angle", "rotateParticlesAsAxis", "remove", "getValue", "spawn", "renderOnWorld", "matrices", "Lorg/joml/Matrix4fStack;", "viewMatrix", "Lorg/joml/Matrix4f;", "projMatrix", "tickDelta", "render", "Companion", "cooparticlesapi-neoforge-1.21.1"})
public abstract class RenderEntity
implements ServerControler<RenderEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Level world;
    @NotNull
    private Vec3 pos;
    private double renderRange;
    private boolean init;
    private boolean alwaysToggle;
    @NotNull
    private Vec3 lastRenderPos;
    private int age;
    @NotNull
    private UUID uuid;
    private boolean dirty;
    private boolean canceled;

    public RenderEntity(@Nullable Level world, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.world = world;
        this.pos = pos;
        this.renderRange = 256.0;
        this.lastRenderPos = this.pos;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
    }

    public /* synthetic */ RenderEntity(Level level, Vec3 vec3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Vec3 vec32 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
            vec3 = vec32;
        }
        this(level, vec3);
    }

    @Nullable
    public final Level getWorld() {
        return this.world;
    }

    public final void setWorld(@Nullable Level level) {
        this.world = level;
    }

    @NotNull
    public final Vec3 getPos() {
        return this.pos;
    }

    public final void setPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.pos = vec3;
    }

    public final double getRenderRange() {
        return this.renderRange;
    }

    public final void setRenderRange(double d) {
        this.renderRange = d;
    }

    public final boolean getClient() {
        Level level = this.world;
        return level != null ? level.isClientSide : false;
    }

    public final boolean getInit() {
        return this.init;
    }

    public final void setInit(boolean bl) {
        this.init = bl;
    }

    public final boolean getAlwaysToggle() {
        return this.alwaysToggle;
    }

    public final void setAlwaysToggle(boolean bl) {
        this.alwaysToggle = bl;
    }

    @NotNull
    public final Vec3 getLastRenderPos() {
        return this.lastRenderPos;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public final void setUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.uuid = uUID;
    }

    public final boolean getDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public final boolean getCanceled() {
        return this.canceled;
    }

    public final void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public void tick() {
        if (this.canceled) {
            return;
        }
        int n = this.age;
        this.age = n + 1;
    }

    @Nullable
    public final PacketRenderEntityS2C getTogglePacket() {
        return this.getPacket(PacketRenderEntityS2C.Method.TOGGLE);
    }

    @Nullable
    public final PacketRenderEntityS2C getPacket(@NotNull PacketRenderEntityS2C.Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        if (!this.dirty && method == PacketRenderEntityS2C.Method.TOGGLE) {
            return null;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.getCodec().encode((Object)buf, (Object)this);
        PacketRenderEntityS2C packet = new PacketRenderEntityS2C(this.uuid, (ByteBuf)buf, this.getRenderID(), method);
        return packet;
    }

    public final void setPosition(@NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.pos = pos;
        this.markDirty();
    }

    public final void markDirty() {
        this.dirty = true;
    }

    public final float getTime(float delta) {
        return ((float)this.age + delta) / (float)20;
    }

    public void loadProfileFromEntity(@NotNull RenderEntity another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        this.age = another.age;
        this.canceled = another.canceled;
        this.pos = another.pos;
        this.uuid = another.uuid;
        this.world = another.world;
    }

    public final void init$cooparticlesapi_neoforge_1_21_1() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.initialize();
    }

    public abstract void initialize();

    @NotNull
    public abstract StreamCodec<FriendlyByteBuf, RenderEntity> getCodec();

    @NotNull
    public abstract ResourceLocation getRenderID();

    public abstract void release();

    @Override
    public void teleportTo(@NotNull Vec3 to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.lastRenderPos = this.pos;
        this.pos = to;
    }

    @Override
    public void teleportTo(double x, double y, double z) {
        this.teleportTo(new Vec3(x, y, z));
    }

    @Override
    public void rotateParticlesToPoint(@NotNull RelativeLocation to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
    }

    @Override
    public void rotateToWithAngle(@NotNull RelativeLocation to, double angle) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
    }

    @Override
    public void rotateParticlesAsAxis(double angle) {
    }

    @Override
    public void remove() {
        this.canceled = true;
    }

    @Override
    @NotNull
    public RenderEntity getValue() {
        return this;
    }

    @Override
    public void spawn(@NotNull Level world, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!(world instanceof ServerLevel)) {
            return;
        }
        this.world = world;
        this.pos = pos;
        ServerRenderEntityManager.INSTANCE.spawn(this);
    }

    public final void renderOnWorld(@NotNull Matrix4fStack matrices, @NotNull Matrix4f viewMatrix, @NotNull Matrix4f projMatrix, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)viewMatrix, (String)"viewMatrix");
        Intrinsics.checkNotNullParameter((Object)projMatrix, (String)"projMatrix");
        this.lastRenderPos = this.pos;
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        this.render(matrices, viewMatrix, projMatrix, tickDelta);
    }

    public abstract void render(@NotNull Matrix4fStack var1, @NotNull Matrix4f var2, @NotNull Matrix4f var3, float var4);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcn/coostack/cooparticlesapi/renderer/RenderEntity$Companion;", "", "<init>", "()V", "decodeBase", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "instance", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "encodeBase", "entity", "cooparticlesapi-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void decodeBase(@NotNull FriendlyByteBuf buf, @NotNull RenderEntity instance) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            UUID uUID = buf.readUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
            instance.setUuid(uUID);
            Vec3 vec3 = buf.readVec3();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"readVec3(...)");
            instance.setPos(vec3);
            instance.setCanceled(buf.readBoolean());
            instance.setAge(buf.readInt());
            instance.setDirty(false);
        }

        public final void encodeBase(@NotNull FriendlyByteBuf buf, @NotNull RenderEntity entity) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            buf.writeUUID(entity.getUuid());
            buf.writeVec3(entity.getPos());
            buf.writeBoolean(entity.getCanceled());
            buf.writeInt(entity.getAge());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

