/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.server;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.network.packet.PacketRenderEntityS2C;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import cn.coostack.cooparticlesapi.renderer.RenderEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00070\fj\b\u0012\u0004\u0012\u00020\u0007`\r2\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nRM\u0010\u000b\u001a>\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\fj\b\u0012\u0004\u0012\u00020\u0007`\r0\u0005j\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\fj\b\u0012\u0004\u0012\u00020\u0007`\r`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006 "}, d2={"Lcn/coostack/cooparticlesapi/renderer/server/ServerRenderEntityManager;", "", "<init>", "()V", "entities", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "Lkotlin/collections/HashMap;", "getEntities", "()Ljava/util/HashMap;", "playerViewable", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getPlayerViewable", "spawn", "", "entity", "player", "initPlayer", "clearEmptyData", "tick", "updateVisible", "playerCanView", "", "toggle", "addVisible", "who", "Lnet/minecraft/server/level/ServerPlayer;", "removeVisible", "addViewIfVisible", "removeAllView", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nServerRenderEntityManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerRenderEntityManager.kt\ncn/coostack/cooparticlesapi/renderer/server/ServerRenderEntityManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1869#2,2:137\n774#2:139\n865#2,2:140\n1869#2,2:142\n1869#2,2:144\n1869#2,2:146\n*S KotlinDebug\n*F\n+ 1 ServerRenderEntityManager.kt\ncn/coostack/cooparticlesapi/renderer/server/ServerRenderEntityManager\n*L\n62#1:137,2\n98#1:139\n98#1:140,2\n98#1:142,2\n120#1:144,2\n127#1:146,2\n*E\n"})
public final class ServerRenderEntityManager {
    @NotNull
    public static final ServerRenderEntityManager INSTANCE = new ServerRenderEntityManager();
    @NotNull
    private static final HashMap<UUID, RenderEntity> entities = new HashMap();
    @NotNull
    private static final HashMap<UUID, HashSet<RenderEntity>> playerViewable = new HashMap();

    private ServerRenderEntityManager() {
    }

    @NotNull
    public final HashMap<UUID, RenderEntity> getEntities() {
        return entities;
    }

    @NotNull
    public final HashMap<UUID, HashSet<RenderEntity>> getPlayerViewable() {
        return playerViewable;
    }

    public final void spawn(@NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ((Map)entities).put(entity.getUuid(), entity);
    }

    @NotNull
    public final HashSet<RenderEntity> getPlayerViewable(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HashSet hashSet = playerViewable.get(player);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        return hashSet;
    }

    public final void initPlayer(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (playerViewable.containsKey(player)) {
            return;
        }
        ((Map)playerViewable).put(player, new HashSet());
    }

    public final void clearEmptyData() {
        Iterator iterator = ((Map)playerViewable).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            ServerPlayer player = CooParticlesAPI.INSTANCE.getServer().getPlayerList().getPlayer((UUID)entity.getKey());
            if (!((HashSet)entity.getValue()).isEmpty() && player != null) continue;
            iterator.remove();
        }
    }

    public final void tick() {
        Iterator iterator = ((Map)entities).entrySet().iterator();
        while (iterator.hasNext()) {
            RenderEntity entity = (RenderEntity)iterator.next().getValue();
            this.updateVisible(entity);
            entity.tick();
            if (entity.getCanceled()) {
                this.removeAllView(entity);
                iterator.remove();
                continue;
            }
            if (!entity.getAlwaysToggle() && !entity.getDirty()) continue;
            this.toggle(entity);
        }
        this.clearEmptyData();
    }

    public final void updateVisible(@NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        List list = CooParticlesAPI.INSTANCE.getServer().getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean checkCurrentCanView;
            Vec3 entityPos;
            ServerPlayer it = (ServerPlayer)element$iv;
            boolean bl = false;
            UUID uUID = it.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            boolean actualCanView = INSTANCE.playerCanView(uUID, entity);
            if (!Intrinsics.areEqual((Object)it.level(), (Object)entity.getWorld())) {
                if (!actualCanView) continue;
                Intrinsics.checkNotNull((Object)it);
                INSTANCE.removeVisible(it, entity);
                continue;
            }
            if (it.isDeadOrDying() && actualCanView) {
                Intrinsics.checkNotNull((Object)it);
                INSTANCE.removeVisible(it, entity);
                continue;
            }
            Vec3 pos = it.position();
            double dis = pos.distanceTo(entityPos = entity.getPos());
            boolean bl2 = checkCurrentCanView = dis <= entity.getRenderRange();
            if (!checkCurrentCanView && actualCanView) {
                Intrinsics.checkNotNull((Object)it);
                INSTANCE.removeVisible(it, entity);
                continue;
            }
            if (actualCanView || !checkCurrentCanView) continue;
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.addVisible(it, entity);
        }
    }

    public final boolean playerCanView(@NotNull UUID player, @NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.initPlayer(player);
        HashSet<RenderEntity> views = this.getPlayerViewable(player);
        return views.contains(entity);
    }

    /*
     * WARNING - void declaration
     */
    public final void toggle(@NotNull RenderEntity entity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PacketRenderEntityS2C packetRenderEntityS2C = entity.getTogglePacket();
        if (packetRenderEntityS2C == null) {
            return;
        }
        PacketRenderEntityS2C packet = packetRenderEntityS2C;
        List list = CooParticlesAPI.INSTANCE.getServer().getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerPlayer it = (ServerPlayer)element$iv$iv;
            boolean bl = false;
            UUID uUID = it.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            if (!INSTANCE.playerCanView(uUID, entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer it = (ServerPlayer)element$iv;
            boolean bl = false;
            CustomPacketPayload customPacketPayload = packet;
            Intrinsics.checkNotNull((Object)it);
            CooParticlesServices.SERVER_NETWORK.send(customPacketPayload, it);
        }
    }

    public final void addVisible(@NotNull ServerPlayer who, @NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        UUID uUID = who.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.initPlayer(uUID);
        UUID uUID2 = who.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        this.getPlayerViewable(uUID2).add(entity);
        PacketRenderEntityS2C packetRenderEntityS2C = entity.getPacket(PacketRenderEntityS2C.Method.CREATE);
        if (packetRenderEntityS2C == null) {
            return;
        }
        PacketRenderEntityS2C packet = packetRenderEntityS2C;
        CooParticlesServices.SERVER_NETWORK.send(packet, who);
    }

    public final void removeVisible(@NotNull ServerPlayer who, @NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        UUID uUID = who.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.initPlayer(uUID);
        UUID uUID2 = who.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        this.getPlayerViewable(uUID2).remove(entity);
        PacketRenderEntityS2C packetRenderEntityS2C = entity.getPacket(PacketRenderEntityS2C.Method.REMOVE);
        if (packetRenderEntityS2C == null) {
            return;
        }
        PacketRenderEntityS2C packet = packetRenderEntityS2C;
        CooParticlesServices.SERVER_NETWORK.send(packet, who);
    }

    public final void addViewIfVisible(@NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.getWorld();
        if (level == null) {
            return;
        }
        Level world = level;
        List list = world.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            INSTANCE.addVisible((ServerPlayer)it, entity);
        }
    }

    public final void removeAllView(@NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.getWorld();
        if (level == null) {
            return;
        }
        Level world = level;
        Set<Map.Entry<UUID, HashSet<RenderEntity>>> set = playerViewable.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Player player2 = world.getPlayerByUUID((UUID)it.getKey());
            if ((player2 instanceof ServerPlayer ? (ServerPlayer)player2 : null) == null) continue;
            player = player;
            if (!((HashSet)it.getValue()).contains(entity)) continue;
            INSTANCE.removeVisible(player, entity);
        }
    }
}

