/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.glsl;

import cn.coostack.cooparticlesapi.CooParticlesConstants;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlFrameBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.PipeChannels;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.manager.FramePipeChannels;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL33;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u000fH\u0016J\b\u0010%\u001a\u00020\u0018H\u0016J!\u0010&\u001a\u00020\u00182\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180(\u00a2\u0006\u0002\b)H\u0016J!\u0010*\u001a\u00020\u00182\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180(\u00a2\u0006\u0002\b)H\u0016J\b\u0010,\u001a\u00020\u0018H\u0016J\b\u0010-\u001a\u00020\u0018H\u0016J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u000fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/glsl/MinecraftHookFrameBuffer;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlFrameBuffer;", "mcFrame", "Lcom/mojang/blaze3d/pipeline/RenderTarget;", "<init>", "(Lcom/mojang/blaze3d/pipeline/RenderTarget;)V", "getMcFrame", "()Lcom/mojang/blaze3d/pipeline/RenderTarget;", "setMcFrame", "colorAttachments", "", "getColorAttachments", "()[I", "depthSupplier", "Ljava/util/function/Supplier;", "", "getDepthSupplier", "()Ljava/util/function/Supplier;", "setDepthSupplier", "(Ljava/util/function/Supplier;)V", "getOutputChannelCount", "getCurrentDepthAttachment", "width", "useMipmap", "", "height", "prevFBO", "initialized", "", "fbo", "init", "clear", "setTextureFilterMod", "mod", "outputChannels", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/PipeChannels;", "bit", "bindFramebuffer", "writeFrameBufferWith", "writeScope", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "readFrameBufferWith", "readScope", "reset", "release", "resize", "copyDepthBuffer", "srcFBO", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMinecraftHookFrameBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftHookFrameBuffer.kt\ncn/coostack/cooparticlesapi/renderer/shader/glsl/MinecraftHookFrameBuffer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,123:1\n13567#2,3:124\n*S KotlinDebug\n*F\n+ 1 MinecraftHookFrameBuffer.kt\ncn/coostack/cooparticlesapi/renderer/shader/glsl/MinecraftHookFrameBuffer\n*L\n99#1:124,3\n*E\n"})
public class MinecraftHookFrameBuffer
implements GlFrameBuffer {
    @NotNull
    private RenderTarget mcFrame;
    @NotNull
    private final int[] colorAttachments;
    @NotNull
    private Supplier<Integer> depthSupplier;
    private int prevFBO;
    private boolean initialized;

    public MinecraftHookFrameBuffer(@NotNull RenderTarget mcFrame) {
        Intrinsics.checkNotNullParameter((Object)mcFrame, (String)"mcFrame");
        this.mcFrame = mcFrame;
        this.colorAttachments = new int[1];
        this.depthSupplier = () -> MinecraftHookFrameBuffer.depthSupplier$lambda$0(this);
    }

    @NotNull
    public final RenderTarget getMcFrame() {
        return this.mcFrame;
    }

    public final void setMcFrame(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkNotNullParameter((Object)renderTarget, (String)"<set-?>");
        this.mcFrame = renderTarget;
    }

    @Override
    @NotNull
    public int[] getColorAttachments() {
        return this.colorAttachments;
    }

    @Override
    @NotNull
    public Supplier<Integer> getDepthSupplier() {
        return this.depthSupplier;
    }

    @Override
    public void setDepthSupplier(@NotNull Supplier<Integer> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.depthSupplier = supplier;
    }

    @Override
    public int getOutputChannelCount() {
        return 1;
    }

    @Override
    public int getCurrentDepthAttachment() {
        Integer n = this.getDepthSupplier().get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        return ((Number)n).intValue();
    }

    @Override
    public int width() {
        return this.mcFrame.width;
    }

    @Override
    public void useMipmap() {
    }

    @Override
    public int height() {
        return this.mcFrame.height;
    }

    @Override
    public int fbo() {
        return this.mcFrame.frameBufferId;
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.getColorAttachments()[0] = this.mcFrame.getColorTextureId();
    }

    @Override
    public void clear() {
        this.clear(16640);
    }

    @Override
    public void setTextureFilterMod(int mod) {
    }

    @Override
    @NotNull
    public PipeChannels outputChannels() {
        return new FramePipeChannels().addChannel(() -> MinecraftHookFrameBuffer.outputChannels$lambda$1(this));
    }

    @Override
    public void clear(int bit) {
        GL33.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL33.glClear((int)bit);
    }

    @Override
    public void bindFramebuffer() {
        this.prevFBO = GL33.glGetInteger((int)36006);
        GL33.glBindFramebuffer((int)36160, (int)this.fbo());
    }

    @Override
    public void writeFrameBufferWith(@NotNull Function1<? super GlFrameBuffer, Unit> writeScope) {
        Intrinsics.checkNotNullParameter(writeScope, (String)"writeScope");
        this.bindFramebuffer();
        writeScope.invoke((Object)this);
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readFrameBufferWith(@NotNull Function1<? super GlFrameBuffer, Unit> readScope) {
        Intrinsics.checkNotNullParameter(readScope, (String)"readScope");
        if (this.fbo() == 0) {
            CooParticlesConstants.logger.error("trying to read frame buffer but fbo is zero");
            this.initialized = false;
            return;
        }
        int zero = 33984;
        int[] activeChannels = new int[1];
        int prevActive = GL33.glGetInteger((int)34016);
        int prevTexture = GL33.glGetInteger((int)32873);
        GL33.glActiveTexture((int)zero);
        activeChannels[0] = GL33.glGetInteger((int)32873);
        GL33.glBindTexture((int)3553, (int)this.mcFrame.getColorTextureId());
        readScope.invoke((Object)this);
        int[] $this$forEachIndexed$iv = activeChannels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            void texture;
            int n = index$iv++;
            int n2 = item$iv;
            int channel = n;
            boolean bl = false;
            GL33.glActiveTexture((int)(zero + channel));
            GL33.glBindTexture((int)3553, (int)texture);
        }
        GL33.glActiveTexture((int)prevActive);
        GL33.glBindTexture((int)3553, (int)prevTexture);
    }

    @Override
    public void reset() {
        GL33.glBindFramebuffer((int)36160, (int)this.prevFBO);
    }

    @Override
    public void release() {
        if (!this.initialized) {
            return;
        }
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void copyDepthBuffer(int srcFBO) {
    }

    private static final Integer depthSupplier$lambda$0(MinecraftHookFrameBuffer this$0) {
        return this$0.mcFrame.getDepthTextureId();
    }

    private static final Integer outputChannels$lambda$1(MinecraftHookFrameBuffer this$0) {
        return this$0.mcFrame.getColorTextureId();
    }
}

