/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.pipe.manager;

import cn.coostack.cooparticlesapi.exceptions.RenderPipeOutputNotSetException;
import cn.coostack.cooparticlesapi.renderer.shader.ShaderProgramBuilder;
import cn.coostack.cooparticlesapi.renderer.shader.api.CooShaderProgram;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShaderType;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.PipeLinker;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.PipeLinkerNode;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.ShaderPipe;
import cn.coostack.cooparticlesapi.renderer.shader.glsl.IdentifierShader;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.manager.FramePipeChannels;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.manager.GraphPipeLinker;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.pipes.SimpleShaderPipe;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.SimpleVertexBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.VertexBuffers;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0007\u0018\u00002\u00020\u0001B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001d\u0010\u0004\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u001bJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u001bJ\u0006\u0010G\u001a\u00020\u0007J\u001f\u0010H\u001a\u00020\u00002\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000702\u00a2\u0006\u0002\b\bJ\u000e\u0010J\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u001bJ\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020MJ\u001e\u0010N\u001a\u00020\u00072\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001b0P2\u0006\u0010Q\u001a\u00020\u001bH\u0002J\u0006\u0010R\u001a\u00020\u0007J\u0006\u0010S\u001a\u00020\u0007J\u0016\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020%2\u0006\u0010V\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR(\u0010\u0004\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R!\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R \u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010+\u001a\u0004\u0018\u00010\u001b2\b\u0010*\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\"\u0010.\u001a\u0004\u0018\u00010\u001b2\b\u0010*\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010-R(\u00100\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000702\u00a2\u0006\u0002\b\b01\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010<\"\u0004\bA\u0010>R\u001a\u0010D\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u00107\"\u0004\bF\u00109\u00a8\u0006W"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/pipe/manager/ShaderPipeManager;", "", "pipeID", "Lnet/minecraft/resources/ResourceLocation;", "linkerInit", "Lkotlin/Function2;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/PipeLinker;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lkotlin/jvm/functions/Function2;)V", "getPipeID", "()Lnet/minecraft/resources/ResourceLocation;", "getLinkerInit", "()Lkotlin/jvm/functions/Function2;", "initialized", "", "screenBuffer", "Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "screenVertex", "Lcn/coostack/cooparticlesapi/renderer/shader/glsl/IdentifierShader;", "screenFragment", "screenProgram", "Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "useMipmap", "pipes", "Ljava/util/HashSet;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/ShaderPipe;", "Lkotlin/collections/HashSet;", "getPipes", "()Ljava/util/HashSet;", "linker", "Lcn/coostack/cooparticlesapi/renderer/shader/pipe/manager/GraphPipeLinker;", "getLinker", "()Lcn/coostack/cooparticlesapi/renderer/shader/pipe/manager/GraphPipeLinker;", "depthSupplier", "Ljava/util/function/Supplier;", "", "getDepthSupplier", "()Ljava/util/function/Supplier;", "setDepthSupplier", "(Ljava/util/function/Supplier;)V", "value", "valueInputPipe", "getValueInputPipe", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/ShaderPipe;", "valueOutput", "getValueOutput", "beforeInitPipe", "", "Lkotlin/Function1;", "getBeforeInitPipe", "()Ljava/util/List;", "enableBlend", "getEnableBlend", "()Z", "setEnableBlend", "(Z)V", "blendFuncSrc", "getBlendFuncSrc", "()I", "setBlendFuncSrc", "(I)V", "blendFuncDst", "getBlendFuncDst", "setBlendFuncDst", "valueInput", "pipe", "useDepth", "getUseDepth", "setUseDepth", "init", "beforeInit", "invoke", "addPipe", "writeFrame", "draw", "Ljava/lang/Runnable;", "inputPipe", "initPipes", "", "targetPipe", "render", "release", "resize", "width", "height", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nShaderPipeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderPipeManager.kt\ncn/coostack/cooparticlesapi/renderer/shader/pipe/manager/ShaderPipeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,234:1\n1869#2,2:235\n1878#2,3:237\n1869#2,2:242\n1869#2,2:244\n216#3,2:240\n*S KotlinDebug\n*F\n+ 1 ShaderPipeManager.kt\ncn/coostack/cooparticlesapi/renderer/shader/pipe/manager/ShaderPipeManager\n*L\n83#1:235,2\n100#1:237,3\n224#1:242,2\n230#1:244,2\n153#1:240,2\n*E\n"})
public final class ShaderPipeManager {
    @NotNull
    private final ResourceLocation pipeID;
    @NotNull
    private final Function2<ShaderPipeManager, PipeLinker, Unit> linkerInit;
    private boolean initialized;
    @NotNull
    private final SimpleVertexBuffer screenBuffer;
    @NotNull
    private final IdentifierShader screenVertex;
    @NotNull
    private final IdentifierShader screenFragment;
    @NotNull
    private final CooShaderProgram screenProgram;
    private final boolean useMipmap;
    @NotNull
    private final HashSet<ShaderPipe> pipes;
    @NotNull
    private final GraphPipeLinker linker;
    @NotNull
    private Supplier<Integer> depthSupplier;
    @Nullable
    private ShaderPipe valueInputPipe;
    @Nullable
    private ShaderPipe valueOutput;
    @NotNull
    private final List<Function1<ShaderPipeManager, Unit>> beforeInitPipe;
    private boolean enableBlend;
    private int blendFuncSrc;
    private int blendFuncDst;
    private boolean useDepth;

    public ShaderPipeManager(@NotNull ResourceLocation pipeID, @NotNull Function2<? super ShaderPipeManager, ? super PipeLinker, Unit> linkerInit) {
        Intrinsics.checkNotNullParameter((Object)pipeID, (String)"pipeID");
        Intrinsics.checkNotNullParameter(linkerInit, (String)"linkerInit");
        this.pipeID = pipeID;
        this.linkerInit = linkerInit;
        this.screenBuffer = VertexBuffers.INSTANCE.getScreenBuffer();
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cooparticlesapi", (String)"pipe/vertexes/screen.vsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        this.screenVertex = new IdentifierShader(resourceLocation, GlShaderType.VERTEX);
        ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"cooparticlesapi", (String)"pipe/frags/screen.fsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
        this.screenFragment = new IdentifierShader(resourceLocation2, GlShaderType.FRAGMENT);
        this.screenProgram = new ShaderProgramBuilder().vertex(this.screenVertex).fragment(this.screenFragment).build();
        this.pipes = new HashSet();
        this.linker = new GraphPipeLinker();
        this.depthSupplier = ShaderPipeManager::depthSupplier$lambda$0;
        this.beforeInitPipe = new ArrayList();
        this.enableBlend = true;
        this.blendFuncSrc = 1;
        this.blendFuncDst = 1;
        this.useDepth = true;
    }

    @NotNull
    public final ResourceLocation getPipeID() {
        return this.pipeID;
    }

    @NotNull
    public final Function2<ShaderPipeManager, PipeLinker, Unit> getLinkerInit() {
        return this.linkerInit;
    }

    @NotNull
    public final HashSet<ShaderPipe> getPipes() {
        return this.pipes;
    }

    @NotNull
    public final GraphPipeLinker getLinker() {
        return this.linker;
    }

    @NotNull
    public final Supplier<Integer> getDepthSupplier() {
        return this.depthSupplier;
    }

    public final void setDepthSupplier(@NotNull Supplier<Integer> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.depthSupplier = supplier;
    }

    @Nullable
    public final ShaderPipe getValueInputPipe() {
        return this.valueInputPipe;
    }

    @Nullable
    public final ShaderPipe getValueOutput() {
        return this.valueOutput;
    }

    @NotNull
    public final List<Function1<ShaderPipeManager, Unit>> getBeforeInitPipe() {
        return this.beforeInitPipe;
    }

    public final boolean getEnableBlend() {
        return this.enableBlend;
    }

    public final void setEnableBlend(boolean bl) {
        this.enableBlend = bl;
    }

    public final int getBlendFuncSrc() {
        return this.blendFuncSrc;
    }

    public final void setBlendFuncSrc(int n) {
        this.blendFuncSrc = n;
    }

    public final int getBlendFuncDst() {
        return this.blendFuncDst;
    }

    public final void setBlendFuncDst(int n) {
        this.blendFuncDst = n;
    }

    @NotNull
    public final ShaderPipeManager valueInput(@NotNull ShaderPipe pipe) {
        Intrinsics.checkNotNullParameter((Object)pipe, (String)"pipe");
        this.valueInputPipe = pipe;
        this.addPipe(pipe);
        return this;
    }

    @NotNull
    public final ShaderPipeManager valueOutput(@NotNull ShaderPipe pipe) {
        Intrinsics.checkNotNullParameter((Object)pipe, (String)"pipe");
        this.valueOutput = pipe;
        this.addPipe(pipe);
        return this;
    }

    public final boolean getUseDepth() {
        return this.useDepth;
    }

    public final void setUseDepth(boolean bl) {
        this.useDepth = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        if (this.initialized) {
            return;
        }
        Iterable $this$forEach$iv = this.beforeInitPipe;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)this);
        }
        this.initialized = true;
        if (this.valueInputPipe == null) {
            Minecraft mc = Minecraft.getInstance();
            Window window = mc.getWindow();
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cooparticlesapi", (String)"pipe/frags/screen.fsh");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
            this.valueInputPipe = new SimpleShaderPipe(new IdentifierShader(resourceLocation, GlShaderType.FRAGMENT), this.depthSupplier, 0, 0, 12, null);
        }
        ShaderPipe shaderPipe = this.valueInputPipe;
        Intrinsics.checkNotNull((Object)shaderPipe);
        this.pipes.add(shaderPipe);
        Iterable $this$forEachIndexed$iv = this.pipes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ShaderPipe shaderPipe2 = (ShaderPipe)item$iv;
            int current = n;
            boolean bl = false;
            it.init();
        }
        this.screenBuffer.init();
        this.screenProgram.init();
        this.linkerInit.invoke((Object)this, (Object)this.linker);
    }

    @NotNull
    public final ShaderPipeManager beforeInit(@NotNull Function1<? super ShaderPipeManager, Unit> invoke) {
        Intrinsics.checkNotNullParameter(invoke, (String)"invoke");
        this.beforeInitPipe.add(invoke);
        return this;
    }

    @NotNull
    public final ShaderPipe addPipe(@NotNull ShaderPipe pipe) {
        Intrinsics.checkNotNullParameter((Object)pipe, (String)"pipe");
        if (this.initialized) {
            pipe.init();
        }
        this.pipes.add(pipe);
        return pipe;
    }

    @NotNull
    public final ShaderPipeManager writeFrame(@NotNull Runnable draw) {
        Intrinsics.checkNotNullParameter((Object)draw, (String)"draw");
        if (!this.initialized) {
            return this;
        }
        if (this.useDepth) {
            RenderSystem.depthMask((boolean)true);
        }
        ShaderPipe shaderPipe = this.valueInputPipe;
        Intrinsics.checkNotNull((Object)shaderPipe);
        shaderPipe.write((Function1<? super ShaderPipe, Unit>)((Function1)arg_0 -> ShaderPipeManager.writeFrame$lambda$3(draw, arg_0)));
        return this;
    }

    private final void inputPipe(Set<ShaderPipe> initPipes, ShaderPipe targetPipe) {
        initPipes.add(targetPipe);
        Map<Integer, PipeLinkerNode> all = this.linker.findAllChannel(targetPipe);
        if (all.isEmpty()) {
            return;
        }
        PipeLinkerNode[] channelList = new PipeLinkerNode[all.size()];
        Map<Integer, PipeLinkerNode> $this$forEach$iv = all;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, PipeLinkerNode>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, PipeLinkerNode> element$iv;
            Map.Entry<Integer, PipeLinkerNode> it = element$iv = iterator.next();
            boolean bl = false;
            int channel = ((Number)it.getKey()).intValue();
            PipeLinkerNode output = it.getValue();
            if (!initPipes.contains(output.getPipe())) {
                this.inputPipe(initPipes, output.getPipe());
            }
            channelList[channel] = output;
        }
        FramePipeChannels pipeChannels = new FramePipeChannels();
        int n = channelList.length;
        for (int i = 0; i < n; ++i) {
            PipeLinkerNode node;
            PipeLinkerNode pipeLinkerNode = node = channelList[i];
            Intrinsics.checkNotNull((Object)pipeLinkerNode);
            pipeChannels.addChannel(pipeLinkerNode.getPipe().getFrameOutput().getChannel(node.getChannel()));
        }
        targetPipe.writeFromChannel(pipeChannels);
    }

    public final void render() {
        if (!this.initialized) {
            return;
        }
        if (this.valueOutput == null) {
            throw new RenderPipeOutputNotSetException(this.pipeID);
        }
        Set set = new HashSet();
        ShaderPipe shaderPipe = this.valueOutput;
        Intrinsics.checkNotNull((Object)shaderPipe);
        this.inputPipe(set, shaderPipe);
        if (this.enableBlend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)this.blendFuncSrc, (int)this.blendFuncDst);
        }
        RenderSystem.depthMask((boolean)false);
        this.screenProgram.useOnContext((Function1<? super CooShaderProgram, Unit>)((Function1)arg_0 -> ShaderPipeManager.render$lambda$6(this, arg_0)));
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
    }

    public final void release() {
        Iterable $this$forEach$iv = this.pipes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShaderPipe it = (ShaderPipe)element$iv;
            boolean bl = false;
            it.release();
        }
    }

    public final void resize(int width, int height) {
        Iterable $this$forEach$iv = this.pipes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShaderPipe it = (ShaderPipe)element$iv;
            boolean bl = false;
            it.resize(width, height);
        }
    }

    private static final Integer depthSupplier$lambda$0() {
        return -1;
    }

    private static final Unit writeFrame$lambda$3(Runnable $draw, ShaderPipe $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        $draw.run();
        return Unit.INSTANCE;
    }

    private static final void render$lambda$6$lambda$5(ShaderPipeManager this$0) {
        this$0.screenBuffer.draw();
    }

    private static final Unit render$lambda$6(ShaderPipeManager this$0, CooShaderProgram $this$useOnContext) {
        Intrinsics.checkNotNullParameter((Object)$this$useOnContext, (String)"$this$useOnContext");
        ShaderPipe shaderPipe = this$0.valueOutput;
        Intrinsics.checkNotNull((Object)shaderPipe);
        shaderPipe.getFrameOutput().drawWith(() -> ShaderPipeManager.render$lambda$6$lambda$5(this$0));
        return Unit.INSTANCE;
    }
}

