/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.pipe.pipes;

import cn.coostack.cooparticlesapi.renderer.shader.ShaderProgramBuilder;
import cn.coostack.cooparticlesapi.renderer.shader.api.CooShaderProgram;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlFrameBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShaderType;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.PipeChannels;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.ShaderPipe;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.handler.ShaderProgramUploader;
import cn.coostack.cooparticlesapi.renderer.shader.glsl.IdentifierShader;
import cn.coostack.cooparticlesapi.renderer.shader.glsl.SimpleFrameBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.SimpleVertexBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.VertexBuffers;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0001H\u0016J!\u0010%\u001a\u00020 2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020 0'\u00a2\u0006\u0002\b(H\u0016J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020 H\u0016J\b\u0010-\u001a\u00020+H\u0016J\b\u0010.\u001a\u00020 H\u0002J\u0018\u0010/\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\b\u00100\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/pipe/pipes/SimpleShaderPipe;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/ShaderPipe;", "fragment", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "depthSupplier", "Ljava/util/function/Supplier;", "", "colorChannelCount", "textureFilterMod", "<init>", "(Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;Ljava/util/function/Supplier;II)V", "getFragment", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "getTextureFilterMod", "()I", "screenVertex", "Lcn/coostack/cooparticlesapi/renderer/shader/glsl/IdentifierShader;", "shaderVertexes", "Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "handles", "Ljava/util/ArrayList;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/handler/ShaderProgramUploader;", "Lkotlin/collections/ArrayList;", "screenProgram", "Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "width", "getWidth", "height", "getHeight", "fbo", "Lcn/coostack/cooparticlesapi/renderer/shader/glsl/SimpleFrameBuffer;", "init", "", "addRenderHandler", "handler", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlFrameBuffer;", "useMipmap", "write", "invoker", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeFromChannel", "channel", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/PipeChannels;", "drawPipeFrame", "getFrameOutput", "drawOnce", "resize", "release", "cooparticlesapi-neoforge-1.21.1"})
public final class SimpleShaderPipe
implements ShaderPipe {
    @NotNull
    private final GlShader fragment;
    private final int textureFilterMod;
    @NotNull
    private final IdentifierShader screenVertex;
    @NotNull
    private final SimpleVertexBuffer shaderVertexes;
    @NotNull
    private final ArrayList<ShaderProgramUploader> handles;
    @NotNull
    private final CooShaderProgram screenProgram;
    @NotNull
    private final SimpleFrameBuffer fbo;

    public SimpleShaderPipe(@NotNull GlShader fragment, @NotNull Supplier<Integer> depthSupplier, int colorChannelCount, int textureFilterMod) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(depthSupplier, (String)"depthSupplier");
        this.fragment = fragment;
        this.textureFilterMod = textureFilterMod;
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cooparticlesapi", (String)"pipe/vertexes/screen.vsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        this.screenVertex = new IdentifierShader(resourceLocation, GlShaderType.VERTEX);
        this.shaderVertexes = VertexBuffers.INSTANCE.getScreenBuffer();
        this.handles = new ArrayList();
        this.screenProgram = new ShaderProgramBuilder().vertex(this.screenVertex).fragment(this.fragment).build();
        this.fbo = new SimpleFrameBuffer(colorChannelCount, depthSupplier);
    }

    public /* synthetic */ SimpleShaderPipe(GlShader glShader, Supplier supplier, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 1;
        }
        if ((n3 & 8) != 0) {
            n2 = 9729;
        }
        this(glShader, supplier, n, n2);
    }

    @NotNull
    public final GlShader getFragment() {
        return this.fragment;
    }

    public final int getTextureFilterMod() {
        return this.textureFilterMod;
    }

    public final int getWidth() {
        return Minecraft.getInstance().getMainRenderTarget().width;
    }

    public final int getHeight() {
        return Minecraft.getInstance().getMainRenderTarget().height;
    }

    @Override
    public void init() {
        if (!(this.fragment.getType() == GlShaderType.FRAGMENT)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.fbo.setTextureFilterMod(this.textureFilterMod);
        this.screenProgram.init();
        this.fbo.init();
        this.shaderVertexes.init();
    }

    @Override
    @NotNull
    public ShaderPipe addRenderHandler(@NotNull ShaderProgramUploader handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handles.add(handler);
        return this;
    }

    @Override
    @NotNull
    public GlFrameBuffer fbo() {
        return this.fbo;
    }

    @Override
    @NotNull
    public ShaderPipe useMipmap() {
        this.fbo.useMipmap();
        return this;
    }

    @Override
    public void write(@NotNull Function1<? super ShaderPipe, Unit> invoker) {
        Intrinsics.checkNotNullParameter(invoker, (String)"invoker");
        this.fbo.writeFrameBufferWith((Function1<? super GlFrameBuffer, Unit>)((Function1)arg_0 -> SimpleShaderPipe.write$lambda$0(invoker, this, arg_0)));
    }

    @Override
    @NotNull
    public SimpleShaderPipe writeFromChannel(@NotNull PipeChannels channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        channel.drawWith(() -> SimpleShaderPipe.writeFromChannel$lambda$3(this));
        return this;
    }

    @Override
    public void drawPipeFrame() {
        this.drawOnce();
    }

    @Override
    @NotNull
    public PipeChannels getFrameOutput() {
        return this.fbo.outputChannels();
    }

    private final void drawOnce() {
        this.screenProgram.useOnContext((Function1<? super CooShaderProgram, Unit>)((Function1)arg_0 -> SimpleShaderPipe.drawOnce$lambda$5(this, arg_0)));
    }

    @Override
    public void resize(int width, int height) {
        this.fbo.resize(width, height);
    }

    @Override
    public void release() {
        this.fbo.release();
        this.screenProgram.release();
        this.shaderVertexes.release();
    }

    private static final Unit write$lambda$0(Function1 $invoker, SimpleShaderPipe this$0, GlFrameBuffer $this$writeFrameBufferWith) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFrameBufferWith, (String)"$this$writeFrameBufferWith");
        RenderSystem.disableBlend();
        $invoker.invoke((Object)this$0);
        return Unit.INSTANCE;
    }

    private static final Unit writeFromChannel$lambda$3$lambda$2$lambda$1(SimpleShaderPipe this$0, ShaderPipe $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        this$0.shaderVertexes.draw();
        return Unit.INSTANCE;
    }

    private static final Unit writeFromChannel$lambda$3$lambda$2(SimpleShaderPipe this$0, CooShaderProgram $this$useOnContext) {
        Intrinsics.checkNotNullParameter((Object)$this$useOnContext, (String)"$this$useOnContext");
        Iterator<ShaderProgramUploader> iterator = this$0.handles.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ShaderProgramUploader> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ShaderProgramUploader handler;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            handler.uploadShaderData(this$0.screenProgram);
        }
        this$0.write((Function1<? super ShaderPipe, Unit>)((Function1)arg_0 -> SimpleShaderPipe.writeFromChannel$lambda$3$lambda$2$lambda$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void writeFromChannel$lambda$3(SimpleShaderPipe this$0) {
        this$0.screenProgram.useOnContext((Function1<? super CooShaderProgram, Unit>)((Function1)arg_0 -> SimpleShaderPipe.writeFromChannel$lambda$3$lambda$2(this$0, arg_0)));
    }

    private static final Unit drawOnce$lambda$5$lambda$4(SimpleShaderPipe this$0, GlFrameBuffer $this$readFrameBufferWith) {
        Intrinsics.checkNotNullParameter((Object)$this$readFrameBufferWith, (String)"$this$readFrameBufferWith");
        this$0.shaderVertexes.draw();
        return Unit.INSTANCE;
    }

    private static final Unit drawOnce$lambda$5(SimpleShaderPipe this$0, CooShaderProgram $this$useOnContext) {
        Intrinsics.checkNotNullParameter((Object)$this$useOnContext, (String)"$this$useOnContext");
        Iterator<ShaderProgramUploader> iterator = this$0.handles.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ShaderProgramUploader> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ShaderProgramUploader handler;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            handler.uploadShaderData(this$0.screenProgram);
        }
        this$0.fbo.readFrameBufferWith((Function1<? super GlFrameBuffer, Unit>)((Function1)arg_0 -> SimpleShaderPipe.drawOnce$lambda$5$lambda$4(this$0, arg_0)));
        return Unit.INSTANCE;
    }
}

