/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.test.particle.emitter;

import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ClassParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.particles.ControlableParticle;
import cn.coostack.cooparticlesapi.particles.control.ParticleControler;
import cn.coostack.cooparticlesapi.utils.GraphMathHelper;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.interpolator.DirectInterpolator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 A2\u00020\u0001:\u0001AB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020%H\u0016J\u0010\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0003H\u0014J\u001a\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002020100H\u0016J8\u00103\u001a\u00020%2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u0002022\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0014\u0010>\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020'0?H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u0013R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006B"}, d2={"Lcn/coostack/cooparticlesapi/test/particle/emitter/TestEmitter;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters;", "pos", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;)V", "templateData", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "getTemplateData", "()Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "setTemplateData", "(Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;)V", "emitterMoveDirection", "kotlin.jvm.PlatformType", "getEmitterMoveDirection", "()Lnet/minecraft/world/phys/Vec3;", "setEmitterMoveDirection", "(Lnet/minecraft/world/phys/Vec3;)V", "particleVelocity", "Lcn/coostack/cooparticlesapi/utils/interpolator/DirectInterpolator;", "getParticleVelocity", "()Lcn/coostack/cooparticlesapi/utils/interpolator/DirectInterpolator;", "particleMoveDirection", "getParticleMoveDirection", "setParticleMoveDirection", "particleRotateX", "", "getParticleRotateX", "()D", "setParticleRotateX", "(D)V", "lastParticleRotateX", "getLastParticleRotateX", "setLastParticleRotateX", "update", "", "emitters", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmitters;", "doTick", "doSubtick", "current", "random", "Lkotlin/random/Random;", "getRandom", "()Lkotlin/random/Random;", "genParticles", "", "Lkotlin/Pair;", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "singleParticleAction", "controler", "Lcn/coostack/cooparticlesapi/particles/control/ParticleControler;", "data", "spawnPos", "spawnWorld", "particleLerpProgress", "", "posLerpProgress", "getEmittersID", "", "getCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Companion", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nTestEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestEmitter.kt\ncn/coostack/cooparticlesapi/test/particle/emitter/TestEmitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1563#2:146\n1634#2,3:147\n*S KotlinDebug\n*F\n+ 1 TestEmitter.kt\ncn/coostack/cooparticlesapi/test/particle/emitter/TestEmitter\n*L\n88#1:146\n88#1:147,3\n*E\n"})
public final class TestEmitter
extends ClassParticleEmitters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ControlableParticleData templateData;
    private Vec3 emitterMoveDirection;
    @NotNull
    private final DirectInterpolator particleVelocity;
    @NotNull
    private Vec3 particleMoveDirection;
    private double particleRotateX;
    private double lastParticleRotateX;
    @NotNull
    private final Random random;
    @NotNull
    public static final String ID = "test-particle-emitters";
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, ParticleEmitters> CODEC;

    public TestEmitter(@NotNull Vec3 pos, @Nullable Level world) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(pos, world);
        this.templateData = new ControlableParticleData();
        this.emitterMoveDirection = Vec3.ZERO;
        this.particleVelocity = new DirectInterpolator().setRefiner(5.0);
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.particleMoveDirection = vec3;
        this.random = RandomKt.Random((long)System.currentTimeMillis());
    }

    @NotNull
    public final ControlableParticleData getTemplateData() {
        return this.templateData;
    }

    public final void setTemplateData(@NotNull ControlableParticleData controlableParticleData) {
        Intrinsics.checkNotNullParameter((Object)controlableParticleData, (String)"<set-?>");
        this.templateData = controlableParticleData;
    }

    public final Vec3 getEmitterMoveDirection() {
        return this.emitterMoveDirection;
    }

    public final void setEmitterMoveDirection(Vec3 vec3) {
        this.emitterMoveDirection = vec3;
    }

    @NotNull
    public final DirectInterpolator getParticleVelocity() {
        return this.particleVelocity;
    }

    @NotNull
    public final Vec3 getParticleMoveDirection() {
        return this.particleMoveDirection;
    }

    public final void setParticleMoveDirection(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.particleMoveDirection = vec3;
    }

    public final double getParticleRotateX() {
        return this.particleRotateX;
    }

    public final void setParticleRotateX(double d) {
        this.particleRotateX = d;
    }

    public final double getLastParticleRotateX() {
        return this.lastParticleRotateX;
    }

    public final void setLastParticleRotateX(double d) {
        this.lastParticleRotateX = d;
    }

    @Override
    public void update(@NotNull ParticleEmitters emitters) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        super.update(emitters);
        if (!(emitters instanceof TestEmitter)) {
            return;
        }
        this.emitterMoveDirection = ((TestEmitter)emitters).emitterMoveDirection;
        this.particleMoveDirection = ((TestEmitter)emitters).particleMoveDirection;
        this.particleRotateX = ((TestEmitter)emitters).particleRotateX;
    }

    @Override
    public void doTick() {
        Vec3 vec3 = this.getPos().add(this.emitterMoveDirection);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        this.setPos(vec3);
        this.lastParticleRotateX = this.particleRotateX;
        this.particleRotateX += 0.7853981633974483;
    }

    @Override
    protected void doSubtick(@NotNull Vec3 current) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        this.particleVelocity.putParticleArgs(current, this.particleMoveDirection, this.particleMoveDirection.length());
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<ControlableParticleData, RelativeLocation>> genParticles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.particleVelocity.getRefinedResult();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ControlableParticleData controlableParticleData;
            RelativeLocation relativeLocation = (RelativeLocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ControlableParticleData it = controlableParticleData = this.templateData.clone();
            boolean bl2 = false;
            it.setVelocity(this.particleMoveDirection);
            collection.add(TuplesKt.to((Object)controlableParticleData, (Object)new RelativeLocation()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void singleParticleAction(@NotNull ParticleControler controler, @NotNull ControlableParticleData data, @NotNull RelativeLocation spawnPos, @NotNull Level spawnWorld, float particleLerpProgress, float posLerpProgress) {
        Intrinsics.checkNotNullParameter((Object)controler, (String)"controler");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)spawnPos, (String)"spawnPos");
        Intrinsics.checkNotNullParameter((Object)spawnWorld, (String)"spawnWorld");
        ParticleRenderType particleRenderType = ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        Intrinsics.checkNotNullExpressionValue((Object)particleRenderType, (String)"PARTICLE_SHEET_TRANSLUCENT");
        data.setTextureSheet(particleRenderType);
        data.setSize(1.0f);
        data.setColor(new Vector3f(0.0f, 0.3882353f, 0.8f));
        data.setAlpha(0.0f);
        double delta = GraphMathHelper.lerp(particleLerpProgress, this.particleRotateX, this.lastParticleRotateX);
        RelativeLocation rotate = new RelativeLocation(Math.cos(delta), 0.0, Math.sin(delta));
        Math3DUtil.INSTANCE.rotatePointsToPoint(CollectionsKt.listOf((Object)rotate), RelativeLocation.Companion.of(this.particleMoveDirection), RelativeLocation.Companion.yAxis());
        data.setVelocity(Vec3ExtendsKt.plus(rotate.normalize().multiply(0.3).toVector(), this.particleMoveDirection));
        spawnPos.add(RelativeLocation.Companion.of(Vec3ExtendsKt.multiply(data.getVelocity(), particleLerpProgress)));
        controler.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> TestEmitter.singleParticleAction$lambda$4(this, data, arg_0)));
    }

    @Override
    @NotNull
    public String getEmittersID() {
        return ID;
    }

    @Override
    @NotNull
    public StreamCodec<FriendlyByteBuf, ParticleEmitters> getCodec() {
        return CODEC;
    }

    private static final Unit singleParticleAction$lambda$4(TestEmitter this$0, ControlableParticleData $data, ControlableParticle $this$addPreTickAction) {
        GraphMathHelper $this$singleParticleAction_u24lambda_u244_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        Vec3 vec3 = $this$addPreTickAction.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPos(...)");
        this$0.updatePhysics(vec3, $data);
        int p1 = $this$addPreTickAction.getLifetime();
        float precent = (float)$this$addPreTickAction.getCurrentAge() / (float)p1;
        $this$addPreTickAction.setParticleAlpha(GraphMathHelper.lerp((float)$this$addPreTickAction.getCurrentAge() * 2.0f / (float)$this$addPreTickAction.getLifetime(), 0.0f, 1.0f));
        GraphMathHelper graphMathHelper = GraphMathHelper.INSTANCE;
        ControlableParticle controlableParticle = $this$addPreTickAction;
        boolean bl = false;
        controlableParticle.setColor(Vec3ExtendsKt.plus(Vec3ExtendsKt.times(GraphMathHelper.lerp(precent, new Vector3f(1.0f, 0.5686275f, 0.7411765f), new Vector3f(1.0f, 0.96862745f, 0.7490196f)), $this$singleParticleAction_u24lambda_u244_u24lambda_u242.step(0.5f, precent)), Vec3ExtendsKt.times(GraphMathHelper.lerp(precent, new Vector3f(0.0f, 0.3882353f, 0.8f), new Vector3f(1.0f, 0.96862745f, 0.7490196f)), $this$singleParticleAction_u24lambda_u244_u24lambda_u242.step(-0.5f, -precent))));
        $this$singleParticleAction_u24lambda_u244_u24lambda_u242 = GraphMathHelper.INSTANCE;
        controlableParticle = $this$addPreTickAction;
        boolean bl2 = false;
        float f = GraphMathHelper.lerp(precent, 1.0f, 0.1f);
        controlableParticle.setSize(f);
        return Unit.INSTANCE;
    }

    private static final void CODEC$lambda$5(FriendlyByteBuf buf, ParticleEmitters data) {
        Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type cn.coostack.cooparticlesapi.test.particle.emitter.TestEmitter");
        TestEmitter cfr_ignored_0 = (TestEmitter)data;
        ClassParticleEmitters classParticleEmitters = (ClassParticleEmitters)data;
        Intrinsics.checkNotNull((Object)buf);
        ClassParticleEmitters.Companion.encodeBase(classParticleEmitters, buf);
        ControlableParticleData.Companion.getPACKET_CODEC().encode((Object)buf, (Object)((TestEmitter)data).templateData);
        buf.writeVec3(((TestEmitter)data).emitterMoveDirection);
        buf.writeVec3(((TestEmitter)data).particleMoveDirection);
        buf.writeDouble(((TestEmitter)data).particleRotateX);
    }

    private static final ParticleEmitters CODEC$lambda$6(FriendlyByteBuf it) {
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        TestEmitter instance = new TestEmitter(vec3, null);
        ClassParticleEmitters classParticleEmitters = instance;
        Intrinsics.checkNotNull((Object)it);
        ClassParticleEmitters.Companion.decodeBase(classParticleEmitters, it);
        Object object = ControlableParticleData.Companion.getPACKET_CODEC().decode((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decode(...)");
        instance.templateData = (ControlableParticleData)object;
        instance.emitterMoveDirection = it.readVec3();
        Vec3 vec32 = it.readVec3();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"readVec3(...)");
        instance.particleMoveDirection = vec32;
        instance.particleRotateX = it.readDouble();
        return instance;
    }

    @NotNull
    public static final StreamCodec<FriendlyByteBuf, ParticleEmitters> getCODEC() {
        return Companion.getCODEC();
    }

    static {
        StreamCodec streamCodec = StreamCodec.of(TestEmitter::CODEC$lambda$5, TestEmitter::CODEC$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"of(...)");
        CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcn/coostack/cooparticlesapi/test/particle/emitter/TestEmitter$Companion;", "", "<init>", "()V", "ID", "", "CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmitters;", "getCODEC$annotations", "getCODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "cooparticlesapi-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, ParticleEmitters> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCODEC$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

