/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.test.particle.server;

import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffers;
import cn.coostack.cooparticlesapi.network.particle.SequencedServerParticleGroup;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroup;
import cn.coostack.cooparticlesapi.test.particle.client.SequencedMagicCircleClient;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u001f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020!0 0\u001eH\u0016J\u0012\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020$\u0018\u00010#H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011\u00a8\u0006%"}, d2={"Lcn/coostack/cooparticlesapi/test/particle/server/SequencedMagicCircleServer;", "Lcn/coostack/cooparticlesapi/network/particle/SequencedServerParticleGroup;", "bindPlayer", "Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "getBindPlayer", "()Ljava/util/UUID;", "maxCount", "", "getMaxCount", "()I", "add", "", "getAdd", "()Z", "setAdd", "(Z)V", "st", "getSt", "setSt", "(I)V", "maxSt", "getMaxSt", "stToggle", "getStToggle", "setStToggle", "tick", "", "otherPacketArgs", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "", "getClientType", "Ljava/lang/Class;", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup;", "cooparticlesapi-neoforge-1.21.1"})
public final class SequencedMagicCircleServer
extends SequencedServerParticleGroup {
    @NotNull
    private final UUID bindPlayer;
    private final int maxCount;
    private boolean add;
    private int st;
    private final int maxSt;
    private boolean stToggle;

    public SequencedMagicCircleServer(@NotNull UUID bindPlayer) {
        Intrinsics.checkNotNullParameter((Object)bindPlayer, (String)"bindPlayer");
        super(16.0);
        this.bindPlayer = bindPlayer;
        this.maxCount = this.maxCount();
        this.maxSt = 72;
    }

    @NotNull
    public final UUID getBindPlayer() {
        return this.bindPlayer;
    }

    public final int getMaxCount() {
        return this.maxCount;
    }

    public final boolean getAdd() {
        return this.add;
    }

    public final void setAdd(boolean bl) {
        this.add = bl;
    }

    public final int getSt() {
        return this.st;
    }

    public final void setSt(int n) {
        this.st = n;
    }

    public final int getMaxSt() {
        return this.maxSt;
    }

    public final boolean getStToggle() {
        return this.stToggle;
    }

    public final void setStToggle(boolean bl) {
        this.stToggle = bl;
    }

    @Override
    public void tick() {
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        Player player = level.getPlayerByUUID(this.bindPlayer);
        if (player == null) {
            return;
        }
        Player player2 = player;
        Vec3 vec3 = player2.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        this.setPosOnServer(vec3);
        int n = this.st;
        this.st = n + 1;
        if (n > this.maxSt) {
            if (!this.stToggle) {
                this.stToggle = true;
                int n2 = this.maxCount();
                for (int i = 0; i < n2; ++i) {
                    if (i <= 30) {
                        this.setDisplayed(i, true);
                        continue;
                    }
                    this.setDisplayed(i, false);
                }
                this.toggleCurrentCount();
            }
            return;
        }
        if (this.add && this.getServerSequencedParticleCount() >= this.maxCount) {
            this.add = false;
            this.setServerSequencedParticleCount(this.maxCount);
        } else if (!this.add && this.getServerSequencedParticleCount() <= 0) {
            this.add = true;
            this.setServerSequencedParticleCount(0);
        }
        if (this.add) {
            this.addMultiple(10);
        } else {
            this.removeMultiple(10);
        }
    }

    @Override
    @NotNull
    public Map<String, ParticleControlerDataBuffer<? extends Object>> otherPacketArgs() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bind_player", (Object)ParticleControlerDataBuffers.INSTANCE.uuid(this.bindPlayer)), this.toggleArgLeastIndex(), this.toggleArgStatus()};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @Nullable
    public Class<? extends ControlableParticleGroup> getClientType() {
        return SequencedMagicCircleClient.class;
    }

    @Override
    public int maxCount() {
        return 360;
    }
}

