/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils;

import cn.coostack.cooparticlesapi.utils.LinerLevelLerp;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007J \u0010\u0004\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\fH\u0007J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\fH\u0007J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\fH\u0007J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\nH\u0007J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\nH\u0007J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Lcn/coostack/cooparticlesapi/utils/GraphMathHelper;", "", "<init>", "()V", "smoothStep", "Lorg/joml/Vector3f;", "min", "", "max", "gen", "", "mix", "Lnet/minecraft/world/phys/Vec3;", "c1", "c2", "delta", "lerp", "step", "limit", "enter", "levelLerp", "Lcn/coostack/cooparticlesapi/utils/LinerLevelLerp;", "cooparticlesapi-neoforge-1.21.1"})
public final class GraphMathHelper {
    @NotNull
    public static final GraphMathHelper INSTANCE = new GraphMathHelper();

    private GraphMathHelper() {
    }

    @JvmStatic
    @NotNull
    public static final Vector3f smoothStep(float min, float max, @NotNull Vector3f gen) {
        float gy;
        float gx;
        Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
        float f = gen.x <= min ? 0.0f : (gx = gen.x >= max ? 1.0f : RangesKt.coerceIn((float)((gen.x - min) / (max - min)), (float)0.0f, (float)1.0f));
        float f2 = gen.y <= min ? 0.0f : (gy = gen.y >= max ? 1.0f : RangesKt.coerceIn((float)((gen.y - min) / (max - min)), (float)0.0f, (float)1.0f));
        float gz = gen.z <= min ? 0.0f : (gen.z >= max ? 1.0f : RangesKt.coerceIn((float)((gen.z - min) / (max - min)), (float)0.0f, (float)1.0f));
        float resX = (float)Math.pow(gx, 2) * ((float)3 - (float)2 * gx);
        float resY = (float)Math.pow(gy, 2) * ((float)3 - (float)2 * gy);
        float resZ = (float)Math.pow(gz, 2) * ((float)3 - (float)2 * gz);
        return new Vector3f(resX, resY, resZ);
    }

    @JvmStatic
    public static final double smoothStep(double min, double max, double gen) {
        if (gen <= min) {
            return 0.0;
        }
        if (gen >= max) {
            return 1.0;
        }
        double x = RangesKt.coerceIn((double)((gen - min) / (max - min)), (double)0.0, (double)1.0);
        double res = Math.pow(x, 2) * ((double)3 - (double)2 * x);
        return res;
    }

    @JvmStatic
    public static final float smoothStep(float min, float max, float gen) {
        if (gen <= min) {
            return 0.0f;
        }
        if (gen >= max) {
            return 1.0f;
        }
        float x = RangesKt.coerceIn((float)((gen - min) / (max - min)), (float)0.0f, (float)1.0f);
        float res = (float)Math.pow(x, 2) * ((float)3 - (float)2 * x);
        return res;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 mix(@NotNull Vec3 c1, @NotNull Vec3 c2, double delta) {
        Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
        Vector3f vector3f = c1.toVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"toVector3f(...)");
        Vector3f vector3f2 = c2.toVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"toVector3f(...)");
        return new Vec3(GraphMathHelper.mix(vector3f, vector3f2, delta));
    }

    @JvmStatic
    @NotNull
    public static final Vec3 mix(@NotNull Vec3 c1, @NotNull Vec3 c2, float delta) {
        Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
        Vector3f vector3f = c1.toVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"toVector3f(...)");
        Vector3f vector3f2 = c2.toVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"toVector3f(...)");
        return new Vec3(GraphMathHelper.mix(vector3f, vector3f2, delta));
    }

    @JvmStatic
    @NotNull
    public static final Vector3f mix(@NotNull Vector3f c1, @NotNull Vector3f c2, double delta) {
        Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
        float x = GraphMathHelper.lerp(delta, c1.x, c2.x);
        float y = GraphMathHelper.lerp(delta, c1.y, c2.y);
        float z = GraphMathHelper.lerp(delta, c1.z, c2.z);
        return new Vector3f(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final Vector3f mix(@NotNull Vector3f c1, @NotNull Vector3f c2, float delta) {
        Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
        float x = GraphMathHelper.lerp(delta, c1.x, c2.x);
        float y = GraphMathHelper.lerp(delta, c1.y, c2.y);
        float z = GraphMathHelper.lerp(delta, c1.z, c2.z);
        return new Vector3f(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final Vec3 lerp(@NotNull Vec3 delta, @NotNull Vec3 min, @NotNull Vec3 max) {
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        double stepX = max.x - min.x;
        double stepY = max.y - min.y;
        double stepZ = max.z - min.z;
        double mixX = GraphMathHelper.lerp(delta.x, 0.0, stepX);
        double mixY = GraphMathHelper.lerp(delta.y, 0.0, stepY);
        double mixZ = GraphMathHelper.lerp(delta.z, 0.0, stepZ);
        Vec3 vec3 = min.add(new Vec3(mixX, mixY, mixZ));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 lerp(float delta, @NotNull Vec3 min, @NotNull Vec3 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        double stepX = max.x - min.x;
        double stepY = max.y - min.y;
        double stepZ = max.z - min.z;
        double mixX = GraphMathHelper.lerp(delta, 0.0, stepX);
        double mixY = GraphMathHelper.lerp(delta, 0.0, stepY);
        double mixZ = GraphMathHelper.lerp(delta, 0.0, stepZ);
        Vec3 vec3 = min.add(new Vec3(mixX, mixY, mixZ));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    @JvmStatic
    @NotNull
    public static final Vector3f lerp(float delta, @NotNull Vector3f min, @NotNull Vector3f max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Vector3f vector3f = GraphMathHelper.lerp(delta, new Vec3(min), new Vec3(max)).toVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"toVector3f(...)");
        return vector3f;
    }

    @JvmStatic
    @NotNull
    public static final Vector3f lerp(double delta, @NotNull Vector3f min, @NotNull Vector3f max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Vector3f vector3f = GraphMathHelper.lerp(delta, new Vec3(min), new Vec3(max)).toVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"toVector3f(...)");
        return vector3f;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 lerp(double delta, @NotNull Vec3 min, @NotNull Vec3 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        double stepX = max.x - min.x;
        double stepY = max.y - min.y;
        double stepZ = max.z - min.z;
        double mixX = GraphMathHelper.lerp(delta, 0.0, stepX);
        double mixY = GraphMathHelper.lerp(delta, 0.0, stepY);
        double mixZ = GraphMathHelper.lerp(delta, 0.0, stepZ);
        Vec3 vec3 = min.add(new Vec3(mixX, mixY, mixZ));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    @JvmStatic
    @NotNull
    public static final Vector3f lerp(@NotNull Vector3f delta, @NotNull Vector3f min, @NotNull Vector3f max) {
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        float stepX = max.x - min.x;
        float stepY = max.y - min.y;
        float stepZ = max.z - min.z;
        float mixX = GraphMathHelper.lerp(delta.x, 0.0f, stepX);
        float mixY = GraphMathHelper.lerp(delta.y, 0.0f, stepY);
        float mixZ = GraphMathHelper.lerp(delta.z, 0.0f, stepZ);
        Vector3f vector3f = min.add(mixX, mixY, mixZ, new Vector3f());
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"add(...)");
        return vector3f;
    }

    public final double step(double limit, double enter) {
        return limit > enter ? 0.0 : 1.0;
    }

    public final float step(float limit, float enter) {
        return limit > enter ? 0.0f : 1.0f;
    }

    @JvmStatic
    public static final double lerp(double delta, double min, double max) {
        double mixFix = RangesKt.coerceIn((double)delta, (double)0.0, (double)1.0);
        return min + (max - min) * mixFix;
    }

    @JvmStatic
    public static final float lerp(double delta, float min, float max) {
        double mixFix = RangesKt.coerceIn((double)delta, (double)0.0, (double)1.0);
        return min + (max - min) * (float)mixFix;
    }

    @JvmStatic
    public static final double lerp(float delta, double min, double max) {
        float mixFix = RangesKt.coerceIn((float)delta, (float)0.0f, (float)1.0f);
        return min + (max - min) * (double)mixFix;
    }

    @JvmStatic
    public static final float lerp(float delta, float min, float max) {
        float mixFix = RangesKt.coerceIn((float)delta, (float)0.0f, (float)1.0f);
        return min + (max - min) * mixFix;
    }

    @JvmStatic
    @NotNull
    public static final LinerLevelLerp levelLerp() {
        return new LinerLevelLerp();
    }
}

