/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils;

import cn.coostack.cooparticlesapi.network.packet.PacketCameraShakeS2C;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Lcn/coostack/cooparticlesapi/utils/ServerCameraUtil;", "", "<init>", "()V", "sendShake", "", "world", "Lnet/minecraft/server/level/ServerLevel;", "amplitude", "", "tick", "", "origin", "Lnet/minecraft/world/phys/Vec3;", "range", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nServerCameraUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerCameraUtil.kt\ncn/coostack/cooparticlesapi/utils/ServerCameraUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,28:1\n1869#2,2:29\n1869#2,2:31\n*S KotlinDebug\n*F\n+ 1 ServerCameraUtil.kt\ncn/coostack/cooparticlesapi/utils/ServerCameraUtil\n*L\n13#1:29,2\n23#1:31,2\n*E\n"})
public final class ServerCameraUtil {
    @NotNull
    public static final ServerCameraUtil INSTANCE = new ServerCameraUtil();

    private ServerCameraUtil() {
    }

    public final void sendShake(@NotNull ServerLevel world, double amplitude, int tick) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (!(tick > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(amplitude > 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        PacketCameraShakeS2C packet = new PacketCameraShakeS2C(-1.0, vec3, amplitude, tick);
        List list = world.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer it = (ServerPlayer)element$iv;
            boolean bl = false;
            CustomPacketPayload customPacketPayload = packet;
            Intrinsics.checkNotNull((Object)it);
            CooParticlesServices.SERVER_NETWORK.send(customPacketPayload, it);
        }
    }

    public final void sendShake(@NotNull ServerLevel world, @NotNull Vec3 origin, double range, double amplitude, int tick) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (!(range > 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(amplitude > 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(tick > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        PacketCameraShakeS2C packet = new PacketCameraShakeS2C(range, origin, amplitude, tick);
        List list = world.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer it = (ServerPlayer)element$iv;
            boolean bl = false;
            CustomPacketPayload customPacketPayload = packet;
            Intrinsics.checkNotNull((Object)it);
            CooParticlesServices.SERVER_NETWORK.send(customPacketPayload, it);
        }
    }
}

