/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.helper;

import cn.coostack.cooparticlesapi.particles.Controlable;
import cn.coostack.cooparticlesapi.utils.GraphMathHelper;
import cn.coostack.cooparticlesapi.utils.helper.ParticleHelper;
import kotlin.Metadata;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001a\u001a\u00020\u0000H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020$J\u000e\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010'H&J\b\u0010(\u001a\u00020\u0003H&J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H&R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001a\u0010\u0017\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\f\u00a8\u0006)"}, d2={"Lcn/coostack/cooparticlesapi/utils/helper/ScaleHelper;", "Lcn/coostack/cooparticlesapi/utils/helper/ParticleHelper;", "minScale", "", "maxScale", "scaleTick", "", "<init>", "(DDI)V", "getMinScale", "()D", "setMinScale", "(D)V", "getMaxScale", "setMaxScale", "getScaleTick", "()I", "setScaleTick", "(I)V", "value", "current", "getCurrent", "setCurrent", "step", "getStep", "setStep", "recalculateStep", "toggleScale", "", "scale", "resetScaleMin", "resetScaleMax", "doScaleTo", "doScale", "doScaleReversed", "over", "", "isZero", "getLoadedGroup", "Lcn/coostack/cooparticlesapi/particles/Controlable;", "getGroupScale", "cooparticlesapi-neoforge-1.21.1"})
public abstract class ScaleHelper
implements ParticleHelper {
    private double minScale;
    private double maxScale;
    private int scaleTick;
    private int current;
    private double step;

    public ScaleHelper(double minScale, double maxScale, int scaleTick) {
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.scaleTick = scaleTick;
        this.step = Math.abs(this.maxScale - this.minScale) / (double)this.scaleTick;
        double temp = Math.min(this.minScale, this.maxScale);
        this.maxScale = Math.max(this.minScale, this.maxScale);
        this.minScale = temp;
    }

    public final double getMinScale() {
        return this.minScale;
    }

    public final void setMinScale(double d) {
        this.minScale = d;
    }

    public final double getMaxScale() {
        return this.maxScale;
    }

    public final void setMaxScale(double d) {
        this.maxScale = d;
    }

    public final int getScaleTick() {
        return this.scaleTick;
    }

    public final void setScaleTick(int n) {
        this.scaleTick = n;
    }

    public final int getCurrent() {
        return this.current;
    }

    protected final void setCurrent(int n) {
        this.current = n;
    }

    protected final double getStep() {
        return this.step;
    }

    protected final void setStep(double d) {
        this.step = d;
    }

    @NotNull
    public ScaleHelper recalculateStep() {
        double temp = Math.min(this.minScale, this.maxScale);
        this.maxScale = Math.max(this.minScale, this.maxScale);
        this.minScale = temp;
        this.step = Math.abs(this.maxScale - this.minScale) / (double)this.scaleTick;
        return this;
    }

    public void toggleScale(double scale) {
        int tick;
        if (scale <= this.minScale) {
            this.resetScaleMin();
            return;
        }
        if (scale >= this.maxScale) {
            this.current = this.scaleTick;
            this.resetScaleMax();
            return;
        }
        double point = scale - this.minScale;
        this.current = tick = MathKt.roundToInt((double)(point / this.step));
        this.doScaleTo(this.current);
    }

    public final void resetScaleMin() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        this.current = 0;
        this.scale(this.minScale);
    }

    public final void resetScaleMax() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        this.current = this.scaleTick - 1;
        this.scale(this.maxScale);
    }

    public void doScaleTo(int current) {
        int enter;
        if (this.getLoadedGroup() == null) {
            return;
        }
        this.current = enter = RangesKt.coerceAtLeast((int)current, (int)0);
        if (current >= this.scaleTick - 1) {
            this.resetScaleMax();
            return;
        }
        if (current <= 0) {
            this.resetScaleMin();
            return;
        }
        double lerp = GraphMathHelper.lerp((double)current / (double)this.scaleTick, this.minScale, this.maxScale);
        this.scale(lerp);
    }

    public void doScale() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        if (this.over()) {
            return;
        }
        int n = this.current;
        this.current = n + 1;
        double lerp = GraphMathHelper.lerp((double)this.current / (double)this.scaleTick, this.minScale, this.maxScale);
        this.scale(lerp);
    }

    public void doScaleReversed() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        if (this.isZero()) {
            return;
        }
        int n = this.current;
        this.current = n + -1;
        double lerp = GraphMathHelper.lerp((double)this.current / (double)this.scaleTick, this.minScale, this.maxScale);
        this.scale(lerp);
    }

    public boolean over() {
        return this.scaleTick <= this.current;
    }

    public final boolean isZero() {
        return this.current <= 0;
    }

    @Nullable
    public abstract Controlable<?> getLoadedGroup();

    public abstract double getGroupScale();

    public abstract void scale(double var1);
}

