/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.helper.impl;

import cn.coostack.cooparticlesapi.network.particle.style.SequencedParticleStyle;
import cn.coostack.cooparticlesapi.particles.Controlable;
import cn.coostack.cooparticlesapi.utils.helper.ProgressSequencedHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0003J\u0014\u0010\u0015\u001a\u00020\n2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcn/coostack/cooparticlesapi/utils/helper/impl/StyleProgressSequencedHelper;", "Lcn/coostack/cooparticlesapi/utils/helper/ProgressSequencedHelper;", "maxCount", "", "progressMaxTick", "<init>", "(II)V", "linkedStyle", "Lcn/coostack/cooparticlesapi/network/particle/style/SequencedParticleStyle;", "addMultiple", "", "count", "removeMultiple", "getLoadedStyle", "changeStatusBatch", "indexes", "", "status", "", "syncProgressFromServer", "current", "loadControler", "controler", "Lcn/coostack/cooparticlesapi/particles/Controlable;", "cooparticlesapi-neoforge-1.21.1"})
public final class StyleProgressSequencedHelper
extends ProgressSequencedHelper {
    @Nullable
    private SequencedParticleStyle linkedStyle;

    public StyleProgressSequencedHelper(int maxCount, int progressMaxTick) {
        super(maxCount, progressMaxTick);
    }

    @Override
    public void addMultiple(int count) {
        SequencedParticleStyle sequencedParticleStyle = this.linkedStyle;
        Intrinsics.checkNotNull((Object)sequencedParticleStyle);
        sequencedParticleStyle.addMultiple(count);
    }

    @Override
    public void removeMultiple(int count) {
        SequencedParticleStyle sequencedParticleStyle = this.linkedStyle;
        Intrinsics.checkNotNull((Object)sequencedParticleStyle);
        sequencedParticleStyle.removeMultiple(count);
    }

    @Nullable
    public SequencedParticleStyle getLoadedStyle() {
        return this.linkedStyle;
    }

    @Override
    protected void changeStatusBatch(@NotNull int[] indexes, boolean status) {
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        SequencedParticleStyle sequencedParticleStyle = this.linkedStyle;
        Intrinsics.checkNotNull((Object)sequencedParticleStyle);
        sequencedParticleStyle.changeParticlesStatus(indexes, status);
    }

    public final void syncProgressFromServer(int current) {
        this.setCurrent(RangesKt.coerceIn((int)current, (int)0, (int)this.getProgressMaxTick()));
        int targetCount = MathKt.roundToInt((double)((double)current / (double)this.getProgressMaxTick() * (double)this.getMaxCount()));
        SequencedParticleStyle sequencedParticleStyle = this.linkedStyle;
        Intrinsics.checkNotNull((Object)sequencedParticleStyle);
        SequencedParticleStyle it = sequencedParticleStyle;
        boolean bl = false;
        int currentActive = it.getDisplayedParticleCount();
        if (targetCount > currentActive) {
            it.addMultiple(targetCount - currentActive);
        } else if (targetCount < currentActive) {
            it.removeMultiple(currentActive - targetCount);
        }
    }

    @Override
    public void loadControler(@NotNull Controlable<?> controler) {
        Intrinsics.checkNotNullParameter(controler, (String)"controler");
        if (!(controler instanceof SequencedParticleStyle)) {
            return;
        }
        this.linkedStyle = (SequencedParticleStyle)controler;
    }
}

