/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.interpolator;

import cn.coostack.cooparticlesapi.utils.CircularQueue;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.interpolator.Interpolator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0012H\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcn/coostack/cooparticlesapi/utils/interpolator/LineInterpolator;", "Lcn/coostack/cooparticlesapi/utils/interpolator/Interpolator;", "<init>", "()V", "queue", "Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "getQueue", "()Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "refinerCount", "", "getRefinerCount", "()D", "setRefinerCount", "(D)V", "insertPoint", "vec", "Lnet/minecraft/world/phys/Vec3;", "Lorg/joml/Vector3f;", "setRefiner", "refiner", "getRefinedResult", "", "cooparticlesapi-neoforge-1.21.1"})
public final class LineInterpolator
implements Interpolator {
    @NotNull
    private final CircularQueue<RelativeLocation> queue = new CircularQueue(2);
    private double refinerCount = 1.0;

    @NotNull
    public final CircularQueue<RelativeLocation> getQueue() {
        return this.queue;
    }

    public final double getRefinerCount() {
        return this.refinerCount;
    }

    public final void setRefinerCount(double d) {
        this.refinerCount = d;
    }

    @Override
    @NotNull
    public LineInterpolator insertPoint(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        this.queue.addFirst(RelativeLocation.Companion.of(vec));
        return this;
    }

    @Override
    @NotNull
    public LineInterpolator insertPoint(@NotNull Vector3f vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        this.queue.addFirst(new RelativeLocation(vec.x, vec.y, vec.z));
        return this;
    }

    @Override
    @NotNull
    public LineInterpolator insertPoint(@NotNull RelativeLocation vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        this.queue.addFirst(vec.clone());
        return this;
    }

    @Override
    @NotNull
    public LineInterpolator setRefiner(double refiner) {
        this.refinerCount = RangesKt.coerceAtLeast((double)refiner, (double)0.001);
        return this;
    }

    @Override
    @NotNull
    public List<RelativeLocation> getRefinedResult() {
        if (this.queue.empty()) {
            return new ArrayList();
        }
        if (this.queue.notNullSize() == 1) {
            Object[] objectArray = new RelativeLocation[]{this.queue.get(0)};
            return CollectionsKt.arrayListOf((Object[])objectArray);
        }
        return Math3DUtil.INSTANCE.fillLine(this.queue.get(0), this.queue.get(1), this.refinerCount);
    }
}

