/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.animation;

import cn.coostack.cooparticlesapi.animation.StreamAnimation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003J\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u001d\u0010\u000e\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcn/coostack/cooparticlesapi/animation/AnimateManager;", "", "<init>", "()V", "Lcn/coostack/cooparticlesapi/animation/StreamAnimation;", "animation", "", "addClient", "(Lcn/coostack/cooparticlesapi/animation/StreamAnimation;)V", "addServer", "tickServer", "tickClient", "", "iterator", "tick", "(Ljava/util/Iterator;)V", "", "serverAnimates", "Ljava/util/List;", "getServerAnimates", "()Ljava/util/List;", "clientAnimates", "getClientAnimates", "cooparticlesapi-fabric-1.21.1"})
public final class AnimateManager {
    @NotNull
    public static final AnimateManager INSTANCE = new AnimateManager();
    @NotNull
    private static final List<StreamAnimation> serverAnimates = new ArrayList();
    @NotNull
    private static final List<StreamAnimation> clientAnimates = new ArrayList();

    private AnimateManager() {
    }

    @NotNull
    public final List<StreamAnimation> getServerAnimates() {
        return serverAnimates;
    }

    @NotNull
    public final List<StreamAnimation> getClientAnimates() {
        return clientAnimates;
    }

    public final void addClient(@NotNull StreamAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        clientAnimates.add(animation);
    }

    public final void addServer(@NotNull StreamAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        serverAnimates.add(animation);
    }

    public final void tickServer() {
        Iterator<StreamAnimation> iterator = serverAnimates.iterator();
        this.tick(iterator);
    }

    public final void tickClient() {
        Iterator<StreamAnimation> iterator = clientAnimates.iterator();
        this.tick(iterator);
    }

    private final void tick(Iterator<StreamAnimation> iterator) {
        while (iterator.hasNext()) {
            StreamAnimation anim = iterator.next();
            anim.tick();
            if (!anim.getCanceled()) continue;
            iterator.remove();
        }
    }
}

