/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer;

import cn.coostack.cooparticlesapi.network.packet.PacketRenderEntityS2C;
import cn.coostack.cooparticlesapi.network.particle.ServerControler;
import cn.coostack.cooparticlesapi.renderer.server.ServerRenderEntityManager;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 s2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001sB\u001b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0015\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u001c\u0010\nJ\u000f\u0010\u001e\u001a\u00020\bH&\u00a2\u0006\u0004\b\u001e\u0010\nJ\u001b\u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00000\u001fH&\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020#H&\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\bH&\u00a2\u0006\u0004\b&\u0010\nJ\u0017\u0010(\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b(\u0010\u0013J'\u0010(\u001a\u00020\b2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)H\u0016\u00a2\u0006\u0004\b(\u0010-J\u0017\u0010/\u001a\u00020\b2\u0006\u0010'\u001a\u00020.H\u0016\u00a2\u0006\u0004\b/\u00100J\u001f\u00102\u001a\u00020\b2\u0006\u0010'\u001a\u00020.2\u0006\u00101\u001a\u00020)H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020\b2\u0006\u00101\u001a\u00020)H\u0016\u00a2\u0006\u0004\b4\u00105J\u000f\u00106\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b6\u0010\nJ\u000f\u00107\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b7\u00108J\u001f\u00109\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b9\u0010\u0007J-\u0010@\u001a\u00020\b2\u0006\u0010;\u001a\u00020:2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\u0015\u00a2\u0006\u0004\b@\u0010AJ/\u0010B\u001a\u00020\b2\u0006\u0010;\u001a\u00020:2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\u0015H&\u00a2\u0006\u0004\bB\u0010AR$\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010\u0013R\"\u0010L\u001a\u00020)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u00105R\u0011\u0010T\u001a\u00020Q8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\"\u0010\u001d\u001a\u00020Q8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010U\u001a\u0004\bV\u0010S\"\u0004\bW\u0010XR\"\u0010Y\u001a\u00020Q8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bY\u0010U\u001a\u0004\bZ\u0010S\"\u0004\b[\u0010XR$\u0010]\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b]\u0010H\u001a\u0004\b^\u0010JR\"\u0010`\u001a\u00020_8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b`\u0010a\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\"\u0010g\u001a\u00020f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010h\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\"\u0010m\u001a\u00020Q8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bm\u0010U\u001a\u0004\bn\u0010S\"\u0004\bo\u0010XR\"\u0010p\u001a\u00020Q8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bp\u0010U\u001a\u0004\bq\u0010S\"\u0004\br\u0010X\u00a8\u0006t"}, d2={"Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "Lcn/coostack/cooparticlesapi/network/particle/ServerControler;", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_243;", "pos", "<init>", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_243;)V", "", "tick", "()V", "Lcn/coostack/cooparticlesapi/network/packet/PacketRenderEntityS2C;", "getTogglePacket", "()Lcn/coostack/cooparticlesapi/network/packet/PacketRenderEntityS2C;", "Lcn/coostack/cooparticlesapi/network/packet/PacketRenderEntityS2C$Method;", "method", "getPacket", "(Lcn/coostack/cooparticlesapi/network/packet/PacketRenderEntityS2C$Method;)Lcn/coostack/cooparticlesapi/network/packet/PacketRenderEntityS2C;", "setPosition", "(Lnet/minecraft/class_243;)V", "markDirty", "", "delta", "getTime", "(F)F", "another", "loadProfileFromEntity", "(Lcn/coostack/cooparticlesapi/renderer/RenderEntity;)V", "init$cooparticlesapi_fabric_1_21_1", "init", "initialize", "Lnet/minecraft/class_9139;", "Lnet/minecraft/class_2540;", "getCodec", "()Lnet/minecraft/class_9139;", "Lnet/minecraft/class_2960;", "getRenderID", "()Lnet/minecraft/class_2960;", "release", "to", "teleportTo", "", "x", "y", "z", "(DDD)V", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "rotateParticlesToPoint", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)V", "angle", "rotateToWithAngle", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;D)V", "rotateParticlesAsAxis", "(D)V", "remove", "getValue", "()Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "spawn", "Lorg/joml/Matrix4fStack;", "matrices", "Lorg/joml/Matrix4f;", "viewMatrix", "projMatrix", "tickDelta", "renderOnWorld", "(Lorg/joml/Matrix4fStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;F)V", "render", "Lnet/minecraft/class_1937;", "getWorld", "()Lnet/minecraft/class_1937;", "setWorld", "(Lnet/minecraft/class_1937;)V", "Lnet/minecraft/class_243;", "getPos", "()Lnet/minecraft/class_243;", "setPos", "renderRange", "D", "getRenderRange", "()D", "setRenderRange", "", "getClient", "()Z", "client", "Z", "getInit", "setInit", "(Z)V", "alwaysToggle", "getAlwaysToggle", "setAlwaysToggle", "value", "lastRenderPos", "getLastRenderPos", "", "age", "I", "getAge", "()I", "setAge", "(I)V", "Ljava/util/UUID;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "dirty", "getDirty", "setDirty", "canceled", "getCanceled", "setCanceled", "Companion", "cooparticlesapi-fabric-1.21.1"})
public abstract class RenderEntity
implements ServerControler<RenderEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private class_1937 world;
    @NotNull
    private class_243 pos;
    private double renderRange;
    private boolean init;
    private boolean alwaysToggle;
    @NotNull
    private class_243 lastRenderPos;
    private int age;
    @NotNull
    private UUID uuid;
    private boolean dirty;
    private boolean canceled;

    public RenderEntity(@Nullable class_1937 world, @NotNull class_243 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.world = world;
        this.pos = pos;
        this.renderRange = 256.0;
        this.lastRenderPos = this.pos;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
    }

    public /* synthetic */ RenderEntity(class_1937 class_19372, class_243 class_2432, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            class_243 class_2433 = class_243.field_1353;
            Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"ZERO");
            class_2432 = class_2433;
        }
        this(class_19372, class_2432);
    }

    @Nullable
    public final class_1937 getWorld() {
        return this.world;
    }

    public final void setWorld(@Nullable class_1937 class_19372) {
        this.world = class_19372;
    }

    @NotNull
    public final class_243 getPos() {
        return this.pos;
    }

    public final void setPos(@NotNull class_243 class_2432) {
        Intrinsics.checkNotNullParameter((Object)class_2432, (String)"<set-?>");
        this.pos = class_2432;
    }

    public final double getRenderRange() {
        return this.renderRange;
    }

    public final void setRenderRange(double d) {
        this.renderRange = d;
    }

    public final boolean getClient() {
        class_1937 class_19372 = this.world;
        return class_19372 != null ? class_19372.field_9236 : false;
    }

    public final boolean getInit() {
        return this.init;
    }

    public final void setInit(boolean bl) {
        this.init = bl;
    }

    public final boolean getAlwaysToggle() {
        return this.alwaysToggle;
    }

    public final void setAlwaysToggle(boolean bl) {
        this.alwaysToggle = bl;
    }

    @NotNull
    public final class_243 getLastRenderPos() {
        return this.lastRenderPos;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public final void setUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.uuid = uUID;
    }

    public final boolean getDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public final boolean getCanceled() {
        return this.canceled;
    }

    public final void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public void tick() {
        if (this.canceled) {
            return;
        }
        int n = this.age;
        this.age = n + 1;
    }

    @Nullable
    public final PacketRenderEntityS2C getTogglePacket() {
        return this.getPacket(PacketRenderEntityS2C.Method.TOGGLE);
    }

    @Nullable
    public final PacketRenderEntityS2C getPacket(@NotNull PacketRenderEntityS2C.Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        if (!this.dirty && method == PacketRenderEntityS2C.Method.TOGGLE) {
            return null;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.getCodec().encode((Object)buf, (Object)this);
        PacketRenderEntityS2C packet = new PacketRenderEntityS2C(this.uuid, (ByteBuf)buf, this.getRenderID(), method);
        return packet;
    }

    public final void setPosition(@NotNull class_243 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.pos = pos;
        this.markDirty();
    }

    public final void markDirty() {
        this.dirty = true;
    }

    public final float getTime(float delta) {
        return ((float)this.age + delta) / (float)20;
    }

    public void loadProfileFromEntity(@NotNull RenderEntity another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        this.age = another.age;
        this.canceled = another.canceled;
        this.pos = another.pos;
        this.uuid = another.uuid;
        this.world = another.world;
    }

    public final void init$cooparticlesapi_fabric_1_21_1() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.initialize();
    }

    public abstract void initialize();

    @NotNull
    public abstract class_9139<class_2540, RenderEntity> getCodec();

    @NotNull
    public abstract class_2960 getRenderID();

    public abstract void release();

    @Override
    public void teleportTo(@NotNull class_243 to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.lastRenderPos = this.pos;
        this.pos = to;
    }

    @Override
    public void teleportTo(double x, double y, double z) {
        this.teleportTo(new class_243(x, y, z));
    }

    @Override
    public void rotateParticlesToPoint(@NotNull RelativeLocation to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
    }

    @Override
    public void rotateToWithAngle(@NotNull RelativeLocation to, double angle) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
    }

    @Override
    public void rotateParticlesAsAxis(double angle) {
    }

    @Override
    public void remove() {
        this.canceled = true;
    }

    @Override
    @NotNull
    public RenderEntity getValue() {
        return this;
    }

    @Override
    public void spawn(@NotNull class_1937 world, @NotNull class_243 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!(world instanceof class_3218)) {
            return;
        }
        this.world = world;
        this.pos = pos;
        ServerRenderEntityManager.INSTANCE.spawn(this);
    }

    public final void renderOnWorld(@NotNull Matrix4fStack matrices, @NotNull Matrix4f viewMatrix, @NotNull Matrix4f projMatrix, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)viewMatrix, (String)"viewMatrix");
        Intrinsics.checkNotNullParameter((Object)projMatrix, (String)"projMatrix");
        this.lastRenderPos = this.pos;
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        this.render(matrices, viewMatrix, projMatrix, tickDelta);
    }

    public abstract void render(@NotNull Matrix4fStack var1, @NotNull Matrix4f var2, @NotNull Matrix4f var3, float var4);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcn/coostack/cooparticlesapi/renderer/RenderEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2540;", "buf", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "instance", "", "decodeBase", "(Lnet/minecraft/class_2540;Lcn/coostack/cooparticlesapi/renderer/RenderEntity;)V", "entity", "encodeBase", "cooparticlesapi-fabric-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void decodeBase(@NotNull class_2540 buf, @NotNull RenderEntity instance) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            UUID uUID = buf.method_10790();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
            instance.setUuid(uUID);
            class_243 class_2432 = buf.method_52996();
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"readVec3(...)");
            instance.setPos(class_2432);
            instance.setCanceled(buf.readBoolean());
            instance.setAge(buf.readInt());
            instance.setDirty(false);
        }

        public final void encodeBase(@NotNull class_2540 buf, @NotNull RenderEntity entity) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            buf.method_10797(entity.getUuid());
            buf.method_52955(entity.getPos());
            buf.method_52964(entity.getCanceled());
            buf.method_53002(entity.getAge());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

