/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.client;

import cn.coostack.cooparticlesapi.exceptions.RenderPipeNotFoundException;
import cn.coostack.cooparticlesapi.renderer.RenderEntity;
import cn.coostack.cooparticlesapi.renderer.client.ClientRenderPipelineManager;
import cn.coostack.cooparticlesapi.renderer.client.RenderUtil;
import cn.coostack.cooparticlesapi.renderer.client.ShaderPipeManagers;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.manager.ShaderPipeManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J)\u0010\f\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u0014\u00a2\u0006\u0004\b\f\u0010\u0017J#\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\rJ\u0015\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010#\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 \u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0004\u00a2\u0006\u0004\b%\u0010\u0003R\u0017\u0010'\u001a\u00020&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R0\u0010-\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0+j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b`,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.RP\u00101\u001a>\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0/j\b\u0012\u0004\u0012\u00020\b`00+j\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0/j\b\u0012\u0004\u0012\u00020\b`0`,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u0010.R0\u00102\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0+j\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e`,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010.RH\u00103\u001a6\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u00140+j\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u0014`,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u0010.\u00a8\u00064"}, d2={"Lcn/coostack/cooparticlesapi/renderer/client/ClientRenderEntityManager;", "", "<init>", "()V", "", "init", "Ljava/util/UUID;", "uuid", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "getFrom", "(Ljava/util/UUID;)Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "entity", "register", "(Lcn/coostack/cooparticlesapi/renderer/RenderEntity;)V", "Lnet/minecraft/class_2960;", "type", "pipeID", "bindEntityRenderPipe", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;)V", "id", "Lnet/minecraft/class_9139;", "Lnet/minecraft/class_2540;", "codec", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_9139;)V", "getCodecFromID", "(Lnet/minecraft/class_2960;)Lnet/minecraft/class_9139;", "clear", "add", "getPipeIDFromType", "(Lnet/minecraft/class_2960;)Lnet/minecraft/class_2960;", "", "tickDelta", "Lorg/joml/Matrix4f;", "viewMatrix", "projMatrix", "renderTick", "(FLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", "tick", "Lnet/minecraft/class_310;", "minecraft", "Lnet/minecraft/class_310;", "getMinecraft", "()Lnet/minecraft/class_310;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "entities", "Ljava/util/HashMap;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "entitiesPipeClassifier", "entityPipeType", "entityCodecs", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nClientRenderEntityManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientRenderEntityManager.kt\ncn/coostack/cooparticlesapi/renderer/client/ClientRenderEntityManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n640#2:119\n640#2:121\n216#2,2:130\n1#3:120\n1#3:122\n382#4,7:123\n1869#5,2:132\n*S KotlinDebug\n*F\n+ 1 ClientRenderEntityManager.kt\ncn/coostack/cooparticlesapi/renderer/client/ClientRenderEntityManager\n*L\n54#1:119\n57#1:121\n78#1:130,2\n54#1:120\n57#1:122\n69#1:123,7\n87#1:132,2\n*E\n"})
public final class ClientRenderEntityManager {
    @NotNull
    public static final ClientRenderEntityManager INSTANCE = new ClientRenderEntityManager();
    @NotNull
    private static final class_310 minecraft;
    @NotNull
    private static final HashMap<UUID, RenderEntity> entities;
    @NotNull
    private static final HashMap<class_2960, HashSet<RenderEntity>> entitiesPipeClassifier;
    @NotNull
    private static final HashMap<class_2960, class_2960> entityPipeType;
    @NotNull
    private static final HashMap<class_2960, class_9139<class_2540, RenderEntity>> entityCodecs;

    private ClientRenderEntityManager() {
    }

    @NotNull
    public final class_310 getMinecraft() {
        return minecraft;
    }

    public final void init() {
    }

    @Nullable
    public final RenderEntity getFrom(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return entities.get(uuid);
    }

    public final void register(@NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ((Map)entityCodecs).put(entity.getRenderID(), entity.getCodec());
    }

    public final void bindEntityRenderPipe(@NotNull class_2960 type, @NotNull class_2960 pipeID) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pipeID, (String)"pipeID");
        ((Map)entityPipeType).put(type, pipeID);
    }

    public final void register(@NotNull class_2960 id, @NotNull class_9139<class_2540, RenderEntity> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        ((Map)entityCodecs).put(id, codec);
        this.bindEntityRenderPipe(id, ShaderPipeManagers.INSTANCE.getDefault().getPipeID());
    }

    @Nullable
    public final class_9139<class_2540, RenderEntity> getCodecFromID(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return entityCodecs.get(id);
    }

    public final void clear() {
        Map.Entry it;
        Map.Entry element$iv;
        Map map;
        Map $this$onEach$iv = entities;
        boolean $i$f$onEach = false;
        Map $this$onEach_u24lambda_u242$iv = map = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl2 = false;
            ((RenderEntity)it.getValue()).release();
        }
        ((HashMap)map).clear();
        $this$onEach$iv = entitiesPipeClassifier;
        $i$f$onEach = false;
        $this$onEach_u24lambda_u242$iv = map = $this$onEach$iv;
        bl = false;
        iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            it = element$iv = iterator.next();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(((HashSet)it.getValue()).iterator(), (String)"iterator(...)");
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                RenderEntity entity = (RenderEntity)e;
                entity.release();
            }
        }
        ((HashMap)map).clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull RenderEntity entity) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.setWorld((class_1937)ClientRenderEntityManager.minecraft.field_1687);
        entity.init$cooparticlesapi_fabric_1_21_1();
        ((Map)entities).put(entity.getUuid(), entity);
        class_2960 pipe = this.getPipeIDFromType(entity.getRenderID());
        Map map = entitiesPipeClassifier;
        class_2960 key$iv = pipe;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashSet answer$iv = new HashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((HashSet)object).add(entity);
    }

    @NotNull
    public final class_2960 getPipeIDFromType(@NotNull class_2960 type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        class_2960 class_29602 = entityPipeType.get(type);
        if (class_29602 == null) {
            class_29602 = ShaderPipeManagers.INSTANCE.getDefault().getPipeID();
        }
        return class_29602;
    }

    public final void renderTick(float tickDelta, @NotNull Matrix4f viewMatrix, @NotNull Matrix4f projMatrix) {
        Intrinsics.checkNotNullParameter((Object)viewMatrix, (String)"viewMatrix");
        Intrinsics.checkNotNullParameter((Object)projMatrix, (String)"projMatrix");
        Matrix4fStack stack = new Matrix4fStack(16);
        Map $this$forEach$iv = entitiesPipeClassifier;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ShaderPipeManager pipe;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            class_2960 pipeID = (class_2960)it.getKey();
            HashSet entities = (HashSet)it.getValue();
            if (ClientRenderPipelineManager.INSTANCE.getPipeManager(pipeID) == null) {
                ClientRenderEntityManager it2 = INSTANCE;
                boolean bl2 = false;
                throw new RenderPipeNotFoundException(pipeID);
            }
            pipe.updateGlobalUniform("viewMat", viewMatrix);
            pipe.updateGlobalUniform("projMat", projMatrix);
            pipe.writeFrame(() -> ClientRenderEntityManager.renderTick$lambda$6$lambda$5(entities, stack, tickDelta, viewMatrix, projMatrix, pipe));
            RenderSystem.depthMask((boolean)false);
            pipe.render();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public final void tick() {
        Iterator iterator = ((Map)entities).entrySet().iterator();
        while (iterator.hasNext()) {
            class_2960 targetPipe;
            Map.Entry entry = iterator.next();
            RenderEntity entity = (RenderEntity)entry.getValue();
            entity.tick();
            if (!entity.getCanceled()) continue;
            if (entityPipeType.get(entity.getRenderID()) == null) {
                ClientRenderEntityManager it = this;
                boolean bl = false;
                throw new RenderPipeNotFoundException(entity.getRenderID());
            }
            HashSet<RenderEntity> hashSet = entitiesPipeClassifier.get(targetPipe);
            if (hashSet != null) {
                hashSet.remove(entity);
            }
            entity.release();
            iterator.remove();
        }
    }

    private static final void renderTick$lambda$6$lambda$5(HashSet $entities, Matrix4fStack $stack, float $tickDelta, Matrix4f $viewMatrix, Matrix4f $projMatrix, ShaderPipeManager $pipe) {
        Iterable $this$forEach$iv = $entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderEntity entity = (RenderEntity)element$iv;
            boolean bl = false;
            $stack.pushMatrix();
            RenderUtil.setRenderStackWithEntity($stack, entity, $tickDelta);
            entity.renderOnWorld($stack, $viewMatrix, $projMatrix, $tickDelta);
            $pipe.updateGlobalUniform("transMat", $stack);
            $stack.popMatrix();
        }
    }

    static {
        class_310 class_3102 = class_310.method_1551();
        Intrinsics.checkNotNullExpressionValue((Object)class_3102, (String)"getInstance(...)");
        minecraft = class_3102;
        entities = new HashMap();
        entitiesPipeClassifier = new HashMap();
        entityPipeType = new HashMap();
        entityCodecs = new HashMap();
    }
}

