/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader;

import cn.coostack.cooparticlesapi.renderer.shader.api.CooShaderProgram;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix2f;
import org.joml.Matrix3f;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Matrix4x3f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL33;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\tJ\u000f\u0010\f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\f\u0010\tJ(\u0010\u0010\u001a\u00020\u00072\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0012\u0010\tR\"\u0010\u0003\u001a\u00020\u00028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0004\u001a\u00020\u00028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\"\u0010\u001b\u001a\u00020\u001a8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\u001c\u00a8\u0006\""}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/SimpleShaderProgram;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "vertexShader", "fragmentShader", "<init>", "(Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;)V", "", "init", "()V", "use", "reset", "release", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "drawMethod", "useOnContext", "(Lkotlin/jvm/functions/Function1;)V", "assertProgram", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "getVertexShader", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "setVertexShader", "(Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;)V", "getFragmentShader", "setFragmentShader", "", "program", "I", "getProgram", "()I", "setProgram", "(I)V", "prevProgram", "cooparticlesapi-fabric-1.21.1"})
public final class SimpleShaderProgram
implements CooShaderProgram {
    @NotNull
    private GlShader vertexShader;
    @NotNull
    private GlShader fragmentShader;
    private int program;
    private int prevProgram;

    public SimpleShaderProgram(@NotNull GlShader vertexShader, @NotNull GlShader fragmentShader) {
        Intrinsics.checkNotNullParameter((Object)vertexShader, (String)"vertexShader");
        Intrinsics.checkNotNullParameter((Object)fragmentShader, (String)"fragmentShader");
        this.vertexShader = vertexShader;
        this.fragmentShader = fragmentShader;
    }

    @Override
    @NotNull
    public GlShader getVertexShader() {
        return this.vertexShader;
    }

    @Override
    public void setVertexShader(@NotNull GlShader glShader) {
        Intrinsics.checkNotNullParameter((Object)glShader, (String)"<set-?>");
        this.vertexShader = glShader;
    }

    @Override
    @NotNull
    public GlShader getFragmentShader() {
        return this.fragmentShader;
    }

    @Override
    public void setFragmentShader(@NotNull GlShader glShader) {
        Intrinsics.checkNotNullParameter((Object)glShader, (String)"<set-?>");
        this.fragmentShader = glShader;
    }

    @Override
    public int getProgram() {
        return this.program;
    }

    @Override
    public void setProgram(int n) {
        this.program = n;
    }

    @Override
    public void init() {
        this.setProgram(GL33.glCreateProgram());
        this.getVertexShader().compile();
        this.getFragmentShader().compile();
        GL33.glAttachShader((int)this.getProgram(), (int)this.getVertexShader().shaderID());
        GL33.glAttachShader((int)this.getProgram(), (int)this.getFragmentShader().shaderID());
        GL33.glLinkProgram((int)this.getProgram());
        this.assertProgram();
        this.getVertexShader().deleteShader();
        this.getFragmentShader().deleteShader();
    }

    @Override
    public void use() {
        this.prevProgram = GL33.glGetInteger((int)35725);
        GL33.glUseProgram((int)this.getProgram());
    }

    @Override
    public void reset() {
        GL33.glUseProgram((int)this.prevProgram);
    }

    @Override
    public void release() {
        if (this.getProgram() > 0) {
            GL33.glDeleteProgram((int)this.getProgram());
        }
    }

    @Override
    public void useOnContext(@NotNull Function1<? super CooShaderProgram, Unit> drawMethod) {
        Intrinsics.checkNotNullParameter(drawMethod, (String)"drawMethod");
        this.use();
        drawMethod.invoke((Object)this);
        this.reset();
    }

    private final void assertProgram() {
        if (!(GL33.glGetProgrami((int)this.getProgram(), (int)35714) != 0)) {
            boolean bl = false;
            String string = "program " + this.getProgram() + " link error: " + GL33.glGetProgramInfoLog((int)this.getProgram());
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void setInt(@NotNull String key, int value) {
        CooShaderProgram.super.setInt(key, value);
    }

    @Override
    public void setBoolean(@NotNull String key, boolean value) {
        CooShaderProgram.super.setBoolean(key, value);
    }

    @Override
    public void setFloat(@NotNull String key, float value) {
        CooShaderProgram.super.setFloat(key, value);
    }

    @Override
    public void setFloat2(@NotNull String key, @NotNull Vector2f value) {
        CooShaderProgram.super.setFloat2(key, value);
    }

    @Override
    public void setFloat3(@NotNull String key, @NotNull Vector3f value) {
        CooShaderProgram.super.setFloat3(key, value);
    }

    @Override
    public void setFloat4(@NotNull String key, @NotNull Vector4f value) {
        CooShaderProgram.super.setFloat4(key, value);
    }

    @Override
    public void setMatrix4(@NotNull String key, @NotNull Matrix4f value) {
        CooShaderProgram.super.setMatrix4(key, value);
    }

    @Override
    public void setMatrix4x3(@NotNull String key, @NotNull Matrix4x3f value) {
        CooShaderProgram.super.setMatrix4x3(key, value);
    }

    @Override
    public void setMatrix3x2(@NotNull String key, @NotNull Matrix3x2f value) {
        CooShaderProgram.super.setMatrix3x2(key, value);
    }

    @Override
    public void setMatrix3f(@NotNull String key, @NotNull Matrix3f value) {
        CooShaderProgram.super.setMatrix3f(key, value);
    }

    @Override
    public void setMatrix2f(@NotNull String key, @NotNull Matrix2f value) {
        CooShaderProgram.super.setMatrix2f(key, value);
    }
}

