/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.glsl;

import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShaderType;
import cn.coostack.cooparticlesapi.renderer.shader.utils.GlslUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL33;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\rJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/glsl/FileShader;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "", "path", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShaderType;", "type", "<init>", "(Ljava/lang/String;Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShaderType;)V", "", "shaderID", "()I", "", "compile", "()V", "assertCompiled", "deleteShader", "readFromJar", "()Ljava/lang/String;", "Ljava/lang/String;", "getPath", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShaderType;", "getType", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShaderType;", "I", "cooparticlesapi-fabric-1.21.1"})
public final class FileShader
implements GlShader {
    @NotNull
    private final String path;
    @NotNull
    private final GlShaderType type;
    private int shaderID;

    public FileShader(@NotNull String path, @NotNull GlShaderType type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.path = path;
        this.type = type;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public GlShaderType getType() {
        return this.type;
    }

    @Override
    public int shaderID() {
        return this.shaderID;
    }

    @Override
    public void compile() {
        this.shaderID = GL33.glCreateShader((int)this.getType().getGl());
        GL33.glShaderSource((int)this.shaderID, (CharSequence)this.readFromJar());
        GL33.glCompileShader((int)this.shaderID);
        this.assertCompiled();
    }

    @Override
    public void assertCompiled() {
        boolean bl;
        boolean bl2 = bl = GL33.glGetShaderi((int)this.shaderID, (int)35713) != 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "compile code failed info:" + GL33.glGetShaderInfoLog((int)this.shaderID);
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public void deleteShader() {
        GL33.glDeleteShader((int)this.shaderID);
    }

    private final String readFromJar() {
        return GlslUtil.INSTANCE.readGlslCodeFromJar(this.path);
    }
}

