/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.utils;

import cn.coostack.cooparticlesapi.renderer.shader.data.TextureData;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBImage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/utils/GlslUtil;", "", "<init>", "()V", "", "name", "readGlslCodeFromJar", "(Ljava/lang/String;)Ljava/lang/String;", "Lnet/minecraft/class_2960;", "id", "(Lnet/minecraft/class_2960;)Ljava/lang/String;", "Lcn/coostack/cooparticlesapi/renderer/shader/data/TextureData;", "readTextureFromJar", "(Ljava/lang/String;)Lcn/coostack/cooparticlesapi/renderer/shader/data/TextureData;", "(Lnet/minecraft/class_2960;)Lcn/coostack/cooparticlesapi/renderer/shader/data/TextureData;", "cooparticlesapi-fabric-1.21.1"})
public final class GlslUtil {
    @NotNull
    public static final GlslUtil INSTANCE = new GlslUtil();

    private GlslUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readGlslCodeFromJar(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String path = "assets/shaders/" + name;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            return "";
        }
        InputStream stream = inputStream;
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byte[] byArray = it.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            string = StringsKt.decodeToString((byte[])byArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readGlslCodeFromJar(@NotNull class_2960 id) {
        String string;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String path = "assets/" + id.method_12836() + "/shaders/" + id.method_12832();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            return "";
        }
        InputStream stream = inputStream;
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byte[] byArray = it.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            string = StringsKt.decodeToString((byte[])byArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    @NotNull
    public final TextureData readTextureFromJar(@NotNull String name) {
        ByteBuffer image;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String path = "textures/" + name;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        Intrinsics.checkNotNull((Object)inputStream);
        byte[] bytes = inputStream.readAllBytes();
        ByteBuffer read = ByteBuffer.allocateDirect(bytes.length);
        read.put(bytes);
        read.position(0);
        IntBuffer w = BufferUtils.createIntBuffer((int)1);
        IntBuffer h = BufferUtils.createIntBuffer((int)1);
        IntBuffer comp = BufferUtils.createIntBuffer((int)1);
        ByteBuffer byteBuffer = image = STBImage.stbi_load_from_memory((ByteBuffer)read, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp, (int)0);
        Intrinsics.checkNotNull((Object)byteBuffer);
        TextureData data = new TextureData(byteBuffer, w.get(), h.get(), comp.get());
        return data;
    }

    @NotNull
    public final TextureData readTextureFromJar(@NotNull class_2960 id) {
        ByteBuffer image;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String path = "assets/" + id.method_12836() + "/textures/" + id.method_12832();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        Intrinsics.checkNotNull((Object)inputStream);
        byte[] bytes = inputStream.readAllBytes();
        ByteBuffer read = ByteBuffer.allocateDirect(bytes.length);
        read.put(bytes);
        read.position(0);
        IntBuffer w = BufferUtils.createIntBuffer((int)1);
        IntBuffer h = BufferUtils.createIntBuffer((int)1);
        IntBuffer comp = BufferUtils.createIntBuffer((int)1);
        ByteBuffer byteBuffer = image = STBImage.stbi_load_from_memory((ByteBuffer)read, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp, (int)0);
        Intrinsics.checkNotNull((Object)byteBuffer);
        TextureData data = new TextureData(byteBuffer, w.get(), h.get(), comp.get());
        return data;
    }
}

