/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.utils;

import cn.coostack.cooparticlesapi.renderer.shader.data.VertexData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\u000eJ+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J3\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0016\u0010\u0017J3\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0018\u0010\u0017J3\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\u0017J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ+\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ5\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b \u0010\u0017\u00a8\u0006!"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/utils/ShaderUtil;", "", "<init>", "()V", "", "w", "h", "", "Lcn/coostack/cooparticlesapi/renderer/shader/data/VertexData;", "genSquare", "(FF)Ljava/util/List;", "Lorg/joml/Vector3f;", "p1", "p2", "(Lorg/joml/Vector3f;Lorg/joml/Vector3f;)Ljava/util/List;", "r", "tessellate", "height", "genCylinder", "(FFF)Ljava/util/List;", "p3", "p4", "genSquareUV", "(Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lorg/joml/Vector3f;)Ljava/util/List;", "genSquareUVScreen", "genBox", "()Ljava/util/List;", "", "stacks", "slices", "genBall", "(FII)Ljava/util/List;", "genQuad", "cooparticlesapi-fabric-1.21.1"})
public final class ShaderUtil {
    @NotNull
    public static final ShaderUtil INSTANCE = new ShaderUtil();

    private ShaderUtil() {
    }

    @NotNull
    public final List<VertexData> genSquare(float w, float h) {
        Vector3f p1 = new Vector3f(-w / (float)2, -h / (float)2, 0.0f);
        Vector3f p2 = new Vector3f(w / (float)2, h / (float)2, 0.0f);
        return this.genSquare(p1, p2);
    }

    @NotNull
    public final List<VertexData> genSquare(@NotNull Vector3f p1, @NotNull Vector3f p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        List res = new ArrayList();
        Vector3f p3 = new Vector3f(p2.x, p1.y, p1.z);
        Vector3f p4 = new Vector3f(p1.x, p2.y, p2.z);
        res.add(new VertexData(p1));
        res.add(new VertexData(p3));
        res.add(new VertexData(p2));
        res.add(new VertexData(p1));
        res.add(new VertexData(p2));
        res.add(new VertexData(p4));
        return res;
    }

    @NotNull
    public final List<VertexData> genCylinder(float r, float tessellate, float height) {
        List res = new ArrayList();
        if (!(height > 0.0f && r > 0.0f && tessellate >= 2.0f)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        float step = (float)Math.PI * 2 / tessellate;
        float current = 0.0f;
        while ((double)current < Math.PI * 2) {
            float x1 = r * (float)Math.cos(current);
            float x2 = r * (float)Math.cos(current + step);
            float z1 = r * (float)Math.sin(current);
            float z2 = r * (float)Math.sin(current + step);
            res.addAll((Collection)this.genSquare(new Vector3f(x1, height, z1), new Vector3f(x2, height, z2), new Vector3f(x2, 0.0f, z2), new Vector3f(x1, 0.0f, z1)));
            current += step;
        }
        return res;
    }

    @NotNull
    public final List<VertexData> genSquareUV(@NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, @NotNull Vector3f p4) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
        List res = new ArrayList();
        res.add(new VertexData(p1, new Vector2f(0.0f, 0.0f)));
        res.add(new VertexData(p2, new Vector2f(1.0f, 0.0f)));
        res.add(new VertexData(p4, new Vector2f(0.0f, 1.0f)));
        res.add(new VertexData(p2, new Vector2f(1.0f, 0.0f)));
        res.add(new VertexData(p3, new Vector2f(1.0f, 1.0f)));
        res.add(new VertexData(p4, new Vector2f(0.0f, 1.0f)));
        return res;
    }

    @NotNull
    public final List<VertexData> genSquareUVScreen(@NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, @NotNull Vector3f p4) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
        List res = new ArrayList();
        res.add(new VertexData(p1, new Vector2f(0.0f, 1.0f)));
        res.add(new VertexData(p2, new Vector2f(1.0f, 1.0f)));
        res.add(new VertexData(p4, new Vector2f(0.0f, 0.0f)));
        res.add(new VertexData(p2, new Vector2f(1.0f, 1.0f)));
        res.add(new VertexData(p3, new Vector2f(1.0f, 0.0f)));
        res.add(new VertexData(p4, new Vector2f(0.0f, 0.0f)));
        return res;
    }

    @NotNull
    public final List<VertexData> genSquare(@NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, @NotNull Vector3f p4) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
        List res = new ArrayList();
        res.add(new VertexData(p1));
        res.add(new VertexData(p2));
        res.add(new VertexData(p4));
        res.add(new VertexData(p2));
        res.add(new VertexData(p3));
        res.add(new VertexData(p4));
        return res;
    }

    @NotNull
    public final List<VertexData> genBox() {
        ArrayList res;
        ArrayList arrayList;
        List<VertexData> up = this.genSquareUV(new Vector3f(-0.5f, 0.5f, 0.5f), new Vector3f(0.5f, 0.5f, 0.5f), new Vector3f(0.5f, 0.5f, -0.5f), new Vector3f(-0.5f, 0.5f, -0.5f));
        List<VertexData> down = this.genSquareUV(new Vector3f(-0.5f, -0.5f, 0.5f), new Vector3f(0.5f, -0.5f, 0.5f), new Vector3f(0.5f, -0.5f, -0.5f), new Vector3f(-0.5f, -0.5f, -0.5f));
        List<VertexData> left = this.genSquareUV(new Vector3f(-0.5f, -0.5f, 0.5f), new Vector3f(-0.5f, 0.5f, 0.5f), new Vector3f(-0.5f, 0.5f, -0.5f), new Vector3f(-0.5f, -0.5f, -0.5f));
        List<VertexData> right = this.genSquareUV(new Vector3f(0.5f, -0.5f, 0.5f), new Vector3f(0.5f, 0.5f, 0.5f), new Vector3f(0.5f, 0.5f, -0.5f), new Vector3f(0.5f, -0.5f, -0.5f));
        List<VertexData> front = this.genSquareUV(new Vector3f(-0.5f, 0.5f, 0.5f), new Vector3f(0.5f, 0.5f, 0.5f), new Vector3f(0.5f, -0.5f, 0.5f), new Vector3f(-0.5f, -0.5f, 0.5f));
        List<VertexData> back = this.genSquareUV(new Vector3f(-0.5f, 0.5f, -0.5f), new Vector3f(0.5f, 0.5f, -0.5f), new Vector3f(0.5f, -0.5f, -0.5f), new Vector3f(-0.5f, -0.5f, -0.5f));
        ArrayList it = arrayList = (res = new ArrayList());
        boolean bl = false;
        it.addAll(up);
        it.addAll(down);
        it.addAll(left);
        it.addAll(right);
        it.addAll(front);
        it.addAll(back);
        return res;
    }

    @NotNull
    public final List<VertexData> genBall(float r, int stacks, int slices) {
        float theta2;
        float theta1;
        int j;
        List res = new ArrayList();
        for (int i = 0; i < stacks; ++i) {
            float phi1 = (float)i * (float)Math.PI / (float)stacks;
            float phi2 = (float)(i + 1) * (float)Math.PI / (float)stacks;
            float r1 = r * (float)Math.sin(phi1);
            float r2 = r * (float)Math.sin(phi2);
            float y1 = r * (float)Math.cos(phi1);
            float y2 = r * (float)Math.cos(phi2);
            for (int j2 = 0; j2 < slices; ++j2) {
                float theta12 = (float)(j2 * 2) * (float)Math.PI / (float)slices;
                float theta22 = (float)((j2 + 1) * 2) * (float)Math.PI / (float)slices;
                Vector3f p1 = new Vector3f(r1 * (float)Math.cos(theta12), y1, r1 * (float)Math.sin(theta12));
                Vector3f p2 = new Vector3f(r1 * (float)Math.cos(theta22), y1, r1 * (float)Math.sin(theta22));
                Vector3f p3 = new Vector3f(r2 * (float)Math.cos(theta12), y2, r2 * (float)Math.sin(theta12));
                Vector3f p4 = new Vector3f(r2 * (float)Math.cos(theta22), y2, r2 * (float)Math.sin(theta22));
                res.addAll((Collection)this.genQuad(p1, p2, p4, p3));
            }
        }
        for (j = 0; j < slices; ++j) {
            theta1 = (float)(j * 2) * (float)Math.PI / (float)slices;
            theta2 = (float)((j + 1) * 2) * (float)Math.PI / (float)slices;
            Vector3f northPole = new Vector3f(0.0f, r, 0.0f);
            Vector3f p1 = new Vector3f(r * (float)Math.sin(0.0f) * (float)Math.cos(theta1), r * (float)Math.cos(0.0f), r * (float)Math.sin(0.0f) * (float)Math.sin(theta1));
            Vector3f p2 = new Vector3f(r * (float)Math.sin(0.0f) * (float)Math.cos(theta2), r * (float)Math.cos(0.0f), r * (float)Math.sin(0.0f) * (float)Math.sin(theta2));
            res.add(new VertexData(northPole));
            res.add(new VertexData(p1));
            res.add(new VertexData(p2));
        }
        for (j = 0; j < slices; ++j) {
            theta1 = (float)(j * 2) * (float)Math.PI / (float)slices;
            theta2 = (float)((j + 1) * 2) * (float)Math.PI / (float)slices;
            Vector3f southPole = new Vector3f(0.0f, -r, 0.0f);
            Vector3f p1 = new Vector3f(r * (float)Math.sin((float)Math.PI) * (float)Math.cos(theta1), r * (float)Math.cos((float)Math.PI), r * (float)Math.sin((float)Math.PI) * (float)Math.sin(theta1));
            Vector3f p2 = new Vector3f(r * (float)Math.sin((float)Math.PI) * (float)Math.cos(theta2), r * (float)Math.cos((float)Math.PI), r * (float)Math.sin((float)Math.PI) * (float)Math.sin(theta2));
            res.add(new VertexData(southPole));
            res.add(new VertexData(p2));
            res.add(new VertexData(p1));
        }
        return res;
    }

    private final List<VertexData> genQuad(Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4) {
        Object[] objectArray = new VertexData[]{new VertexData(p1), new VertexData(p2), new VertexData(p3), new VertexData(p1), new VertexData(p3), new VertexData(p4)};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

