/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.scheduler;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\rJ%\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0012R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00138\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00138\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcn/coostack/cooparticlesapi/scheduler/CooScheduler;", "", "<init>", "()V", "", "doTick$cooparticlesapi_fabric_1_21_1", "doTick", "", "delay", "Ljava/lang/Runnable;", "runnable", "Lcn/coostack/cooparticlesapi/scheduler/CooScheduler$TickRunnable;", "runTaskTimer", "(ILjava/lang/Runnable;)Lcn/coostack/cooparticlesapi/scheduler/CooScheduler$TickRunnable;", "runTask", "maxLoopTick", "runTaskTimerMaxTick", "preDelay", "(IILjava/lang/Runnable;)Lcn/coostack/cooparticlesapi/scheduler/CooScheduler$TickRunnable;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "ticks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getTicks$cooparticlesapi_fabric_1_21_1", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "taskQueue", "getTaskQueue$cooparticlesapi_fabric_1_21_1", "TickRunnable", "cooparticlesapi-fabric-1.21.1"})
public final class CooScheduler {
    @NotNull
    private final ConcurrentLinkedQueue<TickRunnable> ticks = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<TickRunnable> taskQueue = new ConcurrentLinkedQueue();

    @NotNull
    public final ConcurrentLinkedQueue<TickRunnable> getTicks$cooparticlesapi_fabric_1_21_1() {
        return this.ticks;
    }

    @NotNull
    public final ConcurrentLinkedQueue<TickRunnable> getTaskQueue$cooparticlesapi_fabric_1_21_1() {
        return this.taskQueue;
    }

    public final void doTick$cooparticlesapi_fabric_1_21_1() {
        Iterator<TickRunnable> iterator = this.ticks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<TickRunnable> iterator2 = iterator;
        while (iterator2.hasNext()) {
            TickRunnable tick = iterator2.next();
            tick.doTick();
            if (!tick.getCanceled()) continue;
            iterator2.remove();
        }
        this.ticks.addAll((Collection<TickRunnable>)this.taskQueue);
        this.taskQueue.clear();
    }

    @NotNull
    public final TickRunnable runTaskTimer(int delay, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        TickRunnable tick = new TickRunnable(runnable);
        tick.setSingleDelay$cooparticlesapi_fabric_1_21_1(delay);
        tick.loop();
        this.taskQueue.add(tick);
        return tick;
    }

    @NotNull
    public final TickRunnable runTask(int delay, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        TickRunnable tick = new TickRunnable(runnable);
        tick.setSingleDelay$cooparticlesapi_fabric_1_21_1(delay);
        this.taskQueue.add(tick);
        return tick;
    }

    @NotNull
    public final TickRunnable runTaskTimerMaxTick(int maxLoopTick, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        TickRunnable tick = new TickRunnable(runnable);
        tick.setMaxTick$cooparticlesapi_fabric_1_21_1(maxLoopTick);
        tick.loopTimer();
        this.taskQueue.add(tick);
        return tick;
    }

    @NotNull
    public final TickRunnable runTaskTimerMaxTick(int preDelay, int maxLoopTick, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        TickRunnable tick = new TickRunnable(runnable);
        tick.setMaxTick$cooparticlesapi_fabric_1_21_1(maxLoopTick);
        tick.setSingleDelay$cooparticlesapi_fabric_1_21_1(preDelay);
        tick.loopTimer();
        this.taskQueue.add(tick);
        return tick;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B \u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0016R(\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\b\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\u00020\u001b8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u001d\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u0016\u0010%\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010\u001dR$\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020&8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010)R\u0016\u0010-\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00000\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u0010\u0014\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010)\u00a8\u00061"}, d2={"Lcn/coostack/cooparticlesapi/scheduler/CooScheduler$TickRunnable;", "", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "runnable", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Runnable;", "task", "(Ljava/lang/Runnable;)V", "callable", "setFinishCallback", "(Ljava/lang/Runnable;)Lcn/coostack/cooparticlesapi/scheduler/CooScheduler$TickRunnable;", "Ljava/util/function/Predicate;", "predicate", "setCancelPredicate", "(Ljava/util/function/Predicate;)Lcn/coostack/cooparticlesapi/scheduler/CooScheduler$TickRunnable;", "loop", "()Lcn/coostack/cooparticlesapi/scheduler/CooScheduler$TickRunnable;", "loopTimer", "cancel", "()V", "doTick", "Lkotlin/jvm/functions/Function1;", "getRunnable", "()Lkotlin/jvm/functions/Function1;", "", "maxTick", "I", "getMaxTick$cooparticlesapi_fabric_1_21_1", "()I", "setMaxTick$cooparticlesapi_fabric_1_21_1", "(I)V", "singleDelay", "getSingleDelay$cooparticlesapi_fabric_1_21_1", "setSingleDelay$cooparticlesapi_fabric_1_21_1", "currentTick", "", "value", "canceled", "Z", "getCanceled", "()Z", "looped", "finishCallable", "Ljava/lang/Runnable;", "cancelPredicate", "Ljava/util/function/Predicate;", "cooparticlesapi-fabric-1.21.1"})
    public static final class TickRunnable {
        @NotNull
        private final Function1<TickRunnable, Unit> runnable;
        private int maxTick;
        private int singleDelay;
        private int currentTick;
        private boolean canceled;
        private boolean looped;
        @NotNull
        private Runnable finishCallable;
        @NotNull
        private Predicate<TickRunnable> cancelPredicate;
        private boolean loopTimer;

        public TickRunnable(@NotNull Function1<? super TickRunnable, Unit> runnable) {
            Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
            this.runnable = runnable;
            this.singleDelay = 1;
            this.finishCallable = TickRunnable::finishCallable$lambda$1;
            this.cancelPredicate = TickRunnable::cancelPredicate$lambda$2;
        }

        @NotNull
        public final Function1<TickRunnable, Unit> getRunnable() {
            return this.runnable;
        }

        public TickRunnable(@NotNull Runnable task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            this((Function1<? super TickRunnable, Unit>)((Function1)arg_0 -> TickRunnable._init_$lambda$0(task, arg_0)));
        }

        public final int getMaxTick$cooparticlesapi_fabric_1_21_1() {
            return this.maxTick;
        }

        public final void setMaxTick$cooparticlesapi_fabric_1_21_1(int n) {
            this.maxTick = n;
        }

        public final int getSingleDelay$cooparticlesapi_fabric_1_21_1() {
            return this.singleDelay;
        }

        public final void setSingleDelay$cooparticlesapi_fabric_1_21_1(int n) {
            this.singleDelay = n;
        }

        public final boolean getCanceled() {
            return this.canceled;
        }

        @NotNull
        public final TickRunnable setFinishCallback(@NotNull Runnable callable) {
            Intrinsics.checkNotNullParameter((Object)callable, (String)"callable");
            this.finishCallable = callable;
            return this;
        }

        @NotNull
        public final TickRunnable setCancelPredicate(@NotNull Predicate<TickRunnable> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            this.cancelPredicate = predicate;
            return this;
        }

        @NotNull
        public final TickRunnable loop() {
            this.looped = true;
            this.currentTick = this.maxTick;
            return this;
        }

        @NotNull
        public final TickRunnable loopTimer() {
            this.loopTimer = true;
            return this;
        }

        public final void cancel() {
            this.canceled = true;
        }

        public final void doTick() {
            if (this.canceled) {
                return;
            }
            if (this.loopTimer) {
                boolean canInvoke;
                int n = this.currentTick;
                this.currentTick = n + 1;
                boolean bl = canInvoke = n % this.singleDelay == 0;
                if (canInvoke) {
                    this.runnable.invoke((Object)this);
                }
                if (this.cancelPredicate.test(this)) {
                    this.canceled = true;
                    this.finishCallable.run();
                    return;
                }
                if (this.currentTick >= this.maxTick) {
                    this.canceled = true;
                    this.finishCallable.run();
                    return;
                }
                return;
            }
            if (this.looped) {
                int n = this.currentTick;
                this.currentTick = n + 1;
                if (n >= this.singleDelay) {
                    this.runnable.invoke((Object)this);
                    if (this.cancelPredicate.test(this)) {
                        this.canceled = true;
                        this.finishCallable.run();
                    }
                    this.currentTick = 0;
                }
                return;
            }
            int n = this.currentTick;
            this.currentTick = n + 1;
            if (n >= this.singleDelay) {
                this.runnable.invoke((Object)this);
                this.finishCallable.run();
                this.canceled = true;
            }
        }

        private static final Unit _init_$lambda$0(Runnable $task, TickRunnable tickRunnable) {
            Intrinsics.checkNotNullParameter((Object)tickRunnable, (String)"<this>");
            $task.run();
            return Unit.INSTANCE;
        }

        private static final void finishCallable$lambda$1() {
        }

        private static final boolean cancelPredicate$lambda$2(TickRunnable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return false;
        }
    }
}

