/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002:\u0001\u001eB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\f\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\u0012R\u001c\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0016R\u0016\u0010\u001d\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "T", "", "", "capacity", "<init>", "(I)V", "value", "", "addFirst", "(Ljava/lang/Object;)V", "index", "get", "(I)Ljava/lang/Object;", "", "empty", "()Z", "notNullSize", "()I", "", "iterator", "()Ljava/util/Iterator;", "I", "getCapacity", "", "", "data", "[Ljava/lang/Object;", "size", "head", "CircularIterator", "cooparticlesapi-fabric-1.21.1"})
public final class CircularQueue<T>
implements Iterable<T>,
KMappedMarker {
    private final int capacity;
    @NotNull
    private final Object[] data;
    private int size;
    private int head;

    public CircularQueue(int capacity) {
        this.capacity = capacity;
        this.data = new Object[this.capacity];
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void addFirst(T value) {
        if (this.size < this.capacity) {
            int n = this.head;
            this.head = n + 1;
            this.data[n] = value;
            n = this.size;
            this.size = n + 1;
            return;
        }
        this.head %= this.capacity;
        int n = this.head;
        this.head = n + 1;
        this.data[n] = value;
    }

    public final T get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("\u8d85\u8fc7\u4f60\u8bbe\u5b9a\u7684capacity\u6216\u8005\u4f60\u8fd8\u6ca1\u8f93\u5165\u90a3\u4e48\u591a\u5143\u7d20 size: " + this.size + ", index: " + index);
        }
        int i = this.size < this.capacity ? index : (index + this.head) % this.capacity;
        return (T)this.data[i];
    }

    public final boolean empty() {
        return this.notNullSize() == 0;
    }

    public final int notNullSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new CircularIterator(this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcn/coostack/cooparticlesapi/utils/CircularQueue$CircularIterator;", "T", "", "Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "queue", "<init>", "(Lcn/coostack/cooparticlesapi/utils/CircularQueue;)V", "next", "()Ljava/lang/Object;", "", "hasNext", "()Z", "Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "", "current", "I", "cooparticlesapi-fabric-1.21.1"})
    public static final class CircularIterator<T>
    implements Iterator<T>,
    KMappedMarker {
        @NotNull
        private final CircularQueue<T> queue;
        private int current;

        public CircularIterator(@NotNull CircularQueue<T> queue) {
            Intrinsics.checkNotNullParameter(queue, (String)"queue");
            this.queue = queue;
        }

        @Override
        public T next() {
            int n = this.current;
            this.current = n + 1;
            return this.queue.get(n);
        }

        @Override
        public boolean hasNext() {
            return ((CircularQueue)this.queue).size > this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

