/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils;

import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.RotationMatrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ThreadPoolDispatcherKt;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b3\n\u0002\u0010!\n\u0002\b#\n\u0002\u0010\u000b\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\rJ%\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J3\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ3\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ+\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\u0004\b \u0010!J3\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0007\u00a2\u0006\u0004\b \u0010#J;\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007\u00a2\u0006\u0004\b&\u0010'JC\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u000e\u00a2\u0006\u0004\b)\u0010*J=\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b,\u0010'J5\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b-\u0010#J+\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000e\u00a2\u0006\u0004\b.\u0010/J3\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0007\u00a2\u0006\u0004\b.\u0010\u001aJ)\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010(\u001a\u00020\u000e\u00a2\u0006\u0004\b1\u00102J%\u00105\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007\u00a2\u0006\u0004\b5\u00106J+\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u0007\u00a2\u0006\u0004\b8\u00109J#\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u000e\u00a2\u0006\u0004\b:\u0010;J-\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u000e2\b\b\u0002\u0010<\u001a\u00020\u0007\u00a2\u0006\u0004\b=\u00109J+\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b@\u0010AJ#\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\bB\u0010CJ=\u0010G\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0F2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010(\u001a\u00020\u000e\u00a2\u0006\u0004\bG\u0010HJC\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040F2\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000e2\u0006\u0010M\u001a\u00020\u0007\u00a2\u0006\u0004\bN\u0010OJ\u001d\u0010R\u001a\u00020\u000e2\u0006\u0010P\u001a\u00020\u000e2\u0006\u0010Q\u001a\u00020\u000e\u00a2\u0006\u0004\bR\u0010SJC\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00040F2\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000e2\u0006\u0010M\u001a\u00020\u0007\u00a2\u0006\u0004\bT\u0010OJ#\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00040F2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\u000e\u00a2\u0006\u0004\bV\u0010;J%\u0010Z\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u0007\u00a2\u0006\u0004\bZ\u0010[J1\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010X\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u0007\u00a2\u0006\u0004\b]\u0010^J9\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010X\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u00072\u0006\u0010`\u001a\u00020\u000e\u00a2\u0006\u0004\ba\u0010bJ1\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010c\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u0004\u00a2\u0006\u0004\bd\u0010eJ9\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010c\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u00042\u0006\u0010`\u001a\u00020\u000e\u00a2\u0006\u0004\bf\u0010gJ9\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010h\u001a\u00020\f2\u0006\u0010c\u001a\u00020\f2\u0006\u0010X\u001a\u00020\u0004\u00a2\u0006\u0004\bd\u0010iJ\u001d\u0010l\u001a\u00020\u00072\u0006\u0010Y\u001a\u00020\u00072\u0006\u0010k\u001a\u00020j\u00a2\u0006\u0004\bl\u0010mJ\u0015\u0010o\u001a\u00020\u00072\u0006\u0010n\u001a\u00020\u0007\u00a2\u0006\u0004\bo\u0010pJ\u0015\u0010r\u001a\u00020\u00072\u0006\u0010q\u001a\u00020\f\u00a2\u0006\u0004\br\u0010sJ\u0015\u0010r\u001a\u00020\u00072\u0006\u0010q\u001a\u00020\u0004\u00a2\u0006\u0004\br\u0010tJ\u0015\u0010v\u001a\u00020\u00072\u0006\u0010u\u001a\u00020\u0004\u00a2\u0006\u0004\bv\u0010tJ\u0015\u0010v\u001a\u00020\u00072\u0006\u0010u\u001a\u00020\f\u00a2\u0006\u0004\bv\u0010sJ+\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u00107\u001a\u00020\u000e\u00a2\u0006\u0004\bw\u0010xJ+\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u000e\u00a2\u0006\u0004\bw\u0010!J3\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010h\u001a\u00020\f2\u0006\u0010y\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u000e\u00a2\u0006\u0004\bw\u0010zJ+\u0010|\u001a\b\u0012\u0004\u0012\u00020\u00040F2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010{\u001a\u00020\u000e\u00a2\u0006\u0004\b|\u0010}J4\u0010|\u001a\b\u0012\u0004\u0012\u00020\u00040F2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u000e2\u0006\u0010\u007f\u001a\u00020\u000e\u00a2\u0006\u0005\b|\u0010\u0080\u0001J@\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\u00040F2\u0007\u0010\u0081\u0001\u001a\u00020\u00072\u0007\u0010\u0082\u0001\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010{\u001a\u00020\u000e\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0084\u0001JH\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\u00040F2\u0007\u0010\u0081\u0001\u001a\u00020\u00072\u0007\u0010\u0082\u0001\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u000e2\u0006\u0010\u007f\u001a\u00020\u000e\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0085\u0001J8\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0015\u001a\u00020\u00042\u0007\u0010\u0086\u0001\u001a\u00020\u00042\u0007\u0010\u0087\u0001\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u000e\u00a2\u0006\u0006\b\u0088\u0001\u0010\u0089\u0001J;\u0010\u008d\u0001\u001a\u00020\u00072\u0007\u0010\u008a\u0001\u001a\u00020\u00072\u0007\u0010\u008b\u0001\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0007\u0010\u008c\u0001\u001a\u00020\u0007\u00a2\u0006\u0006\b\u008d\u0001\u0010\u008e\u0001J.\u0010\u0091\u0001\u001a\u0018\u0012\u0005\u0012\u00030\u0090\u0001\u0012\u0005\u0012\u00030\u0090\u0001\u0012\u0005\u0012\u00030\u0090\u00010\u008f\u00012\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0006\b\u0091\u0001\u0010\u0092\u0001JO\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0007\u0010\u0093\u0001\u001a\u00020\u00072\u0007\u0010\u0094\u0001\u001a\u00020\u00072\u0007\u0010\u0095\u0001\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010~\u001a\u00020\u000e2\b\b\u0002\u0010\u007f\u001a\u00020\u000e\u00a2\u0006\u0006\b\u0096\u0001\u0010\u0085\u0001J\u001a\u0010\u0097\u0001\u001a\u00020\u000e2\u0006\u0010q\u001a\u00020\fH\u0002\u00a2\u0006\u0006\b\u0097\u0001\u0010\u0098\u0001J\u001a\u0010\u0099\u0001\u001a\u00020\u000e2\u0006\u0010k\u001a\u00020\u0007H\u0002\u00a2\u0006\u0006\b\u0099\u0001\u0010\u009a\u0001R\u0018\u0010\u009c\u0001\u001a\u00030\u009b\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u009c\u0001\u0010\u009d\u0001R\u001f\u0010\u009f\u0001\u001a\u00030\u009e\u00018\u0002X\u0082\u0004\u00a2\u0006\u000f\n\u0006\b\u009f\u0001\u0010\u00a0\u0001\u0012\u0005\b\u00a1\u0001\u0010\u0003\u00a8\u0006\u00a2\u0001"}, d2={"Lcn/coostack/cooparticlesapi/utils/Math3DUtil;", "", "<init>", "()V", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "p1", "p2", "", "refiner", "", "fillLine", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;D)Ljava/util/List;", "Lnet/minecraft/class_243;", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;D)Ljava/util/List;", "", "r", "g", "b", "Lorg/joml/Vector3f;", "colorOf", "(III)Lorg/joml/Vector3f;", "target", "totalCount", "dottedCount", "step", "generateDottedLine", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;IID)Ljava/util/List;", "generateDottedCircle", "(DIID)Ljava/util/List;", "start", "end", "counts", "getLightningEffectNodes", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;I)Ljava/util/List;", "offsetRange", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;ID)Ljava/util/List;", "maxOffsetRange", "attenuation", "getLightningNodesEffectAttenuation", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;IDD)Ljava/util/List;", "preLineCount", "getLightningEffectAttenuationPoints", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;IDDI)Ljava/util/List;", "currentOffsetRange", "getLightningNodesAttenuation", "getLightningNodes", "getLightningEffectPoints", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;II)Ljava/util/List;", "nodes", "connectLineWithNodes", "(Ljava/util/List;I)Ljava/util/List;", "discrete", "pointRadius", "getSingleDiscreteOnCircleXZ", "(DDD)Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "count", "getDiscreteCircleXZ", "(DID)Ljava/util/List;", "getCircleXZ", "(DI)Ljava/util/List;", "rotate", "getHalfCircleXZ", "n", "edgeCount", "getPolygonInCircleLocations", "(IID)Ljava/util/List;", "getPolygonInCircleVertices", "(ID)Ljava/util/List;", "points", "to", "", "connectLines", "(Ljava/util/List;Ljava/util/List;I)Ljava/util/List;", "r1", "r2", "w1", "w2", "scale", "computeCycloidVertices", "(DDIIID)Ljava/util/List;", "i", "j", "gcd", "(II)I", "getCycloidGraphic", "countPow", "getBallLocations", "point", "axis", "angle", "rotateVector", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;D)Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "locList", "rotateAsAxis", "(Ljava/util/List;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;D)Ljava/util/List;", "shape", "threads", "rotateAsAxisAsync", "(Ljava/util/List;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;DI)Ljava/util/List;", "toPoint", "rotatePointsToPoint", "(Ljava/util/List;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)Ljava/util/List;", "rotatePointsToPointAsync", "(Ljava/util/List;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;I)Ljava/util/List;", "origin", "(Ljava/util/List;Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)Ljava/util/List;", "", "rad", "toMinecraftAngle", "(DZ)D", "yaw", "toMinecraftYaw", "(D)D", "loc", "getYawFromLocation", "(Lnet/minecraft/class_243;)D", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)D", "v", "getPitchFromLocation", "getLineLocations", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;I)Ljava/util/List;", "direction", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;DI)Ljava/util/List;", "preCircleCount", "getRoundScapeLocations", "(DDI)Ljava/util/List;", "minCircleCount", "maxCircleCount", "(DDII)Ljava/util/List;", "height", "heightStep", "getCylinderLocations", "(DDDDI)Ljava/util/List;", "(DDDDII)Ljava/util/List;", "startHandle", "endHandle", "generateBezierCurve", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;I)Ljava/util/List;", "t", "p0", "p3", "cubicBezier", "(DDDDD)D", "Lkotlin/Triple;", "", "calculateEulerAnglesToPoint", "(Lorg/joml/Vector3f;)Lkotlin/Triple;", "power", "maxHeight", "handleRadius", "generateExplosionCurve", "getAxisSymbol", "(Lnet/minecraft/class_243;)I", "getQuadrants", "(D)I", "Lkotlin/random/Random;", "random", "Lkotlin/random/Random;", "Lkotlinx/coroutines/CoroutineScope;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope$annotations", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMath3DUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Math3DUtil.kt\ncn/coostack/cooparticlesapi/utils/Math3DUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1103:1\n1#2:1104\n1#2:1109\n1#2:1111\n1878#3,3:1105\n2756#3:1108\n2756#3:1110\n*S KotlinDebug\n*F\n+ 1 Math3DUtil.kt\ncn/coostack/cooparticlesapi/utils/Math3DUtil\n*L\n899#1:1109\n934#1:1111\n424#1:1105,3\n899#1:1108\n934#1:1110\n*E\n"})
public final class Math3DUtil {
    @NotNull
    public static final Math3DUtil INSTANCE = new Math3DUtil();
    @NotNull
    private static final Random random = RandomKt.Random((long)System.currentTimeMillis());
    @NotNull
    private static final CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)ThreadPoolDispatcherKt.newFixedThreadPoolContext((int)CooParticlesServices.API_CONFIG_MANAGER.getConfig().getCalculateThreadCount(), (String)"Math3DUtil-ThreadPool")));

    private Math3DUtil() {
    }

    private static /* synthetic */ void getScope$annotations() {
    }

    @NotNull
    public final List<RelativeLocation> fillLine(@NotNull RelativeLocation p1, @NotNull RelativeLocation p2, double refiner) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        int actualCount = MathKt.roundToInt((double)(p1.distance(p2) * refiner));
        return this.getLineLocations(p1, p2, actualCount);
    }

    @NotNull
    public final List<RelativeLocation> fillLine(@NotNull class_243 p1, @NotNull class_243 p2, double refiner) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return this.fillLine(RelativeLocation.Companion.of(p1), RelativeLocation.Companion.of(p2), refiner);
    }

    @NotNull
    public final Vector3f colorOf(int r, int g, int b) {
        return new Vector3f((float)r / (float)255, (float)g / (float)255, (float)b / (float)255);
    }

    @NotNull
    public final List<RelativeLocation> generateDottedLine(@NotNull RelativeLocation target, int totalCount, int dottedCount, double step) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ArrayList res = new ArrayList();
        double len = target.length();
        if (len <= step) {
            return CollectionsKt.emptyList();
        }
        if (step <= 0.0) {
            return this.getLineLocations(new RelativeLocation(), target, totalCount);
        }
        double lineStep = len / (double)dottedCount - step;
        if (lineStep <= 0.0) {
            return CollectionsKt.emptyList();
        }
        int perCount = RangesKt.coerceAtLeast((int)(totalCount / dottedCount), (int)1);
        RelativeLocation dir = target.normalize();
        RelativeLocation current = null;
        current = dir.multiplyClone(lineStep);
        RelativeLocation pre = null;
        pre = new RelativeLocation();
        int n = 0;
        while (n < dottedCount) {
            int it = n++;
            boolean bl = false;
            res.addAll(INSTANCE.getLineLocations(pre, current, perCount));
            pre = current.plus(dir.times(step));
            current = pre.plus(dir.times(lineStep));
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> generateDottedCircle(double r, int totalCount, int dottedCount, double step) {
        ArrayList<RelativeLocation> res = new ArrayList<RelativeLocation>();
        if (step >= Math.PI * 2) {
            return CollectionsKt.emptyList();
        }
        int perArcCount = RangesKt.coerceAtLeast((int)(totalCount / dottedCount), (int)1);
        double solidArcLengthStep = Math.PI * 2 / (double)dottedCount - step;
        double angleStep = solidArcLengthStep / (double)perArcCount;
        double pre = 0.0;
        double current = 0.0;
        current = solidArcLengthStep;
        for (int i = 0; i < dottedCount; ++i) {
            int it = i;
            boolean bl = false;
            int n = 0;
            while (n < perArcCount) {
                int it2 = n++;
                boolean bl2 = false;
                double arcAngle = pre + (double)it2 * angleStep;
                res.add(new RelativeLocation(Math.cos(arcAngle) * r, 0.0, Math.sin(arcAngle) * r));
            }
            pre = current + step;
            current = pre + solidArcLengthStep;
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getLightningEffectNodes(@NotNull RelativeLocation start, @NotNull RelativeLocation end, int counts) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        double len = end.distance(start);
        double offsetStep = len / (double)4;
        return this.getLightningEffectNodes(start, end, counts, offsetStep);
    }

    @NotNull
    public final List<RelativeLocation> getLightningEffectNodes(@NotNull RelativeLocation start, @NotNull RelativeLocation end, int counts, double offsetRange) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Object[] objectArray = new RelativeLocation[]{start};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        res.addAll((Collection)this.getLightningNodes(start, end, counts, offsetRange));
        res.add(end);
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getLightningNodesEffectAttenuation(@NotNull RelativeLocation start, @NotNull RelativeLocation end, int counts, double maxOffsetRange, double attenuation) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Object[] objectArray = new RelativeLocation[]{start};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        res.addAll((Collection)this.getLightningNodesAttenuation(start, end, counts, maxOffsetRange, attenuation));
        res.add(end);
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getLightningEffectAttenuationPoints(@NotNull RelativeLocation start, @NotNull RelativeLocation end, int counts, double maxOffsetRange, double attenuation, int preLineCount) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return this.connectLineWithNodes(this.getLightningNodesEffectAttenuation(start, end, counts, maxOffsetRange, attenuation), preLineCount);
    }

    private final List<RelativeLocation> getLightningNodesAttenuation(RelativeLocation start, RelativeLocation end, int counts, double currentOffsetRange, double attenuation) {
        double fixedOffsetRange = RangesKt.coerceAtLeast((double)currentOffsetRange, (double)0.01);
        if (!(0.01 <= attenuation ? attenuation <= 1.0 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        RelativeLocation mid = start.plus(end.minus(start).multiply(0.5));
        mid.add(Vec3ExtendsKt.asRelative(Vec3ExtendsKt.randomVec3()).times(random.nextDouble(-fixedOffsetRange, fixedOffsetRange)));
        Object[] objectArray = new RelativeLocation[]{mid};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        if (counts <= 1) {
            return res;
        }
        double nextOffsetRange = RangesKt.coerceAtLeast((double)(fixedOffsetRange * attenuation), (double)0.01);
        List<RelativeLocation> left = this.getLightningNodesAttenuation(start, mid, counts - 1, nextOffsetRange, attenuation);
        List<RelativeLocation> right = this.getLightningNodesAttenuation(mid, end, counts - 1, nextOffsetRange, attenuation);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)left, (Iterable)res), (Iterable)right);
    }

    private final List<RelativeLocation> getLightningNodes(RelativeLocation start, RelativeLocation end, int counts, double offsetRange) {
        return this.getLightningNodesAttenuation(start, end, counts, offsetRange, 1.0);
    }

    @NotNull
    public final List<RelativeLocation> getLightningEffectPoints(@NotNull RelativeLocation end, int counts, int preLineCount) {
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        List<RelativeLocation> nodes = this.getLightningEffectNodes(new RelativeLocation(), end, counts);
        ArrayList res = new ArrayList();
        for (int i = 0; i < nodes.size() - 1; ++i) {
            RelativeLocation current = nodes.get(i);
            RelativeLocation next = nodes.get(i + 1);
            res.addAll(this.getLineLocations(current, next, preLineCount));
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getLightningEffectPoints(@NotNull RelativeLocation end, int counts, int preLineCount, double offsetRange) {
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        List<RelativeLocation> nodes = this.getLightningEffectNodes(new RelativeLocation(), end, counts, offsetRange);
        return this.connectLineWithNodes(nodes, preLineCount);
    }

    @NotNull
    public final List<RelativeLocation> connectLineWithNodes(@NotNull List<RelativeLocation> nodes, int preLineCount) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        ArrayList res = new ArrayList();
        for (int i = 0; i < nodes.size() - 1; ++i) {
            RelativeLocation current = nodes.get(i);
            RelativeLocation next = nodes.get(i + 1);
            res.addAll(this.getLineLocations(current, next, preLineCount));
        }
        return res;
    }

    @NotNull
    public final RelativeLocation getSingleDiscreteOnCircleXZ(double r, double discrete, double pointRadius) {
        double x = Math.cos(pointRadius) * r;
        double z = Math.sin(pointRadius) * r;
        if (discrete <= 0.0) {
            return new RelativeLocation(x, 0.0, z);
        }
        double randomR = random.nextDouble(discrete);
        double rx = random.nextDouble(-Math.PI, Math.PI);
        double ry = random.nextDouble(-Math.PI, Math.PI);
        RelativeLocation add = new RelativeLocation(randomR * Math.cos(rx) * Math.cos(ry), randomR * Math.sin(rx), randomR * Math.sin(ry) * Math.cos(rx));
        return new RelativeLocation(x + add.getX(), add.getY(), z + add.getZ());
    }

    @NotNull
    public final List<RelativeLocation> getDiscreteCircleXZ(double r, int count, double discrete) {
        List result = new ArrayList();
        if (count <= 0) {
            return result;
        }
        double angleStep = Math.PI * 2 / (double)count;
        int n = 0;
        while (n < count) {
            int i = n++;
            boolean bl = false;
            double baseAngle = (double)i * angleStep;
            result.add(INSTANCE.getSingleDiscreteOnCircleXZ(r, discrete, baseAngle));
        }
        return result;
    }

    @NotNull
    public final List<RelativeLocation> getCircleXZ(double r, int count) {
        ArrayList<RelativeLocation> res = new ArrayList<RelativeLocation>();
        double step = Math.PI * 2 / (double)count;
        double radius = 0.0;
        int n = 0;
        while (n < count) {
            int it = n++;
            boolean bl = false;
            res.add(new RelativeLocation(r * Math.cos(radius), 0.0, r * Math.sin(radius)));
            radius += step;
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getHalfCircleXZ(double r, int count, double rotate) {
        ArrayList<RelativeLocation> res = new ArrayList<RelativeLocation>();
        double step = Math.PI / (double)count;
        double radius = 0.0;
        int n = 0;
        while (n < count) {
            int it = n++;
            boolean bl = false;
            res.add(new RelativeLocation(r * Math.cos(radius), 0.0, r * Math.sin(radius)));
            radius += step;
        }
        if (!(rotate == 0.0)) {
            this.rotateAsAxis((List<RelativeLocation>)res, RelativeLocation.Companion.yAxis(), rotate);
        }
        return res;
    }

    public static /* synthetic */ List getHalfCircleXZ$default(Math3DUtil math3DUtil, double d, int n, double d2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d2 = 0.0;
        }
        return math3DUtil.getHalfCircleXZ(d, n, d2);
    }

    @NotNull
    public final List<RelativeLocation> getPolygonInCircleLocations(int n, int edgeCount, double r) {
        if (!(n >= 3)) {
            boolean $i$a$-require-Math3DUtil$getPolygonInCircleLocations$32 = false;
            String $i$a$-require-Math3DUtil$getPolygonInCircleLocations$32 = "n must be at least 3";
            throw new IllegalArgumentException($i$a$-require-Math3DUtil$getPolygonInCircleLocations$32.toString());
        }
        if (!(edgeCount >= 1)) {
            boolean $i$a$-require-Math3DUtil$getPolygonInCircleLocations$42 = false;
            String $i$a$-require-Math3DUtil$getPolygonInCircleLocations$42 = "edgeCount must be at least 1";
            throw new IllegalArgumentException($i$a$-require-Math3DUtil$getPolygonInCircleLocations$42.toString());
        }
        List<RelativeLocation> vertices = this.getPolygonInCircleVertices(n, r);
        List result = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int j = (i + 1) % n;
            RelativeLocation vi = vertices.get(i);
            RelativeLocation vj = vertices.get(j);
            class_243 direction = new class_243(vj.getX() - vi.getX(), vj.getY() - vi.getY(), vj.getZ() - vi.getZ());
            double length = direction.method_1033();
            double step = edgeCount > 1 ? length / (double)(edgeCount - 1) : 0.0;
            List<RelativeLocation> lineLocations = this.getLineLocations(vi.toVector(), direction, step, edgeCount);
            result.addAll((Collection)lineLocations);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RelativeLocation> getPolygonInCircleVertices(int n, double r) {
        if (!(n >= 3)) {
            boolean bl = false;
            String string = "n must be at least 3";
            throw new IllegalArgumentException(string.toString());
        }
        ArrayList<RelativeLocation> arrayList = new ArrayList<RelativeLocation>(n);
        int n2 = 0;
        while (n2 < n) {
            void i;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<RelativeLocation> arrayList2 = arrayList;
            boolean bl = false;
            double theta = Math.PI * 2 * (double)i / (double)n;
            arrayList2.add(new RelativeLocation(r * Math.cos(theta), 0.0, r * Math.sin(theta)));
        }
        List vertices = arrayList;
        return vertices;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<RelativeLocation>> connectLines(@NotNull List<RelativeLocation> points, @NotNull List<RelativeLocation> to, int preLineCount) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        if (points.isEmpty() || to.isEmpty()) {
            return new ArrayList();
        }
        Pair pair = points.size() >= to.size() ? TuplesKt.to(points, to) : TuplesKt.to(to, points);
        List bigger = (List)pair.component1();
        List smaller = (List)pair.component2();
        int step = bigger.size() / smaller.size();
        int remainder = bigger.size() % smaller.size();
        List result = new ArrayList();
        Iterable $this$forEachIndexed$iv = smaller;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int biggerIndex;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RelativeLocation relativeLocation = (RelativeLocation)item$iv;
            int index = n;
            boolean bl = false;
            int currentStep = index < remainder ? step + 1 : step;
            int startIndex = index * step + Math.min(index, remainder);
            for (int offset = 0; offset < currentStep && (biggerIndex = startIndex + offset) < bigger.size(); ++offset) {
                void smallPoint;
                List<RelativeLocation> line = INSTANCE.getLineLocations((RelativeLocation)bigger.get(biggerIndex), (RelativeLocation)smallPoint, preLineCount);
                result.add(line);
            }
        }
        return result;
    }

    @NotNull
    public final List<RelativeLocation> computeCycloidVertices(double r1, double r2, int w1, int w2, int count, double scale) {
        int doubled = Math.max(Math.abs(w1), Math.abs(w2));
        int precision = 360 * doubled / count;
        int w1Step = w1 * precision;
        int w2Step = w2 * precision;
        int d = this.gcd(Math.abs(w1), Math.abs(w2));
        int verticesCount = Math.abs(w1 - w2) / d;
        List vertices = new ArrayList();
        for (int k = 0; k < verticesCount; ++k) {
            int delta = w1Step - w2Step;
            double t = Math.PI * 2 * (double)k / (double)delta;
            double x = r1 * Math.cos((double)w1Step * t) + r2 * Math.cos((double)w2Step * t) * scale;
            double z = r1 * Math.sin((double)w1Step * t) + r2 * Math.sin((double)w2Step * t) * scale;
            vertices.add(new RelativeLocation(x, 0.0, z));
        }
        return vertices;
    }

    public final int gcd(int i, int j) {
        int x = Math.abs(i);
        int y = Math.abs(j);
        while (y != 0) {
            int temp = y;
            y = x % y;
            x = temp;
        }
        return x;
    }

    @NotNull
    public final List<RelativeLocation> getCycloidGraphic(double r1, double r2, int w1, int w2, int count, double scale) {
        ArrayList<RelativeLocation> result = new ArrayList<RelativeLocation>();
        double radOrigin = 0.0;
        double radA = 0.0;
        int doubled = Math.max(Math.abs(w1), Math.abs(w2));
        double precision = Math.PI * 2 * (double)doubled / (double)count;
        for (int current = 0; current < count; ++current) {
            result.add(new RelativeLocation((r2 * Math.cos(radA += (double)w2 * precision) + r1 * Math.cos(radOrigin += (double)w1 * precision)) * scale, 0.0, (r2 * Math.sin(radA) + r1 * Math.sin(radOrigin)) * scale));
        }
        return result;
    }

    @NotNull
    public final List<RelativeLocation> getBallLocations(double r, int countPow) {
        ArrayList<RelativeLocation> result = new ArrayList<RelativeLocation>();
        double rx = 0.0;
        double ry = 0.0;
        double step = Math.PI * 2 / (double)countPow;
        int i = 1;
        if (i <= countPow) {
            while (true) {
                int j;
                if ((j = 1) <= countPow) {
                    while (true) {
                        result.add(new RelativeLocation(r * Math.cos(rx) * Math.cos(ry), r * Math.sin(rx), r * Math.sin(ry) * Math.cos(rx)));
                        ry += step;
                        if (j == countPow) break;
                        ++j;
                    }
                }
                ry = 0.0;
                rx += step;
                if (i == countPow) break;
                ++i;
            }
        }
        return result;
    }

    @NotNull
    public final RelativeLocation rotateVector(@NotNull RelativeLocation point, @NotNull RelativeLocation axis, double angle) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return RotationMatrix.Companion.fromAxisAngle(axis, angle).applyToClone(point);
    }

    @NotNull
    public final List<RelativeLocation> rotateAsAxis(@NotNull List<RelativeLocation> locList, @NotNull RelativeLocation axis, double angle) {
        Intrinsics.checkNotNullParameter(locList, (String)"locList");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return this.rotateAsAxisAsync(locList, axis, angle, CooParticlesServices.API_CONFIG_MANAGER.getConfig().getCalculateThreadCount());
    }

    @NotNull
    public final List<RelativeLocation> rotateAsAxisAsync(@NotNull List<RelativeLocation> shape, @NotNull RelativeLocation axis, double angle, int threads) {
        Intrinsics.checkNotNullParameter(shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        CopyOnWriteArrayList<RelativeLocation> copy = new CopyOnWriteArrayList<RelativeLocation>((Collection)shape);
        if (copy.isEmpty()) {
            return shape;
        }
        int actualThreads = threads;
        if (threads >= copy.size()) {
            actualThreads = copy.size();
        }
        int taskPreThreadCount = copy.size() / actualThreads;
        int notHandledTaskCount = 0;
        notHandledTaskCount = copy.size() % actualThreads;
        int currentIndex = 0;
        Quaterniond q = new Quaterniond();
        q.rotateAxis(angle, (Vector3dc)axis.toVector3d());
        ArrayList<Deferred<Unit>> tasks = new ArrayList<Deferred<Unit>>();
        for (int i = 0; i < actualThreads; ++i) {
            int it = i;
            boolean bl = false;
            Ref.IntRef next = new Ref.IntRef();
            next.element = currentIndex + taskPreThreadCount;
            if (notHandledTaskCount > 0) {
                int n = next.element;
                next.element = n + 1;
                notHandledTaskCount += -1;
            }
            int taskHandledIndexStart = currentIndex;
            currentIndex = next.element;
            Vector3d vector = new Vector3d(0.0, 0.0, 0.0);
            Deferred job2 = BuildersKt.async$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(taskHandledIndexStart, next, copy, vector, q, null){
                int label;
                final /* synthetic */ int $taskHandledIndexStart;
                final /* synthetic */ Ref.IntRef $next;
                final /* synthetic */ CopyOnWriteArrayList<RelativeLocation> $copy;
                final /* synthetic */ Vector3d $vector;
                final /* synthetic */ Quaterniond $q;
                {
                    this.$taskHandledIndexStart = $taskHandledIndexStart;
                    this.$next = $next;
                    this.$copy = $copy;
                    this.$vector = $vector;
                    this.$q = $q;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            int n = this.$next.element;
                            for (int i = this.$taskHandledIndexStart; i < n; ++i) {
                                RelativeLocation it = this.$copy.get(i);
                                this.$vector.set(it.getX(), it.getY(), it.getZ());
                                this.$vector.rotate((Quaterniondc)this.$q);
                                it.setX(this.$vector.x);
                                it.setY(this.$vector.y);
                                it.setZ(this.$vector.z);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            tasks.add((Deferred<Unit>)job2);
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Unit>>, Object>(tasks, null){
            int label;
            final /* synthetic */ ArrayList<Deferred<Unit>> $tasks;
            {
                this.$tasks = $tasks;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = AwaitKt.awaitAll((Collection)this.$tasks, (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return shape;
    }

    @NotNull
    public final List<RelativeLocation> rotatePointsToPoint(@NotNull List<RelativeLocation> shape, @NotNull RelativeLocation toPoint, @NotNull RelativeLocation axis) {
        Intrinsics.checkNotNullParameter(shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)toPoint, (String)"toPoint");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return this.rotatePointsToPointAsync(shape, toPoint, axis, CooParticlesServices.API_CONFIG_MANAGER.getConfig().getCalculateThreadCount());
    }

    @NotNull
    public final List<RelativeLocation> rotatePointsToPointAsync(@NotNull List<RelativeLocation> shape, @NotNull RelativeLocation toPoint, @NotNull RelativeLocation axis, int threads) {
        Intrinsics.checkNotNullParameter(shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)toPoint, (String)"toPoint");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        CopyOnWriteArrayList<RelativeLocation> copy = new CopyOnWriteArrayList<RelativeLocation>((Collection)shape);
        double d = axis.cross(toPoint).length();
        boolean bl = -1.0E-5 <= d ? d <= 1.0E-5 : false;
        if (bl && axis.dot(toPoint) > 0.0) {
            return shape;
        }
        if (copy.isEmpty()) {
            return shape;
        }
        int actualThreads = threads;
        if (threads >= copy.size()) {
            actualThreads = copy.size();
        }
        int taskPreThreadCount = copy.size() / actualThreads;
        int notHandledTaskCount = 0;
        notHandledTaskCount = copy.size() % actualThreads;
        int currentIndex = 0;
        Quaterniond q = new Quaterniond();
        RelativeLocation na = axis.normalize();
        double axisYaw = this.getYawFromLocation(na);
        double axisPitch = this.getPitchFromLocation(na);
        RelativeLocation toa = toPoint.normalize();
        double toYaw = this.getYawFromLocation(toa);
        double toPitch = this.getPitchFromLocation(toa);
        q.rotateY(axisYaw).rotateLocalX(axisPitch);
        Quaterniond toQ = new Quaterniond().rotateY(-toYaw).rotateX(-toPitch);
        ArrayList<Deferred<Unit>> tasks = new ArrayList<Deferred<Unit>>();
        for (int i = 0; i < actualThreads; ++i) {
            int it = i;
            boolean bl2 = false;
            Ref.IntRef next = new Ref.IntRef();
            next.element = currentIndex + taskPreThreadCount;
            if (notHandledTaskCount > 0) {
                int n = next.element;
                next.element = n + 1;
                notHandledTaskCount += -1;
            }
            int taskHandledIndexStart = currentIndex;
            currentIndex = next.element;
            Vector3d vector = new Vector3d(0.0, 0.0, 0.0);
            Deferred job2 = BuildersKt.async$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(taskHandledIndexStart, next, copy, vector, q, toQ, null){
                int label;
                final /* synthetic */ int $taskHandledIndexStart;
                final /* synthetic */ Ref.IntRef $next;
                final /* synthetic */ CopyOnWriteArrayList<RelativeLocation> $copy;
                final /* synthetic */ Vector3d $vector;
                final /* synthetic */ Quaterniond $q;
                final /* synthetic */ Quaterniond $toQ;
                {
                    this.$taskHandledIndexStart = $taskHandledIndexStart;
                    this.$next = $next;
                    this.$copy = $copy;
                    this.$vector = $vector;
                    this.$q = $q;
                    this.$toQ = $toQ;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            int n = this.$next.element;
                            for (int i = this.$taskHandledIndexStart; i < n; ++i) {
                                RelativeLocation it = this.$copy.get(i);
                                this.$vector.set(it.getX(), it.getY(), it.getZ());
                                this.$vector.rotate((Quaterniondc)this.$q);
                                this.$vector.rotate((Quaterniondc)this.$toQ);
                                it.setX(this.$vector.x);
                                it.setY(this.$vector.y);
                                it.setZ(this.$vector.z);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            tasks.add((Deferred<Unit>)job2);
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Unit>>, Object>(tasks, null){
            int label;
            final /* synthetic */ ArrayList<Deferred<Unit>> $tasks;
            {
                this.$tasks = $tasks;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = AwaitKt.awaitAll((Collection)this.$tasks, (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return shape;
    }

    @NotNull
    public final List<RelativeLocation> rotatePointsToPoint(@NotNull List<RelativeLocation> locList, @NotNull class_243 origin, @NotNull class_243 toPoint, @NotNull RelativeLocation axis) {
        Intrinsics.checkNotNullParameter(locList, (String)"locList");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)toPoint, (String)"toPoint");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        double d = axis.length();
        boolean bl = -1.0E-5 <= d ? d <= 1.0E-6 : false;
        if (bl) {
            return locList;
        }
        RelativeLocation relToPoint = RelativeLocation.Companion.of(origin, toPoint);
        return this.rotatePointsToPoint(locList, relToPoint, axis);
    }

    public final double toMinecraftAngle(double angle, boolean rad) {
        double enter = angle;
        if (rad) {
            enter = Math.toDegrees(angle);
        }
        if ((enter %= (double)360) > 180.0) {
            enter -= (double)360;
        }
        if (enter < -180.0) {
            enter += (double)360;
        }
        return enter;
    }

    public final double toMinecraftYaw(double yaw) {
        return yaw - 1.5707963267948966;
    }

    public final double getYawFromLocation(@NotNull class_243 loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        return Math.atan2(loc.field_1350, loc.field_1352);
    }

    public final double getYawFromLocation(@NotNull RelativeLocation loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        return Math.atan2(-loc.getX(), loc.getZ());
    }

    public final double getPitchFromLocation(@NotNull RelativeLocation v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return Math.atan2(v.getY(), Math.sqrt(Math.pow(v.getX(), 2) + Math.pow(v.getZ(), 2)));
    }

    public final double getPitchFromLocation(@NotNull class_243 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double length = v.method_1033();
        if (length == 0.0) {
            return 0.0;
        }
        return Math.asin(v.field_1351 / length);
    }

    @NotNull
    public final List<RelativeLocation> getLineLocations(@NotNull class_243 start, @NotNull class_243 end, int count) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        RelativeLocation origin = RelativeLocation.Companion.of(start);
        Object[] objectArray = new RelativeLocation[]{origin, RelativeLocation.Companion.of(end)};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        double step = start.method_1022(end) / (double)count;
        class_243 direction = end.method_1020(start).method_1029().method_1021(step);
        Intrinsics.checkNotNull((Object)direction);
        RelativeLocation relativeDirection = RelativeLocation.Companion.of(direction);
        RelativeLocation next = origin;
        int i = 2;
        if (i <= count) {
            while (true) {
                RelativeLocation pos = next.plus(relativeDirection);
                next = pos.clone();
                res.add(next);
                if (i == count) break;
                ++i;
            }
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getLineLocations(@NotNull RelativeLocation start, @NotNull RelativeLocation end, int count) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return this.getLineLocations(start.toVector(), end.toVector(), count);
    }

    @NotNull
    public final List<RelativeLocation> getLineLocations(@NotNull class_243 origin, @NotNull class_243 direction, double step, int count) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        RelativeLocation originRel = RelativeLocation.Companion.of(origin);
        Object[] objectArray = new RelativeLocation[]{originRel};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        class_243 class_2432 = new class_243(direction.field_1352, direction.field_1351, direction.field_1350).method_1029().method_1021(step);
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"scale(...)");
        RelativeLocation relativeDirection = RelativeLocation.Companion.of(class_2432);
        RelativeLocation next = originRel;
        int i = 2;
        if (i <= count) {
            while (true) {
                RelativeLocation pos = next.plus(relativeDirection);
                next = pos.clone();
                res.add(next);
                if (i == count) break;
                ++i;
            }
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getRoundScapeLocations(double r, double step, int preCircleCount) {
        List res = new ArrayList();
        if (step <= 0.0 || r < step) {
            return res;
        }
        block0: for (double varR = step; varR < r; varR += step) {
            double stepCircle = Math.PI * 2 / (double)preCircleCount;
            int i = 1;
            if (i > preCircleCount) continue;
            while (true) {
                double x = varR * Math.cos(stepCircle * (double)i);
                double z = varR * Math.sin(stepCircle * (double)i);
                res.add(new RelativeLocation(x, 0.0, z));
                if (i == preCircleCount) continue block0;
                ++i;
            }
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getRoundScapeLocations(double r, double step, int minCircleCount, int maxCircleCount) {
        List res = new ArrayList();
        if (step <= 0.0 || r < step) {
            return res;
        }
        int circleTotalCount = (int)(r / step);
        double varR = step;
        int currentCircle = 1;
        int countStep = (maxCircleCount - minCircleCount) / circleTotalCount;
        while (varR < r) {
            int currentCircleParticleCount = minCircleCount + currentCircle * countStep;
            double stepCircle = Math.PI * 2 / (double)currentCircleParticleCount;
            int i = 1;
            if (i <= currentCircleParticleCount) {
                while (true) {
                    double x = varR * Math.cos(stepCircle * (double)i);
                    double z = varR * Math.sin(stepCircle * (double)i);
                    res.add(new RelativeLocation(x, 0.0, z));
                    if (i == currentCircleParticleCount) break;
                    ++i;
                }
            }
            varR += step;
            ++currentCircle;
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getCylinderLocations(double height, double heightStep, double r, double step, int preCircleCount) {
        if (height < heightStep) {
            return new ArrayList();
        }
        List<RelativeLocation> start = this.getRoundScapeLocations(r, step, preCircleCount);
        Iterable $this$onEach$iv = this.getRoundScapeLocations(r, step, preCircleCount);
        boolean $i$f$onEach = false;
        Object object = $this$onEach$iv;
        Iterable $this$onEach_u24lambda_u2418$iv = object;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            RelativeLocation it = (RelativeLocation)element$iv;
            boolean bl2 = false;
            it.setY(it.getY() + height);
        }
        List end = (List)object;
        int heightCount = (int)(height / heightStep);
        List res = new ArrayList();
        object = ((Iterable)start).iterator();
        int n = 0;
        while (object.hasNext()) {
            int index = n++;
            RelativeLocation startLoc = (RelativeLocation)object.next();
            RelativeLocation endLoc = (RelativeLocation)end.get(index);
            res.addAll((Collection)this.getLineLocations(startLoc.toVector(), endLoc.toVector(), heightStep, heightCount));
        }
        return res;
    }

    @NotNull
    public final List<RelativeLocation> getCylinderLocations(double height, double heightStep, double r, double step, int minCircleCount, int maxCircleCount) {
        if (height < heightStep) {
            return new ArrayList();
        }
        List<RelativeLocation> start = this.getRoundScapeLocations(r, step, minCircleCount, maxCircleCount);
        Iterable $this$onEach$iv = this.getRoundScapeLocations(r, step, minCircleCount, maxCircleCount);
        boolean $i$f$onEach = false;
        Object object = $this$onEach$iv;
        Iterable $this$onEach_u24lambda_u2418$iv = object;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            RelativeLocation it = (RelativeLocation)element$iv;
            boolean bl2 = false;
            it.setY(it.getY() + height);
        }
        List end = (List)object;
        int heightCount = (int)(height / heightStep);
        List res = new ArrayList();
        object = ((Iterable)start).iterator();
        int n = 0;
        while (object.hasNext()) {
            int index = n++;
            RelativeLocation startLoc = (RelativeLocation)object.next();
            RelativeLocation endLoc = (RelativeLocation)end.get(index);
            res.addAll((Collection)this.getLineLocations(startLoc.toVector(), endLoc.toVector(), heightStep, heightCount));
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RelativeLocation> generateBezierCurve(@NotNull RelativeLocation target, @NotNull RelativeLocation startHandle, @NotNull RelativeLocation endHandle, int count) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)startHandle, (String)"startHandle");
        Intrinsics.checkNotNullParameter((Object)endHandle, (String)"endHandle");
        if (!(count >= 1)) {
            boolean bl = false;
            String string = "Number of points must be at least 1";
            throw new IllegalArgumentException(string.toString());
        }
        RelativeLocation end = target.plus(endHandle);
        ArrayList<RelativeLocation> arrayList = new ArrayList<RelativeLocation>(count);
        for (int i = 0; i < count; ++i) {
            void i2;
            int n;
            int n2 = n = i;
            ArrayList<RelativeLocation> arrayList2 = arrayList;
            boolean bl = false;
            double t = count == 1 ? 1.0 : (double)i2 / (double)(count - 1);
            double u = 1.0 - t;
            double u2 = u * u;
            double t2 = t * t;
            double x = u2 * u * 0.0 + (double)3 * u2 * t * startHandle.getX() + (double)3 * u * t2 * end.getX() + t2 * t * target.getX();
            double y = u2 * u * 0.0 + (double)3 * u2 * t * startHandle.getY() + (double)3 * u * t2 * end.getY() + t2 * t * target.getY();
            arrayList2.add(new RelativeLocation(x, y, 0.0));
        }
        return arrayList;
    }

    public final double cubicBezier(double t, double p0, double p1, double p2, double p3) {
        double u = 1.0 - t;
        double u2 = u * u;
        double t2 = t * t;
        return u2 * u * p0 + (double)3 * u2 * t * p1 + (double)3 * u * t2 * p2 + t2 * t * p3;
    }

    @NotNull
    public final Triple<Float, Float, Float> calculateEulerAnglesToPoint(@NotNull Vector3f target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target.x == 0.0f && target.y == 0.0f && target.z == 0.0f) {
            return new Triple((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        float pitch = (float)Math.atan2(target.y, (float)Math.sqrt(target.x * target.x + target.z * target.z));
        float yaw = -((float)Math.atan2(target.z, target.x));
        float roll = 0.0f;
        return new Triple((Object)Float.valueOf(pitch), (Object)Float.valueOf(yaw), (Object)Float.valueOf(roll));
    }

    @NotNull
    public final List<RelativeLocation> generateExplosionCurve(double power, double maxHeight, double handleRadius, double step, int minCircleCount, int maxCircleCount) {
        List list;
        if (handleRadius <= 0.0 || maxHeight <= 0.0 || step <= 0.0) {
            return CollectionsKt.emptyList();
        }
        if (minCircleCount <= 0 || maxCircleCount < minCircleCount) {
            return CollectionsKt.emptyList();
        }
        List $this$generateExplosionCurve_u24lambda_u2417 = list = (List)new ArrayList();
        boolean bl = false;
        $this$generateExplosionCurve_u24lambda_u2417.add(new RelativeLocation(0.0, maxHeight, 0.0));
        List points = list;
        double maxRadius = RangesKt.coerceAtLeast((double)handleRadius, (double)step);
        int totalCircles = (int)(maxRadius / step);
        double countStep = totalCircles > 0 ? (double)(maxCircleCount - minCircleCount) / (double)totalCircles : 0.0;
        double currentRadius = 0.0;
        currentRadius = step;
        for (int i = 0; i < totalCircles; ++i) {
            int circleIndex = i;
            boolean bl2 = false;
            int particleCount = minCircleCount + (int)(countStep * (double)circleIndex);
            double angleStep = Math.PI * 2 / (double)particleCount;
            int n = 0;
            while (n < particleCount) {
                int particleIndex = n++;
                boolean bl3 = false;
                double angle = angleStep * (double)particleIndex;
                double x = currentRadius * Math.cos(angle);
                double z = currentRadius * Math.sin(angle);
                double normalized = currentRadius / handleRadius;
                double intensity = maxHeight * Math.pow(1.0 - normalized, power);
                points.add(new RelativeLocation(x, intensity, z));
            }
            currentRadius += step;
        }
        return points;
    }

    public static /* synthetic */ List generateExplosionCurve$default(Math3DUtil math3DUtil, double d, double d2, double d3, double d4, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            d4 = 1.0;
        }
        if ((n3 & 0x10) != 0) {
            n = 8;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 24;
        }
        return math3DUtil.generateExplosionCurve(d, d2, d3, d4, n, n2);
    }

    private final int getAxisSymbol(class_243 loc) {
        int quadrants = this.getQuadrants(this.getYawFromLocation(loc));
        return switch (quadrants) {
            case 1 -> {
                if (loc.field_1352 >= 0.0 && loc.field_1350 >= 0.0) {
                    yield 1;
                }
                yield -1;
            }
            case 2 -> {
                if (loc.field_1352 <= 0.0 && loc.field_1350 >= 0.0) {
                    yield 1;
                }
                yield -1;
            }
            case 3 -> {
                if (loc.field_1352 <= 0.0 && loc.field_1350 <= 0.0) {
                    yield 1;
                }
                yield -1;
            }
            case 4 -> {
                if (loc.field_1352 >= 0.0 && loc.field_1350 <= 0.0) {
                    yield 1;
                }
                yield -1;
            }
            default -> 1;
        };
    }

    private final int getQuadrants(double rad) {
        double sin = Math.sin(rad);
        double cos = Math.cos(rad);
        return sin > 0.0 && cos > 0.0 ? 1 : (sin < 0.0 && cos > 0.0 ? 4 : (sin > 0.0 && cos < 0.0 ? 2 : (sin < 0.0 && cos < 0.0 ? 3 : (sin == 0.0 && cos > 0.0 ? 1 : (sin == 0.0 && cos < 0.0 ? 3 : (sin > 0.0 ? 2 : 4))))));
    }
}

