/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils;

import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.extend.Vec3iExtendsKt;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\r\u0010\u0011J%\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0014J=\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ7\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcn/coostack/cooparticlesapi/utils/PhysicsUtil;", "", "<init>", "()V", "Lnet/minecraft/class_3965;", "res", "Lnet/minecraft/class_243;", "fixBeforeCollidePosition", "(Lnet/minecraft/class_3965;)Lnet/minecraft/class_243;", "currentPos", "velocity", "Lnet/minecraft/class_1937;", "world", "collide", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_1937;)Lnet/minecraft/class_3965;", "Lnet/minecraft/class_1297;", "entity", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_1937;Lnet/minecraft/class_1297;)Lnet/minecraft/class_3965;", "collideMovement", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_1937;)Lnet/minecraft/class_243;", "(Lnet/minecraft/class_3965;Lnet/minecraft/class_243;)Lnet/minecraft/class_243;", "Ljava/util/function/Predicate;", "Lnet/minecraft/class_1309;", "entityPredicate", "", "ignoreBlock", "Lnet/minecraft/class_239;", "rayCast", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_1937;Ljava/util/function/Predicate;Z)Lnet/minecraft/class_239;", "start", "end", "predicate", "Lnet/minecraft/class_3966;", "getEntityHitResult", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_243;Lnet/minecraft/class_243;Ljava/util/function/Predicate;)Lnet/minecraft/class_3966;", "cooparticlesapi-fabric-1.21.1"})
public final class PhysicsUtil {
    @NotNull
    public static final PhysicsUtil INSTANCE = new PhysicsUtil();

    private PhysicsUtil() {
    }

    @NotNull
    public final class_243 fixBeforeCollidePosition(@NotNull class_3965 res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        class_2382 class_23822 = res.method_17780().method_10163();
        Intrinsics.checkNotNullExpressionValue((Object)class_23822, (String)"getNormal(...)");
        class_243 offset = Vec3iExtendsKt.asVec3(class_23822);
        class_243 class_2432 = res.method_17784();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getLocation(...)");
        class_243 class_2433 = offset.method_1029();
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"normalize(...)");
        return Vec3ExtendsKt.plus(class_2432, Vec3ExtendsKt.times(class_2433, 0.07));
    }

    @NotNull
    public final class_3965 collide(@NotNull class_243 currentPos, @NotNull class_243 velocity, @NotNull class_1937 world) {
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        class_3959 context = new class_3959(currentPos, Vec3ExtendsKt.plus(currentPos, velocity), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194());
        class_3965 class_39652 = world.method_17742(context);
        Intrinsics.checkNotNullExpressionValue((Object)class_39652, (String)"clip(...)");
        return class_39652;
    }

    @NotNull
    public final class_3965 collide(@NotNull class_243 currentPos, @NotNull class_243 velocity, @NotNull class_1937 world, @NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        class_3959 context = new class_3959(currentPos, Vec3ExtendsKt.plus(currentPos, velocity), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity);
        class_3965 class_39652 = world.method_17742(context);
        Intrinsics.checkNotNullExpressionValue((Object)class_39652, (String)"clip(...)");
        return class_39652;
    }

    @NotNull
    public final class_243 collideMovement(@NotNull class_243 currentPos, @NotNull class_243 velocity, @NotNull class_1937 world) {
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        class_243 next = Vec3ExtendsKt.plus(currentPos, velocity);
        class_3959 context = new class_3959(currentPos, next, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194());
        class_3965 clip = world.method_17742(context);
        Intrinsics.checkNotNull((Object)clip);
        return this.collideMovement(clip, velocity);
    }

    @NotNull
    public final class_243 collideMovement(@NotNull class_3965 res, @NotNull class_243 velocity) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        class_2382 class_23822 = res.method_17780().method_10163();
        Intrinsics.checkNotNullExpressionValue((Object)class_23822, (String)"getNormal(...)");
        class_243 normal = Vec3iExtendsKt.asVec3(class_23822);
        class_243 mulNormal = Vec3ExtendsKt.times(normal, Vec3ExtendsKt.asAbs(velocity));
        return Vec3ExtendsKt.plus(velocity, mulNormal);
    }

    @Nullable
    public final class_239 rayCast(@NotNull class_243 currentPos, @NotNull class_243 velocity, @NotNull class_1937 world, @NotNull Predicate<class_1309> entityPredicate, boolean ignoreBlock) {
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(entityPredicate, (String)"entityPredicate");
        class_3966 entityHit = this.getEntityHitResult(world, currentPos, Vec3ExtendsKt.plus(currentPos, velocity), entityPredicate);
        if (ignoreBlock) {
            return (class_239)entityHit;
        }
        class_3965 blockHit = this.collide(currentPos, velocity, world);
        return entityHit != null ? (blockHit.method_17784().method_1022(currentPos) > entityHit.method_17784().method_1022(currentPos) ? (class_239)entityHit : (class_239)blockHit) : (class_239)blockHit;
    }

    private final class_3966 getEntityHitResult(class_1937 world, class_243 start, class_243 end, Predicate<class_1309> predicate) {
        class_3966 class_39662;
        class_1309 searchEntity = null;
        class_243 searchPos = null;
        class_238 searchBox = class_238.method_30048((class_243)start, (double)2.0, (double)2.0, (double)2.0).method_18804(Vec3ExtendsKt.times(Vec3ExtendsKt.plus(start, end), 3.0)).method_1014(1.0);
        double currentDistance = 0.0;
        for (class_1309 entity : world.method_8390(class_1309.class, searchBox, predicate)) {
            class_238 entityBox = entity.method_5829().method_1014((double)entity.method_5871());
            Optional clip = entityBox.method_992(start, end);
            if (entityBox.method_1006(start)) {
                searchEntity = entity;
                searchPos = clip.orElse(start);
                continue;
            }
            if (!clip.isPresent()) continue;
            Object t = clip.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            class_243 p = (class_243)t;
            double distance = start.method_1025(p);
            if (!(distance < currentDistance) && !(currentDistance == 0.0)) continue;
            searchEntity = entity;
            searchPos = p;
            currentDistance = distance;
        }
        if (searchEntity == null) {
            class_39662 = null;
        } else {
            class_1297 class_12972 = (class_1297)searchEntity;
            class_243 class_2432 = searchPos;
            Intrinsics.checkNotNull(class_2432);
            class_39662 = new class_3966(class_12972, class_2432);
        }
        return class_39662;
    }
}

