/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.helper;

import cn.coostack.cooparticlesapi.particles.Controlable;
import cn.coostack.cooparticlesapi.utils.GraphMathHelper;
import cn.coostack.cooparticlesapi.utils.helper.ParticleHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0010J\r\u0010\u0016\u001a\u00020\f\u00a2\u0006\u0004\b\u0016\u0010\u0010J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0015\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH&\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002H&\u00a2\u0006\u0004\b \u0010\u000eR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010\u000eR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010!\u001a\u0004\b$\u0010\u001f\"\u0004\b%\u0010\u000eR\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010\u0014R*\u0010\u0012\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00058\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010&\u001a\u0004\b+\u0010(\"\u0004\b,\u0010\u0014R\"\u0010-\u001a\u00020\u00028\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010!\u001a\u0004\b.\u0010\u001f\"\u0004\b/\u0010\u000e\u00a8\u00060"}, d2={"Lcn/coostack/cooparticlesapi/utils/helper/AlphaHelper;", "Lcn/coostack/cooparticlesapi/utils/helper/ParticleHelper;", "", "minAlpha", "maxAlpha", "", "alphaTick", "<init>", "(DDI)V", "recalculateStep", "()Lcn/coostack/cooparticlesapi/utils/helper/AlphaHelper;", "alpha", "", "toggleAlpha", "(D)V", "resetAlphaMin", "()V", "resetAlphaMax", "current", "doAlphaTo", "(I)V", "increaseAlpha", "decreaseAlpha", "", "over", "()Z", "isZero", "Lcn/coostack/cooparticlesapi/particles/Controlable;", "getLoadedGroup", "()Lcn/coostack/cooparticlesapi/particles/Controlable;", "getCurrentAlpha", "()D", "setAlpha", "D", "getMinAlpha", "setMinAlpha", "getMaxAlpha", "setMaxAlpha", "I", "getAlphaTick", "()I", "setAlphaTick", "value", "getCurrent", "setCurrent", "step", "getStep", "setStep", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAlphaHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlphaHelper.kt\ncn/coostack/cooparticlesapi/utils/helper/AlphaHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public abstract class AlphaHelper
implements ParticleHelper {
    private double minAlpha;
    private double maxAlpha;
    private int alphaTick;
    private int current;
    private double step;

    public AlphaHelper(double minAlpha, double maxAlpha, int alphaTick) {
        this.minAlpha = minAlpha;
        this.maxAlpha = maxAlpha;
        this.alphaTick = alphaTick;
        this.step = Math.abs(this.maxAlpha - this.minAlpha) / (double)this.alphaTick;
        double temp = Math.min(this.minAlpha, this.maxAlpha);
        this.maxAlpha = Math.max(this.minAlpha, this.maxAlpha);
        this.minAlpha = temp;
    }

    public final double getMinAlpha() {
        return this.minAlpha;
    }

    public final void setMinAlpha(double d) {
        this.minAlpha = d;
    }

    public final double getMaxAlpha() {
        return this.maxAlpha;
    }

    public final void setMaxAlpha(double d) {
        this.maxAlpha = d;
    }

    public final int getAlphaTick() {
        return this.alphaTick;
    }

    public final void setAlphaTick(int n) {
        this.alphaTick = n;
    }

    public final int getCurrent() {
        return this.current;
    }

    protected final void setCurrent(int n) {
        this.current = n;
    }

    protected final double getStep() {
        return this.step;
    }

    protected final void setStep(double d) {
        this.step = d;
    }

    @NotNull
    public final AlphaHelper recalculateStep() {
        double temp = Math.min(this.minAlpha, this.maxAlpha);
        this.maxAlpha = Math.max(this.minAlpha, this.maxAlpha);
        this.minAlpha = temp;
        this.step = Math.abs(this.maxAlpha - this.minAlpha) / (double)this.alphaTick;
        return this;
    }

    public final void toggleAlpha(double alpha) {
        if (alpha <= this.minAlpha) {
            this.resetAlphaMin();
        } else if (alpha >= this.maxAlpha) {
            this.current = this.alphaTick;
            this.resetAlphaMax();
        } else {
            int tick;
            double point = alpha - this.minAlpha;
            this.current = tick = MathKt.roundToInt((double)(point / this.step));
            this.doAlphaTo(this.current);
        }
    }

    public final void resetAlphaMin() {
        block0: {
            Controlable<?> controlable = this.getLoadedGroup();
            if (controlable == null) break block0;
            Controlable<?> it = controlable;
            boolean bl = false;
            this.current = 0;
            this.setAlpha(this.minAlpha);
        }
    }

    public final void resetAlphaMax() {
        block0: {
            Controlable<?> controlable = this.getLoadedGroup();
            if (controlable == null) break block0;
            Controlable<?> it = controlable;
            boolean bl = false;
            this.current = this.alphaTick;
            this.setAlpha(this.maxAlpha);
        }
    }

    public final void doAlphaTo(int current) {
        block4: {
            int enter;
            Controlable<?> controlable = this.getLoadedGroup();
            if (controlable == null) break block4;
            Controlable<?> it = controlable;
            boolean bl = false;
            this.current = enter = RangesKt.coerceAtLeast((int)current, (int)0);
            if (current >= this.alphaTick) {
                this.resetAlphaMax();
            } else if (current <= 0) {
                this.resetAlphaMin();
            } else {
                double progress = (double)current / (double)this.alphaTick;
                double alpha = GraphMathHelper.lerp(progress, this.minAlpha, this.maxAlpha);
                this.setAlpha(alpha);
            }
        }
    }

    public final void increaseAlpha() {
        block1: {
            Controlable<?> controlable;
            Controlable<Object> controlable2 = this.getLoadedGroup();
            if (controlable2 == null) break block1;
            Controlable<?> it = controlable = controlable2;
            boolean bl = false;
            controlable2 = !this.over() ? controlable : null;
            if (controlable2 != null) {
                it = controlable2;
                boolean bl2 = false;
                int n = this.current;
                this.current = n + 1;
                double progress = (double)this.current / (double)this.alphaTick;
                double alpha = GraphMathHelper.lerp(progress, this.minAlpha, this.maxAlpha);
                this.setAlpha(alpha);
            }
        }
    }

    public final void decreaseAlpha() {
        block1: {
            Controlable<?> controlable;
            Controlable<Object> controlable2 = this.getLoadedGroup();
            if (controlable2 == null) break block1;
            Controlable<?> it = controlable = controlable2;
            boolean bl = false;
            controlable2 = !this.isZero() ? controlable : null;
            if (controlable2 != null) {
                it = controlable2;
                boolean bl2 = false;
                int n = this.current;
                this.current = n + -1;
                double progress = (double)this.current / (double)this.alphaTick;
                double alpha = GraphMathHelper.lerp(progress, this.minAlpha, this.maxAlpha);
                this.setAlpha(alpha);
            }
        }
    }

    public final boolean over() {
        return this.alphaTick <= this.current;
    }

    public final boolean isZero() {
        return this.current <= 0;
    }

    @Nullable
    public abstract Controlable<?> getLoadedGroup();

    public abstract double getCurrentAlpha();

    public abstract void setAlpha(double var1);
}

