/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.helper;

import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.helper.ScaleHelper;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0013R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\t\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R(\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcn/coostack/cooparticlesapi/utils/helper/BezierValueScaleHelper;", "Lcn/coostack/cooparticlesapi/utils/helper/ScaleHelper;", "", "scaleTick", "", "minScale", "maxScale", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "controlPoint1", "controlPoint2", "<init>", "(IDDLcn/coostack/cooparticlesapi/utils/RelativeLocation;Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)V", "recalculateStep", "()Lcn/coostack/cooparticlesapi/utils/helper/BezierValueScaleHelper;", "scale", "", "toggleScale", "(D)V", "doScale", "()V", "current", "doScaleTo", "(I)V", "doScaleReversed", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "getControlPoint1", "()Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "setControlPoint1", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)V", "getControlPoint2", "setControlPoint2", "deltaScale", "D", "", "bezierPoints", "Ljava/util/List;", "getBezierPoints", "()Ljava/util/List;", "setBezierPoints", "(Ljava/util/List;)V", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nBezierValueScaleHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BezierValueScaleHelper.kt\ncn/coostack/cooparticlesapi/utils/helper/BezierValueScaleHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n2393#2,14:77\n*S KotlinDebug\n*F\n+ 1 BezierValueScaleHelper.kt\ncn/coostack/cooparticlesapi/utils/helper/BezierValueScaleHelper\n*L\n37#1:77,14\n*E\n"})
public abstract class BezierValueScaleHelper
extends ScaleHelper {
    @NotNull
    private RelativeLocation controlPoint1;
    @NotNull
    private RelativeLocation controlPoint2;
    private final double deltaScale;
    @NotNull
    private List<RelativeLocation> bezierPoints;

    public BezierValueScaleHelper(int scaleTick, double minScale, double maxScale, @NotNull RelativeLocation controlPoint1, @NotNull RelativeLocation controlPoint2) {
        Intrinsics.checkNotNullParameter((Object)controlPoint1, (String)"controlPoint1");
        Intrinsics.checkNotNullParameter((Object)controlPoint2, (String)"controlPoint2");
        super(minScale, maxScale, scaleTick);
        this.controlPoint1 = controlPoint1;
        this.controlPoint2 = controlPoint2;
        this.deltaScale = maxScale - minScale;
        this.bezierPoints = Math3DUtil.INSTANCE.generateBezierCurve(new RelativeLocation((double)scaleTick, this.deltaScale, 0.0), this.controlPoint1, this.controlPoint2, scaleTick);
    }

    @NotNull
    public final RelativeLocation getControlPoint1() {
        return this.controlPoint1;
    }

    public final void setControlPoint1(@NotNull RelativeLocation relativeLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"<set-?>");
        this.controlPoint1 = relativeLocation;
    }

    @NotNull
    public final RelativeLocation getControlPoint2() {
        return this.controlPoint2;
    }

    public final void setControlPoint2(@NotNull RelativeLocation relativeLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"<set-?>");
        this.controlPoint2 = relativeLocation;
    }

    @NotNull
    public final List<RelativeLocation> getBezierPoints() {
        return this.bezierPoints;
    }

    public final void setBezierPoints(@NotNull List<RelativeLocation> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.bezierPoints = list;
    }

    @Override
    @NotNull
    public BezierValueScaleHelper recalculateStep() {
        double temp = Math.min(this.getMinScale(), this.getMaxScale());
        this.setMaxScale(Math.max(this.getMinScale(), this.getMaxScale()));
        this.setMinScale(temp);
        this.bezierPoints = Math3DUtil.INSTANCE.generateBezierCurve(new RelativeLocation((double)this.getScaleTick(), this.deltaScale, 0.0), this.controlPoint1, this.controlPoint2, this.getScaleTick());
        return this;
    }

    @Override
    public void toggleScale(double scale) {
        Object t;
        Iterable $this$minBy$iv = CollectionsKt.withIndex((Iterable)this.bezierPoints);
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = minElem$iv;
        } else {
            IndexedValue it = (IndexedValue)minElem$iv;
            boolean bl = false;
            double minValue$iv = Math.abs(((RelativeLocation)it.getValue()).getY() - scale);
            do {
                Object e$iv = iterator$iv.next();
                IndexedValue it2 = (IndexedValue)e$iv;
                $i$a$-minByOrThrow-BezierValueScaleHelper$toggleScale$currentPoint$1 = false;
                double v$iv = Math.abs(((RelativeLocation)it2.getValue()).getY() - scale);
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = minElem$iv;
        }
        IndexedValue currentPoint = (IndexedValue)t;
        this.setCurrent(currentPoint.getIndex());
        this.scale(this.getMinScale() + ((RelativeLocation)currentPoint.getValue()).getY());
    }

    @Override
    public void doScale() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        if (this.over()) {
            return;
        }
        int n = this.getCurrent();
        this.setCurrent(n + 1);
        double value = this.bezierPoints.get(n).getY();
        this.scale(this.getMinScale() + value);
    }

    @Override
    public void doScaleTo(int current) {
        int enter = RangesKt.coerceAtLeast((int)current, (int)0);
        this.setCurrent(enter);
        if (current >= this.getScaleTick()) {
            this.resetScaleMax();
            return;
        }
        if (current <= 0) {
            this.resetScaleMin();
            return;
        }
        double value = this.bezierPoints.get(current).getY();
        this.scale(this.getMinScale() + value);
    }

    @Override
    public void doScaleReversed() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        if (this.isZero()) {
            return;
        }
        this.setCurrent(this.getCurrent() + -1);
        double value = this.bezierPoints.get(Math.max(0, this.getCurrent())).getY();
        this.scale(this.getMinScale() + value);
    }
}

