/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.helper;

import cn.coostack.cooparticlesapi.particles.Controlable;
import cn.coostack.cooparticlesapi.utils.GraphMathHelper;
import cn.coostack.cooparticlesapi.utils.helper.ParticleHelper;
import kotlin.Metadata;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0010J\u000f\u0010\u0016\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0010J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0015\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH&\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u000b\u0010\u000eR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\u001f\"\u0004\b\"\u0010\u000eR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010 \u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010\u000eR\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010\u0014R*\u0010\u0012\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00058\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010%\u001a\u0004\b*\u0010'\"\u0004\b+\u0010\u0014R\"\u0010,\u001a\u00020\u00028\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010 \u001a\u0004\b-\u0010\u001f\"\u0004\b.\u0010\u000e\u00a8\u0006/"}, d2={"Lcn/coostack/cooparticlesapi/utils/helper/ScaleHelper;", "Lcn/coostack/cooparticlesapi/utils/helper/ParticleHelper;", "", "minScale", "maxScale", "", "scaleTick", "<init>", "(DDI)V", "recalculateStep", "()Lcn/coostack/cooparticlesapi/utils/helper/ScaleHelper;", "scale", "", "toggleScale", "(D)V", "resetScaleMin", "()V", "resetScaleMax", "current", "doScaleTo", "(I)V", "doScale", "doScaleReversed", "", "over", "()Z", "isZero", "Lcn/coostack/cooparticlesapi/particles/Controlable;", "getLoadedGroup", "()Lcn/coostack/cooparticlesapi/particles/Controlable;", "getGroupScale", "()D", "D", "getMinScale", "setMinScale", "getMaxScale", "setMaxScale", "I", "getScaleTick", "()I", "setScaleTick", "value", "getCurrent", "setCurrent", "step", "getStep", "setStep", "cooparticlesapi-fabric-1.21.1"})
public abstract class ScaleHelper
implements ParticleHelper {
    private double minScale;
    private double maxScale;
    private int scaleTick;
    private int current;
    private double step;

    public ScaleHelper(double minScale, double maxScale, int scaleTick) {
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.scaleTick = scaleTick;
        this.step = Math.abs(this.maxScale - this.minScale) / (double)this.scaleTick;
        double temp = Math.min(this.minScale, this.maxScale);
        this.maxScale = Math.max(this.minScale, this.maxScale);
        this.minScale = temp;
    }

    public final double getMinScale() {
        return this.minScale;
    }

    public final void setMinScale(double d) {
        this.minScale = d;
    }

    public final double getMaxScale() {
        return this.maxScale;
    }

    public final void setMaxScale(double d) {
        this.maxScale = d;
    }

    public final int getScaleTick() {
        return this.scaleTick;
    }

    public final void setScaleTick(int n) {
        this.scaleTick = n;
    }

    public final int getCurrent() {
        return this.current;
    }

    protected final void setCurrent(int n) {
        this.current = n;
    }

    protected final double getStep() {
        return this.step;
    }

    protected final void setStep(double d) {
        this.step = d;
    }

    @NotNull
    public ScaleHelper recalculateStep() {
        double temp = Math.min(this.minScale, this.maxScale);
        this.maxScale = Math.max(this.minScale, this.maxScale);
        this.minScale = temp;
        this.step = Math.abs(this.maxScale - this.minScale) / (double)this.scaleTick;
        return this;
    }

    public void toggleScale(double scale) {
        int tick;
        if (scale <= this.minScale) {
            this.resetScaleMin();
            return;
        }
        if (scale >= this.maxScale) {
            this.current = this.scaleTick;
            this.resetScaleMax();
            return;
        }
        double point = scale - this.minScale;
        this.current = tick = MathKt.roundToInt((double)(point / this.step));
        this.doScaleTo(this.current);
    }

    public final void resetScaleMin() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        this.current = 0;
        this.scale(this.minScale);
    }

    public final void resetScaleMax() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        this.current = this.scaleTick - 1;
        this.scale(this.maxScale);
    }

    public void doScaleTo(int current) {
        int enter;
        if (this.getLoadedGroup() == null) {
            return;
        }
        this.current = enter = RangesKt.coerceAtLeast((int)current, (int)0);
        if (current >= this.scaleTick - 1) {
            this.resetScaleMax();
            return;
        }
        if (current <= 0) {
            this.resetScaleMin();
            return;
        }
        double lerp = GraphMathHelper.lerp((double)current / (double)this.scaleTick, this.minScale, this.maxScale);
        this.scale(lerp);
    }

    public void doScale() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        if (this.over()) {
            return;
        }
        int n = this.current;
        this.current = n + 1;
        double lerp = GraphMathHelper.lerp((double)this.current / (double)this.scaleTick, this.minScale, this.maxScale);
        this.scale(lerp);
    }

    public void doScaleReversed() {
        if (this.getLoadedGroup() == null) {
            return;
        }
        if (this.isZero()) {
            return;
        }
        int n = this.current;
        this.current = n + -1;
        double lerp = GraphMathHelper.lerp((double)this.current / (double)this.scaleTick, this.minScale, this.maxScale);
        this.scale(lerp);
    }

    public boolean over() {
        return this.scaleTick <= this.current;
    }

    public final boolean isZero() {
        return this.current <= 0;
    }

    @Nullable
    public abstract Controlable<?> getLoadedGroup();

    public abstract double getGroupScale();

    public abstract void scale(double var1);
}

