/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.interpolator.particle;

import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.utils.CircularQueue;
import cn.coostack.cooparticlesapi.utils.GraphMathHelper;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.interpolator.Interpolator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\t\u0010\fJ\u0017\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0011J2\u0010\u0018\u001a\u00020\u00002#\u0010\u0018\u001a\u001f\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J2\u0010\u001a\u001a\u00020\u00002#\u0010\u0018\u001a\u001f\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0015\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\u000e8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010!R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R3\u0010\u0018\u001a\u001f\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010)R3\u0010\u001a\u001a\u001f\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010)\u00a8\u0006*"}, d2={"Lcn/coostack/cooparticlesapi/utils/interpolator/particle/CircleParticleInterpolator;", "Lcn/coostack/cooparticlesapi/utils/interpolator/Interpolator;", "Ljava/util/function/Supplier;", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "originProvider", "<init>", "(Ljava/util/function/Supplier;)V", "Lnet/minecraft/class_243;", "vec", "insertPoint", "(Lnet/minecraft/class_243;)Lcn/coostack/cooparticlesapi/utils/interpolator/particle/CircleParticleInterpolator;", "Lorg/joml/Vector3f;", "(Lorg/joml/Vector3f;)Lcn/coostack/cooparticlesapi/utils/interpolator/particle/CircleParticleInterpolator;", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)Lcn/coostack/cooparticlesapi/utils/interpolator/particle/CircleParticleInterpolator;", "", "limit", "setLimit", "(D)Lcn/coostack/cooparticlesapi/utils/interpolator/particle/CircleParticleInterpolator;", "refiner", "setRefiner", "Lkotlin/Function2;", "", "", "Lkotlin/ExtensionFunctionType;", "rotater", "(Lkotlin/jvm/functions/Function2;)Lcn/coostack/cooparticlesapi/utils/interpolator/particle/CircleParticleInterpolator;", "rotaterBack", "getRefinedResult", "()Ljava/util/List;", "Ljava/util/function/Supplier;", "getOriginProvider", "()Ljava/util/function/Supplier;", "refinerCount", "D", "getRefinerCount", "()D", "setRefinerCount", "(D)V", "Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "queue", "Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "Lkotlin/jvm/functions/Function2;", "cooparticlesapi-fabric-1.21.1"})
public final class CircleParticleInterpolator
implements Interpolator {
    @NotNull
    private final Supplier<RelativeLocation> originProvider;
    private double refinerCount;
    private double limit;
    @NotNull
    private final CircularQueue<RelativeLocation> queue;
    @NotNull
    private Function2<? super CircleParticleInterpolator, ? super List<RelativeLocation>, Unit> rotater;
    @NotNull
    private Function2<? super CircleParticleInterpolator, ? super List<RelativeLocation>, Unit> rotaterBack;

    public CircleParticleInterpolator(@NotNull Supplier<RelativeLocation> originProvider) {
        Intrinsics.checkNotNullParameter(originProvider, (String)"originProvider");
        this.originProvider = originProvider;
        this.refinerCount = 2.0;
        this.limit = 256.0;
        this.queue = new CircularQueue(2);
        this.rotater = CircleParticleInterpolator::rotater$lambda$0;
        this.rotaterBack = CircleParticleInterpolator::rotaterBack$lambda$1;
    }

    @NotNull
    public final Supplier<RelativeLocation> getOriginProvider() {
        return this.originProvider;
    }

    @Override
    public double getRefinerCount() {
        return this.refinerCount;
    }

    public void setRefinerCount(double d) {
        this.refinerCount = d;
    }

    @Override
    @NotNull
    public CircleParticleInterpolator insertPoint(@NotNull class_243 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        this.insertPoint(Vec3ExtendsKt.asRelative(vec));
        return this;
    }

    @Override
    @NotNull
    public CircleParticleInterpolator insertPoint(@NotNull Vector3f vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        this.insertPoint(Vec3ExtendsKt.asRelative(vec));
        return this;
    }

    @Override
    @NotNull
    public CircleParticleInterpolator insertPoint(@NotNull RelativeLocation vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        RelativeLocation relativeLocation = this.originProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)relativeLocation, (String)"get(...)");
        RelativeLocation origin = relativeLocation;
        if (vec.minus(origin).length() <= 1.0E-6) {
            return this;
        }
        this.queue.addFirst(vec);
        return this;
    }

    @Override
    @NotNull
    public CircleParticleInterpolator setLimit(double limit) {
        this.limit = limit;
        return this;
    }

    @Override
    @NotNull
    public CircleParticleInterpolator setRefiner(double refiner) {
        this.setRefinerCount(refiner);
        return this;
    }

    @NotNull
    public final CircleParticleInterpolator rotater(@NotNull Function2<? super CircleParticleInterpolator, ? super List<RelativeLocation>, Unit> rotater) {
        Intrinsics.checkNotNullParameter(rotater, (String)"rotater");
        this.rotater = rotater;
        return this;
    }

    @NotNull
    public final CircleParticleInterpolator rotaterBack(@NotNull Function2<? super CircleParticleInterpolator, ? super List<RelativeLocation>, Unit> rotater) {
        Intrinsics.checkNotNullParameter(rotater, (String)"rotater");
        this.rotaterBack = rotater;
        return this;
    }

    @Override
    @NotNull
    public List<RelativeLocation> getRefinedResult() {
        if (this.queue.empty()) {
            return new ArrayList();
        }
        if (this.queue.notNullSize() == 1) {
            Object[] objectArray = new RelativeLocation[]{this.queue.get(0)};
            return CollectionsKt.arrayListOf((Object[])objectArray);
        }
        if (this.queue.get(0).distance(this.queue.get(1)) > this.limit) {
            Object[] objectArray = new RelativeLocation[]{this.queue.get(1)};
            return CollectionsKt.arrayListOf((Object[])objectArray);
        }
        RelativeLocation relativeLocation = this.originProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)relativeLocation, (String)"get(...)");
        RelativeLocation origin = relativeLocation;
        RelativeLocation relPos1 = this.queue.get(0).minus(origin);
        RelativeLocation relPos2 = this.queue.get(1).minus(origin);
        Object[] objectArray = new RelativeLocation[]{relPos1, relPos2};
        this.rotaterBack.invoke((Object)this, (Object)CollectionsKt.listOf((Object[])objectArray));
        double r = Math.max(relPos1.length(), relPos2.length());
        double rad1 = Math.acos(relPos1.getX() / r);
        double rad2 = Math.acos(relPos2.getX() / r);
        double dr = Math.abs(rad1 - rad2);
        int count = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)(dr * this.getRefinerCount())), (int)1);
        ArrayList<RelativeLocation> res = new ArrayList<RelativeLocation>();
        int n = count + 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            double progress = GraphMathHelper.lerp((double)it / (double)count, rad1, rad2);
            double x = Math.cos(progress) * r;
            double z = Math.sin(progress) * r;
            res.add(new RelativeLocation(x, 0.0, z));
        }
        this.rotater.invoke((Object)this, res);
        return res;
    }

    private static final Unit rotater$lambda$0(CircleParticleInterpolator circleParticleInterpolator, List it) {
        Intrinsics.checkNotNullParameter((Object)circleParticleInterpolator, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit rotaterBack$lambda$1(CircleParticleInterpolator circleParticleInterpolator, List it) {
        Intrinsics.checkNotNullParameter((Object)circleParticleInterpolator, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

