/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.string;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.FunctionParameters;
import com.ezylang.evalex.parser.Token;

@FunctionParameters(value={@FunctionParameter(name="string"), @FunctionParameter(name="start", nonNegative=true), @FunctionParameter(name="end", isVarArg=true, nonNegative=true)})
public class StringSubstringFunction
extends AbstractFunction {
    @Override
    public void validatePreEvaluation(Token token, EvaluationValue ... parameterValues) throws EvaluationException {
        super.validatePreEvaluation(token, parameterValues);
        if (parameterValues.length > 2 && parameterValues[2].getNumberValue().intValue() < parameterValues[1].getNumberValue().intValue()) {
            throw new EvaluationException(token, "End index must be greater than or equal to start index");
        }
    }

    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        String result;
        String string = parameterValues[0].getStringValue();
        int start = parameterValues[1].getNumberValue().intValue();
        if (parameterValues.length > 2) {
            int end = parameterValues[2].getNumberValue().intValue();
            int length = string.length();
            int finalEnd = Math.min(end, length);
            result = string.substring(start, finalEnd);
        } else {
            result = string.substring(start);
        }
        return expression.convertValue(result);
    }
}

