/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.trigonometric;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;

@FunctionParameter(name="value")
public class AsinRFunction
extends AbstractFunction {
    private static final BigDecimal MINUS_ONE = BigDecimal.valueOf(-1L);

    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        BigDecimal parameterValue = parameterValues[0].getNumberValue();
        if (parameterValue.compareTo(BigDecimal.ONE) > 0) {
            throw new EvaluationException(functionToken, "Illegal asinr(x) for x > 1: x = " + String.valueOf(parameterValue));
        }
        if (parameterValue.compareTo(MINUS_ONE) < 0) {
            throw new EvaluationException(functionToken, "Illegal asinr(x) for x < -1: x = " + String.valueOf(parameterValue));
        }
        return expression.convertDoubleValue(Math.asin(parameterValues[0].getNumberValue().doubleValue()));
    }
}

