/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi;

import cn.coostack.cooparticlesapi.animation.AnimateManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.particles.CooModParticles;
import cn.coostack.cooparticlesapi.particles.control.group.ClientParticleGroupManager;
import cn.coostack.cooparticlesapi.renderer.client.ClientRenderEntityManager;
import cn.coostack.cooparticlesapi.renderer.client.ClientRenderPipelineManager;
import cn.coostack.cooparticlesapi.renderer.client.ShaderPipeManagers;
import cn.coostack.cooparticlesapi.scheduler.CooScheduler;
import cn.coostack.cooparticlesapi.test.particle.client.BarrierSwordGroupClient;
import cn.coostack.cooparticlesapi.test.particle.client.ScaleCircleGroupClient;
import cn.coostack.cooparticlesapi.test.particle.client.SequencedMagicCircleClient;
import cn.coostack.cooparticlesapi.test.particle.client.TestGroupClient;
import cn.coostack.cooparticlesapi.test.particle.style.ExampleSequencedStyle;
import cn.coostack.cooparticlesapi.test.particle.style.ExampleStyle;
import cn.coostack.cooparticlesapi.test.particle.style.RomaMagicTestStyle;
import cn.coostack.cooparticlesapi.test.particle.style.RotateTestStyle;
import cn.coostack.cooparticlesapi.test.particle.style.TestShapeUtilStyle;
import cn.coostack.cooparticlesapi.test.renderer.TestRendererEntity;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.TickRateManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcn/coostack/cooparticlesapi/CooParticlesAPIClient;", "", "<init>", "()V", "scheduler", "Lcn/coostack/cooparticlesapi/scheduler/CooScheduler;", "init", "", "initParticleType", "initGroup", "initStyle", "initRender", "onDisconnect", "afterClientWorldChange", "subTicks", "", "getSubTicks", "()D", "setSubTicks", "(D)V", "renderInit", "", "getRenderInit", "()Z", "setRenderInit", "(Z)V", "tickClient", "world", "Lnet/minecraft/client/multiplayer/ClientLevel;", "cooparticlesapi-fabric-1.21.1"})
public final class CooParticlesAPIClient {
    @NotNull
    public static final CooParticlesAPIClient INSTANCE = new CooParticlesAPIClient();
    @JvmField
    @NotNull
    public static final CooScheduler scheduler = new CooScheduler();
    private static double subTicks;
    private static boolean renderInit;

    private CooParticlesAPIClient() {
    }

    @JvmStatic
    public static final void init() {
        INSTANCE.initGroup();
        INSTANCE.initStyle();
        INSTANCE.initParticleType();
        INSTANCE.initRender();
    }

    private final void initParticleType() {
        ParticleEmittersManager.INSTANCE.init$cooparticlesapi_fabric_1_21_1();
        CooModParticles.INSTANCE.reg();
    }

    private final void initGroup() {
        ClientParticleGroupManager.INSTANCE.register(TestGroupClient.class, new TestGroupClient.Provider());
        ClientParticleGroupManager.INSTANCE.register(ScaleCircleGroupClient.class, new ScaleCircleGroupClient.Provider());
        ClientParticleGroupManager.INSTANCE.register(BarrierSwordGroupClient.class, new BarrierSwordGroupClient.Provider());
        ClientParticleGroupManager.INSTANCE.register(SequencedMagicCircleClient.class, new SequencedMagicCircleClient.Provider());
    }

    private final void initStyle() {
        ParticleStyleManager.INSTANCE.register(ExampleStyle.class, new ExampleStyle.Provider());
        ParticleStyleManager.INSTANCE.register(ExampleSequencedStyle.class, new ExampleSequencedStyle.Provider());
        ParticleStyleManager.INSTANCE.register(RomaMagicTestStyle.class, new RomaMagicTestStyle.Provider());
        ParticleStyleManager.INSTANCE.register(RotateTestStyle.class, new RotateTestStyle.Provider());
        ParticleStyleManager.INSTANCE.register(TestShapeUtilStyle.class, new TestShapeUtilStyle.Provider());
    }

    private final void initRender() {
        ClientRenderEntityManager.INSTANCE.register(TestRendererEntity.Companion.getId(), TestRendererEntity.Companion.getCodec());
        ClientRenderEntityManager.INSTANCE.bindEntityRenderPipe(TestRendererEntity.Companion.getId(), ShaderPipeManagers.INSTANCE.getTestBloom().getPipeID());
    }

    public final void onDisconnect() {
        ParticleEmittersManager.INSTANCE.getClientEmitters().clear();
        ParticleStyleManager.INSTANCE.clearAllVisible();
        ClientRenderEntityManager.INSTANCE.clear();
        ClientParticleGroupManager.INSTANCE.clearAllVisible();
    }

    public final void afterClientWorldChange() {
        ParticleEmittersManager.INSTANCE.getClientEmitters().clear();
        ParticleStyleManager.INSTANCE.clearAllVisible();
        ClientParticleGroupManager.INSTANCE.clearAllVisible();
        ClientRenderEntityManager.INSTANCE.clear();
    }

    public final double getSubTicks() {
        return subTicks;
    }

    public final void setSubTicks(double d) {
        subTicks = d;
    }

    public final boolean getRenderInit() {
        return renderInit;
    }

    public final void setRenderInit(boolean bl) {
        renderInit = bl;
    }

    public final void tickClient(@NotNull ClientLevel world) {
        TickRateManager tickManager;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (!renderInit) {
            ShaderPipeManagers.INSTANCE.init();
            ClientRenderPipelineManager.INSTANCE.init();
            renderInit = true;
        }
        if (!(tickManager = world.tickRateManager()).runsNormally()) {
            return;
        }
        float rate = tickManager.tickrate();
        double preInvokeTimes = (double)rate / 20.0;
        if ((subTicks += preInvokeTimes) >= 1.0) {
            int toInt = (int)subTicks;
            subTicks -= (double)toInt;
            int n = 0;
            while (n < toInt) {
                int it = n++;
                boolean bl = false;
                scheduler.doTick$cooparticlesapi_fabric_1_21_1();
                ClientParticleGroupManager.INSTANCE.doClientTick();
                ParticleStyleManager.INSTANCE.doTickClient();
                ParticleEmittersManager.INSTANCE.doTickClient();
                AnimateManager.INSTANCE.tickClient();
                ClientRenderEntityManager.INSTANCE.tick();
            }
        }
    }
}

