/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.animation;

import cn.coostack.cooparticlesapi.animation.StreamAnimation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010)\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0014"}, d2={"Lcn/coostack/cooparticlesapi/animation/AnimateManager;", "", "<init>", "()V", "serverAnimates", "", "Lcn/coostack/cooparticlesapi/animation/StreamAnimation;", "getServerAnimates", "()Ljava/util/List;", "clientAnimates", "getClientAnimates", "addClient", "", "animation", "addServer", "tickServer", "tickClient", "tick", "iterator", "", "cooparticlesapi-fabric-1.21.1"})
public final class AnimateManager {
    @NotNull
    public static final AnimateManager INSTANCE = new AnimateManager();
    @NotNull
    private static final List<StreamAnimation> serverAnimates = new ArrayList();
    @NotNull
    private static final List<StreamAnimation> clientAnimates = new ArrayList();

    private AnimateManager() {
    }

    @NotNull
    public final List<StreamAnimation> getServerAnimates() {
        return serverAnimates;
    }

    @NotNull
    public final List<StreamAnimation> getClientAnimates() {
        return clientAnimates;
    }

    public final void addClient(@NotNull StreamAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        clientAnimates.add(animation);
    }

    public final void addServer(@NotNull StreamAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        serverAnimates.add(animation);
    }

    public final void tickServer() {
        Iterator<StreamAnimation> iterator = serverAnimates.iterator();
        this.tick(iterator);
    }

    public final void tickClient() {
        Iterator<StreamAnimation> iterator = clientAnimates.iterator();
        this.tick(iterator);
    }

    private final void tick(Iterator<StreamAnimation> iterator) {
        while (iterator.hasNext()) {
            StreamAnimation anim = iterator.next();
            anim.tick();
            if (!anim.getCanceled()) continue;
            iterator.remove();
        }
    }
}

