/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.items;

import cn.coostack.cooparticlesapi.renderer.server.ServerRenderEntityManager;
import cn.coostack.cooparticlesapi.test.renderer.TestRendererEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lcn/coostack/cooparticlesapi/items/TestTickItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "testShader", "", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/server/level/ServerPlayer;", "tickFrozen", "cooparticlesapi-fabric-1.21.1"})
public final class TestTickItem
extends Item {
    public TestTickItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world.isClientSide) {
            InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
            return interactionResultHolder;
        }
        this.testShader((ServerLevel)world, (ServerPlayer)user);
        InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    public final void testShader(@NotNull ServerLevel world, @NotNull ServerPlayer user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        TestRendererEntity shader = new TestRendererEntity((Level)world);
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        shader.setPosition(vec3);
        ServerRenderEntityManager.INSTANCE.spawn(shader);
    }

    public final void tickFrozen(@NotNull ServerLevel world, @NotNull ServerPlayer user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        MinecraftServer minecraftServer = world.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        MinecraftServer server = minecraftServer;
        ServerTickRateManager tickManager = server.tickRateManager();
        boolean frozen = tickManager.isFrozen();
        if (frozen) {
            if (tickManager.isSprinting()) {
                tickManager.stopSprinting();
            }
            if (tickManager.isSteppingForward()) {
                tickManager.stopStepping();
            }
        }
        tickManager.setFrozen(!frozen);
        user.sendSystemMessage((Component)Component.literal((String)("\u65f6\u505c " + !frozen)));
    }
}

