/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.mixin;

import cn.coostack.cooparticlesapi.utils.ClientCameraUtil;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CooParticleCameraMixin {
    @Shadow
    private float yRot;
    @Shadow
    private float xRot;
    @Shadow
    private Vec3 position;

    @Shadow
    protected abstract void setRotation(float var1, float var2);

    @Shadow
    protected abstract void setPosition(double var1, double var3, double var5);

    @Inject(method={"setup"}, at={@At(value="TAIL")})
    private void onUpdate(CallbackInfo ci) {
        float newYaw = this.yRot + ClientCameraUtil.INSTANCE.getShakeYawOffset() + ClientCameraUtil.INSTANCE.getCurrentYawOffset();
        float newPitch = this.xRot + ClientCameraUtil.INSTANCE.getShakePitchOffset() + ClientCameraUtil.INSTANCE.getCurrentPitchOffset();
        double x = this.position.x() + ClientCameraUtil.INSTANCE.getShakeXOffset() + ClientCameraUtil.INSTANCE.getCurrentXOffset();
        double y = this.position.y() + ClientCameraUtil.INSTANCE.getShakeYOffset() + ClientCameraUtil.INSTANCE.getCurrentYOffset();
        double z = this.position.z() + ClientCameraUtil.INSTANCE.getShakeZOffset() + ClientCameraUtil.INSTANCE.getCurrentZOffset();
        this.setRotation(newYaw, newPitch);
        this.setPosition(x, y, z);
    }
}

