/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.packet.client.listener;

import cn.coostack.cooparticlesapi.network.packet.PacketParticleEmittersS2C;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.platform.network.ClientContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lcn/coostack/cooparticlesapi/network/packet/client/listener/ClientParticleEmittersPacketHandler;", "", "<init>", "()V", "receive", "", "payload", "Lcn/coostack/cooparticlesapi/network/packet/PacketParticleEmittersS2C;", "context", "Lcn/coostack/cooparticlesapi/platform/network/ClientContext;", "handleChangeOrCreate", "handleRemove", "cooparticlesapi-fabric-1.21.1"})
public final class ClientParticleEmittersPacketHandler {
    @NotNull
    public static final ClientParticleEmittersPacketHandler INSTANCE = new ClientParticleEmittersPacketHandler();

    private ClientParticleEmittersPacketHandler() {
    }

    public final void receive(@NotNull PacketParticleEmittersS2C payload, @NotNull ClientContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        switch (WhenMappings.$EnumSwitchMapping$0[payload.getType().ordinal()]) {
            case 1: {
                this.handleChangeOrCreate(payload, context);
                break;
            }
            case 2: {
                this.handleRemove(payload);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void handleChangeOrCreate(@NotNull PacketParticleEmittersS2C payload, @NotNull ClientContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec = ParticleEmittersManager.INSTANCE.getCodecFromID(payload.getEmitterID());
        if (streamCodec == null) {
            return;
        }
        StreamCodec<FriendlyByteBuf, ParticleEmitters> codec = streamCodec;
        ParticleEmitters emitter = (ParticleEmitters)codec.decode((Object)payload.getEmitterBuf());
        Intrinsics.checkNotNull((Object)emitter);
        Level level = context.player().level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        ParticleEmittersManager.INSTANCE.createOrChangeClient(emitter, level);
    }

    public final void handleRemove(@NotNull PacketParticleEmittersS2C payload) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec = ParticleEmittersManager.INSTANCE.getCodecFromID(payload.getEmitterID());
            if (streamCodec == null) {
                return;
            }
            StreamCodec<FriendlyByteBuf, ParticleEmitters> codec = streamCodec;
            ParticleEmitters emitter = (ParticleEmitters)codec.decode((Object)payload.getEmitterBuf());
            ParticleEmitters particleEmitters = ParticleEmittersManager.INSTANCE.getClientEmitters().get(emitter.getUuid());
            if (particleEmitters == null) break block1;
            particleEmitters.setCancelled(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PacketParticleEmittersS2C.PacketType.values().length];
            try {
                nArray[PacketParticleEmittersS2C.PacketType.CHANGE_OR_CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PacketParticleEmittersS2C.PacketType.REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

