/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.packet.client.listener;

import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.network.packet.PacketParticleStyleS2C;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleProvider;
import cn.coostack.cooparticlesapi.particles.control.ControlType;
import cn.coostack.cooparticlesapi.platform.network.ClientContext;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000fH\u0002J(\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lcn/coostack/cooparticlesapi/network/packet/client/listener/ClientParticleStylePacketHandler;", "", "<init>", "()V", "receive", "", "packet", "Lcn/coostack/cooparticlesapi/network/packet/PacketParticleStyleS2C;", "context", "Lcn/coostack/cooparticlesapi/platform/network/ClientContext;", "handleRemove", "uuid", "Ljava/util/UUID;", "handleChange", "args", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "handleCreate", "cooparticlesapi-fabric-1.21.1"})
public final class ClientParticleStylePacketHandler {
    @NotNull
    public static final ClientParticleStylePacketHandler INSTANCE = new ClientParticleStylePacketHandler();

    private ClientParticleStylePacketHandler() {
    }

    public final void receive(@NotNull PacketParticleStyleS2C packet, @NotNull ClientContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        UUID uuid = packet.getUuid();
        ControlType type = packet.getType();
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.handleCreate(uuid, packet.getArgs());
                break;
            }
            case 2: {
                this.handleChange(uuid, packet.getArgs());
                break;
            }
            case 3: {
                this.handleRemove(uuid);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void handleRemove(UUID uuid) {
        block0: {
            ParticleGroupStyle particleGroupStyle = ParticleStyleManager.INSTANCE.getClientViewStyles().get(uuid);
            if (particleGroupStyle == null) break block0;
            particleGroupStyle.remove();
        }
    }

    private final void handleChange(UUID uuid, Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
        Vec3 pos;
        ParticleGroupStyle particleGroupStyle = ParticleStyleManager.INSTANCE.getClientViewStyles().get(uuid);
        if (particleGroupStyle == null) {
            return;
        }
        ParticleGroupStyle style = particleGroupStyle;
        if (args.containsKey("pos")) {
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("pos");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object obj = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type net.minecraft.world.phys.Vec3");
            pos = (Vec3)obj;
            style.teleportTo(pos);
        }
        if (args.containsKey("teleport")) {
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("teleport");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object obj = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type net.minecraft.world.phys.Vec3");
            pos = (Vec3)obj;
            style.teleportTo(pos);
        }
        if (args.containsKey("rotate_to") && args.containsKey("rotate_angle")) {
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("rotate_to");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object obj = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type cn.coostack.cooparticlesapi.utils.RelativeLocation");
            RelativeLocation relativeLocation = (RelativeLocation)obj;
            ParticleControlerDataBuffer<?> particleControlerDataBuffer2 = args.get("rotate_angle");
            Intrinsics.checkNotNull(particleControlerDataBuffer2);
            Object obj2 = particleControlerDataBuffer2.getLoadedValue();
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.Double");
            style.rotateToWithAngle(relativeLocation, (Double)obj2);
        } else {
            if (args.containsKey("rotate_angle")) {
                ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("rotate_angle");
                Intrinsics.checkNotNull(particleControlerDataBuffer);
                Object obj = particleControlerDataBuffer.getLoadedValue();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Double");
                style.rotateParticlesAsAxis((Double)obj);
            }
            if (args.containsKey("rotate_to")) {
                ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("rotate_to");
                Intrinsics.checkNotNull(particleControlerDataBuffer);
                Object obj = particleControlerDataBuffer.getLoadedValue();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type cn.coostack.cooparticlesapi.utils.RelativeLocation");
                style.rotateParticlesToPoint((RelativeLocation)obj);
            }
        }
        if (args.containsKey("axis")) {
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("axis");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object obj = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type net.minecraft.world.phys.Vec3");
            style.setAxis(RelativeLocation.Companion.of((Vec3)obj));
        }
        if (args.containsKey("scale")) {
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("scale");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object obj = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Double");
            style.setScale((Double)obj);
        }
        style.readPacketArgs(args);
    }

    private final void handleCreate(UUID uuid, Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
        ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("style_type");
        Intrinsics.checkNotNull(particleControlerDataBuffer);
        Object obj = particleControlerDataBuffer.getLoadedValue();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
        String clazz = (String)obj;
        Class<?> builderType = Class.forName(clazz);
        Intrinsics.checkNotNull(builderType, (String)"null cannot be cast to non-null type java.lang.Class<out cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle>");
        ParticleStyleProvider particleStyleProvider = ParticleStyleManager.INSTANCE.getBuilder(builderType);
        if (particleStyleProvider == null) {
            return;
        }
        ParticleStyleProvider builder = particleStyleProvider;
        ParticleGroupStyle style = builder.createStyle(uuid, args);
        ParticleControlerDataBuffer<?> particleControlerDataBuffer2 = args.get("pos");
        Intrinsics.checkNotNull(particleControlerDataBuffer2);
        Object obj2 = particleControlerDataBuffer2.getLoadedValue();
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type net.minecraft.world.phys.Vec3");
        Vec3 pos = (Vec3)obj2;
        ParticleControlerDataBuffer<?> particleControlerDataBuffer3 = args.get("rotate");
        Intrinsics.checkNotNull(particleControlerDataBuffer3);
        Object obj3 = particleControlerDataBuffer3.getLoadedValue();
        Intrinsics.checkNotNull(obj3, (String)"null cannot be cast to non-null type kotlin.Double");
        style.setRotate((Double)obj3);
        ParticleControlerDataBuffer<?> particleControlerDataBuffer4 = args.get("axis");
        Intrinsics.checkNotNull(particleControlerDataBuffer4);
        Object obj4 = particleControlerDataBuffer4.getLoadedValue();
        Intrinsics.checkNotNull(obj4, (String)"null cannot be cast to non-null type net.minecraft.world.phys.Vec3");
        style.setAxis(RelativeLocation.Companion.of((Vec3)obj4));
        ParticleControlerDataBuffer<?> particleControlerDataBuffer5 = args.get("scale");
        Intrinsics.checkNotNull(particleControlerDataBuffer5);
        Object obj5 = particleControlerDataBuffer5.getLoadedValue();
        Intrinsics.checkNotNull(obj5, (String)"null cannot be cast to non-null type kotlin.Double");
        style.setScale((Double)obj5);
        ClientLevel world = Minecraft.getInstance().level;
        style.readPacketArgs(args);
        ClientLevel clientLevel = world;
        Intrinsics.checkNotNull((Object)clientLevel);
        ParticleStyleManager.INSTANCE.spawnStyle((Level)clientLevel, pos, style);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ControlType.values().length];
            try {
                nArray[ControlType.CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControlType.CHANGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControlType.REMOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

