/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.particle;

import cn.coostack.cooparticlesapi.CooParticlesConstants;
import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffers;
import cn.coostack.cooparticlesapi.network.packet.PacketParticleGroupS2C;
import cn.coostack.cooparticlesapi.network.particle.ServerControler;
import cn.coostack.cooparticlesapi.network.particle.ServerParticleGroupManager;
import cn.coostack.cooparticlesapi.particles.control.ControlType;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroup;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010/\u001a\u00020;H&J\u001c\u0010<\u001a\u0016\u0012\u0004\u0012\u00020>\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020@0?0=H&J\u0012\u0010A\u001a\f\u0012\u0006\b\u0001\u0012\u00020C\u0018\u00010BH&J\u0018\u0010D\u001a\u00020;2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020;H\u0016J\b\u0010G\u001a\u00020;H\u0016J\u0006\u0010H\u001a\u00020;J\u0006\u0010I\u001a\u00020;J\u000e\u0010J\u001a\u00020;2\u0006\u0010K\u001a\u00020\u0003J\u000e\u0010,\u001a\u00020;2\u0006\u0010K\u001a\u00020\u0003J\u0006\u0010L\u001a\u00020;J\u000e\u0010M\u001a\u00020;2\u0006\u0010N\u001a\u00020OJ\u000e\u0010P\u001a\u00020;2\u0006\u0010Q\u001a\u00020RJ\u000e\u0010S\u001a\u00020;2\u0006\u00106\u001a\u00020\u000eJ\u000e\u0010T\u001a\u00020;2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010U\u001a\u00020;2\u0006\u0010V\u001a\u000205J\u000e\u0010W\u001a\u00020;2\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010X\u001a\u00020\u0000H\u0016J\b\u0010Y\u001a\u00020;H\u0016J\u0010\u0010Z\u001a\u00020;2\u0006\u0010V\u001a\u00020\u000eH\u0016J \u0010Z\u001a\u00020;2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020\u0003H\u0016J\u0010\u0010^\u001a\u00020;2\u0006\u0010_\u001a\u00020\u0003H\u0016J\u0018\u0010`\u001a\u00020;2\u0006\u0010V\u001a\u0002052\u0006\u0010_\u001a\u00020\u0003H\u0016J\u0010\u0010a\u001a\u00020;2\u0006\u0010V\u001a\u000205H\u0016J\u000e\u0010a\u001a\u00020;2\u0006\u0010V\u001a\u00020\u000eJ\u000e\u0010b\u001a\u00020;2\u0006\u0010/\u001a\u00020#J\u000e\u0010c\u001a\u00020;2\u0006\u0010/\u001a\u00020#J7\u0010d\u001a\u00020;2\u0017\u0010e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020;0f\u00a2\u0006\u0002\bg2\u0016\u0010h\u001a\u0012\u0012\u0004\u0012\u00020>\u0012\b\u0012\u0006\u0012\u0002\b\u00030?0=J \u0010i\u001a\u00020;2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u00102\u001a\u00020#R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0014@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u001a@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u001a@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR$\u0010$\u001a\u00020#2\u0006\u0010\r\u001a\u00020#@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010)\u001a\u00020#2\u0006\u0010\r\u001a\u00020#@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0007\"\u0004\b.\u0010\u0005R\u001a\u0010/\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010&\"\u0004\b1\u0010(R\u001a\u00102\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010&\"\u0004\b4\u0010(R$\u00106\u001a\u0002052\u0006\u0010\r\u001a\u000205@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006j"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/ServerParticleGroup;", "Lcn/coostack/cooparticlesapi/network/particle/ServerControler;", "visibleRange", "", "<init>", "(D)V", "getVisibleRange", "()D", "setVisibleRange", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "value", "Lnet/minecraft/world/phys/Vec3;", "pos", "getPos", "()Lnet/minecraft/world/phys/Vec3;", "setPos$cooparticlesapi_fabric_1_21_1", "(Lnet/minecraft/world/phys/Vec3;)V", "Lnet/minecraft/world/level/Level;", "world", "getWorld", "()Lnet/minecraft/world/level/Level;", "setWorld$cooparticlesapi_fabric_1_21_1", "(Lnet/minecraft/world/level/Level;)V", "", "valid", "getValid", "()Z", "setValid$cooparticlesapi_fabric_1_21_1", "(Z)V", "canceled", "getCanceled", "setCanceled$cooparticlesapi_fabric_1_21_1", "", "clientTick", "getClientTick", "()I", "setClientTick$cooparticlesapi_fabric_1_21_1", "(I)V", "clientMaxTick", "getClientMaxTick", "setClientMaxTick$cooparticlesapi_fabric_1_21_1", "scale", "getScale", "setScale", "tick", "getTick", "setTick", "maxTick", "getMaxTick", "setMaxTick", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "axis", "getAxis", "()Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "setAxis$cooparticlesapi_fabric_1_21_1", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)V", "", "otherPacketArgs", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "", "getClientType", "Ljava/lang/Class;", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup;", "onGroupDisplay", "Lnet/minecraft/server/level/ServerLevel;", "onTickAliveDeath", "onClientViewDeath", "doTickClient", "doTickAlive", "scaleOnServer", "new", "kill", "withPlayerStats", "player", "Lnet/minecraft/server/level/ServerPlayer;", "withEntityStats", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "setAxis", "setPosOnServer", "setRotateToOnServer", "to", "teleportGroupTo", "getValue", "remove", "teleportTo", "x", "y", "z", "rotateParticlesAsAxis", "angle", "rotateToWithAngle", "rotateParticlesToPoint", "changeTick", "changeMaxTick", "change", "toggleMethod", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "args", "initServerGroup", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nServerParticleGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerParticleGroup.kt\ncn/coostack/cooparticlesapi/network/particle/ServerParticleGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n1869#2,2:318\n1869#2,2:320\n*S KotlinDebug\n*F\n+ 1 ServerParticleGroup.kt\ncn/coostack/cooparticlesapi/network/particle/ServerParticleGroup\n*L\n152#1:318,2\n303#1:320,2\n*E\n"})
public abstract class ServerParticleGroup
implements ServerControler<ServerParticleGroup> {
    private double visibleRange;
    @NotNull
    private final UUID uuid;
    @NotNull
    private Vec3 pos;
    @Nullable
    private Level world;
    private boolean valid;
    private boolean canceled;
    private int clientTick;
    private int clientMaxTick;
    private double scale;
    private int tick;
    private int maxTick;
    @NotNull
    private RelativeLocation axis;

    public ServerParticleGroup(double visibleRange) {
        this.visibleRange = visibleRange;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.pos = vec3;
        this.valid = true;
        this.clientMaxTick = 120;
        this.scale = 1.0;
        this.maxTick = 120;
        this.axis = new RelativeLocation(0.0, 1.0, 0.0);
    }

    public /* synthetic */ ServerParticleGroup(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 32.0;
        }
        this(d);
    }

    public final double getVisibleRange() {
        return this.visibleRange;
    }

    public final void setVisibleRange(double d) {
        this.visibleRange = d;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final Vec3 getPos() {
        return this.pos;
    }

    public final void setPos$cooparticlesapi_fabric_1_21_1(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.pos = vec3;
    }

    @Nullable
    public final Level getWorld() {
        return this.world;
    }

    public final void setWorld$cooparticlesapi_fabric_1_21_1(@Nullable Level level) {
        this.world = level;
    }

    public final boolean getValid() {
        return this.valid;
    }

    public final void setValid$cooparticlesapi_fabric_1_21_1(boolean bl) {
        this.valid = bl;
    }

    public final boolean getCanceled() {
        return this.canceled;
    }

    public final void setCanceled$cooparticlesapi_fabric_1_21_1(boolean bl) {
        this.canceled = bl;
    }

    public final int getClientTick() {
        return this.clientTick;
    }

    public final void setClientTick$cooparticlesapi_fabric_1_21_1(int n) {
        this.clientTick = n;
    }

    public final int getClientMaxTick() {
        return this.clientMaxTick;
    }

    public final void setClientMaxTick$cooparticlesapi_fabric_1_21_1(int n) {
        this.clientMaxTick = n;
    }

    public final double getScale() {
        return this.scale;
    }

    public final void setScale(double d) {
        this.scale = d;
    }

    public final int getTick() {
        return this.tick;
    }

    public final void setTick(int n) {
        this.tick = n;
    }

    public final int getMaxTick() {
        return this.maxTick;
    }

    public final void setMaxTick(int n) {
        this.maxTick = n;
    }

    @NotNull
    public final RelativeLocation getAxis() {
        return this.axis;
    }

    public final void setAxis$cooparticlesapi_fabric_1_21_1(@NotNull RelativeLocation relativeLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"<set-?>");
        this.axis = relativeLocation;
    }

    public abstract void tick();

    @NotNull
    public abstract Map<String, ParticleControlerDataBuffer<? extends Object>> otherPacketArgs();

    @Nullable
    public abstract Class<? extends ControlableParticleGroup> getClientType();

    public void onGroupDisplay(@NotNull Vec3 pos, @NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
    }

    public void onTickAliveDeath() {
    }

    public void onClientViewDeath() {
    }

    public final void doTickClient() {
        int n = this.clientTick;
        this.clientTick = n + 1;
        if (n >= this.clientMaxTick) {
            this.onClientViewDeath();
        }
    }

    public final void doTickAlive() {
        int n = this.tick;
        this.tick = n + 1;
        if (n >= this.maxTick) {
            this.kill();
            this.onTickAliveDeath();
        }
    }

    public final void scaleOnServer(double d) {
        if (d < 0.0) {
            CooParticlesConstants.logger.error("scale must be greater than zero.");
            return;
        }
        this.scale = d;
    }

    public final void scale(double d) {
        if (d < 0.0) {
            CooParticlesConstants.logger.error("scale must be greater than zero.");
            return;
        }
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)arg_0 -> ServerParticleGroup.scale$lambda$0(d, arg_0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.SCALE.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.double(d))));
    }

    public final void kill() {
        this.canceled = true;
        if (this.world == null) {
            return;
        }
        Set<UUID> visible = ServerParticleGroupManager.INSTANCE.filterVisiblePlayer(this);
        Iterable $this$forEach$iv = visible;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Level level = this.world;
            Intrinsics.checkNotNull((Object)level);
            if (level.getPlayerByUUID(it) == null) continue;
            PacketParticleGroupS2C packet = new PacketParticleGroupS2C(this.uuid, ControlType.REMOVE, MapsKt.emptyMap());
            CustomPacketPayload customPacketPayload = packet;
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            CooParticlesServices.SERVER_NETWORK.send(customPacketPayload, (ServerPlayer)player);
        }
    }

    public final void withPlayerStats(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.hasDisconnected()) {
            this.kill();
        }
        if (!Intrinsics.areEqual((Object)player.level(), (Object)this.world)) {
            this.kill();
        }
    }

    public final void withEntityStats(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.isDeadOrDying()) {
            this.kill();
        }
        if (!Intrinsics.areEqual((Object)entity.level(), (Object)this.world)) {
            this.kill();
        }
    }

    public final void setAxis(@NotNull Vec3 axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)arg_0 -> ServerParticleGroup.setAxis$lambda$2(axis, arg_0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.AXIS.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.vec3d(axis))));
    }

    public final void setPosOnServer(@NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.pos = pos;
    }

    public final void setRotateToOnServer(@NotNull RelativeLocation to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.axis = to.normalize();
    }

    public final void teleportGroupTo(@NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)arg_0 -> ServerParticleGroup.teleportGroupTo$lambda$3(pos, arg_0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.POS.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.vec3d(pos))));
    }

    @Override
    @NotNull
    public ServerParticleGroup getValue() {
        return this;
    }

    @Override
    public void remove() {
        this.kill();
    }

    @Override
    public void teleportTo(@NotNull Vec3 to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.teleportGroupTo(to);
    }

    @Override
    public void teleportTo(double x, double y, double z) {
        this.teleportTo(new Vec3(x, y, z));
    }

    @Override
    public void rotateParticlesAsAxis(double angle) {
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)ServerParticleGroup::rotateParticlesAsAxis$lambda$4), MapsKt.mapOf((Pair)TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.ROTATE_AXIS.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.double(angle))));
    }

    @Override
    public void rotateToWithAngle(@NotNull RelativeLocation to, double angle) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.ROTATE_AXIS.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.double(angle)), TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.ROTATE_TO.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.vec3d(to.toVector()))};
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)ServerParticleGroup::rotateToWithAngle$lambda$5), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    public void rotateParticlesToPoint(@NotNull RelativeLocation to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.rotateParticlesToPoint(to.toVector());
    }

    public final void rotateParticlesToPoint(@NotNull Vec3 to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)ServerParticleGroup::rotateParticlesToPoint$lambda$6), MapsKt.mapOf((Pair)TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.ROTATE_TO.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.vec3d(to))));
    }

    public final void changeTick(int tick) {
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)arg_0 -> ServerParticleGroup.changeTick$lambda$7(tick, arg_0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.CURRENT_TICK.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.int(tick))));
    }

    public final void changeMaxTick(int tick) {
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)arg_0 -> ServerParticleGroup.changeMaxTick$lambda$8(tick, arg_0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.MAX_TICK.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.int(tick))));
    }

    public final void change(@NotNull Function1<? super ServerParticleGroup, Unit> toggleMethod, @NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
        Intrinsics.checkNotNullParameter(toggleMethod, (String)"toggleMethod");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (this.world == null) {
            return;
        }
        Set<UUID> visible = ServerParticleGroupManager.INSTANCE.filterVisiblePlayer(this);
        toggleMethod.invoke((Object)this);
        Iterable $this$forEach$iv = visible;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Level level = this.world;
            Intrinsics.checkNotNull((Object)level);
            if (level.getPlayerByUUID(it) == null) continue;
            PacketParticleGroupS2C packet = new PacketParticleGroupS2C(this.uuid, ControlType.CHANGE, args);
            CustomPacketPayload customPacketPayload = packet;
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            CooParticlesServices.SERVER_NETWORK.send(customPacketPayload, (ServerPlayer)player);
        }
    }

    public final void initServerGroup(@NotNull Vec3 pos, @NotNull Level world, int maxTick) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.pos = pos;
        this.world = world;
        this.clientMaxTick = maxTick;
    }

    public static /* synthetic */ void initServerGroup$default(ServerParticleGroup serverParticleGroup, Vec3 vec3, Level level, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initServerGroup");
        }
        if ((n2 & 4) != 0) {
            n = 120;
        }
        serverParticleGroup.initServerGroup(vec3, level, n);
    }

    private static final Unit scale$lambda$0(double $new, ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        $this$change.scale = $new;
        return Unit.INSTANCE;
    }

    private static final Unit setAxis$lambda$2(Vec3 $axis, ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        $this$change.axis = RelativeLocation.Companion.of($axis);
        return Unit.INSTANCE;
    }

    private static final Unit teleportGroupTo$lambda$3(Vec3 $pos, ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        $this$change.pos = $pos;
        return Unit.INSTANCE;
    }

    private static final Unit rotateParticlesAsAxis$lambda$4(ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        return Unit.INSTANCE;
    }

    private static final Unit rotateToWithAngle$lambda$5(ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        return Unit.INSTANCE;
    }

    private static final Unit rotateParticlesToPoint$lambda$6(ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        return Unit.INSTANCE;
    }

    private static final Unit changeTick$lambda$7(int $tick, ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        $this$change.clientTick = $tick;
        return Unit.INSTANCE;
    }

    private static final Unit changeMaxTick$lambda$8(int $tick, ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        $this$change.maxTick = $tick;
        return Unit.INSTANCE;
    }

    public ServerParticleGroup() {
        this(0.0, 1, null);
    }
}

