/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.particle.emitters.impl;

import cn.coostack.cooparticlesapi.network.particle.emitters.ClassParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.GlobalWindDirection;
import cn.coostack.cooparticlesapi.particles.ControlableParticle;
import cn.coostack.cooparticlesapi.particles.control.ParticleControler;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020!0 H\u0016J(\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0014\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010/H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00063"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/impl/FireClassParticleEmitters;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters;", "player", "Ljava/util/UUID;", "pos", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Ljava/util/UUID;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;)V", "getPlayer", "()Ljava/util/UUID;", "setPlayer", "(Ljava/util/UUID;)V", "templateData", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "getTemplateData", "()Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "setTemplateData", "(Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;)V", "fireSize", "", "getFireSize", "()D", "setFireSize", "(D)V", "fireForce", "getFireForce", "setFireForce", "doTick", "", "genParticles", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "random", "Lkotlin/random/Random;", "getRandom", "()Lkotlin/random/Random;", "singleParticleAction", "controler", "Lcn/coostack/cooparticlesapi/particles/control/ParticleControler;", "data", "spawnPos", "spawnWorld", "getEmittersID", "", "getCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmitters;", "Companion", "cooparticlesapi-fabric-1.21.1"})
public final class FireClassParticleEmitters
extends ClassParticleEmitters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private UUID player;
    @NotNull
    private ControlableParticleData templateData;
    private double fireSize;
    private double fireForce;
    @NotNull
    private final Random random;
    @NotNull
    public static final String ID = "fire-class-particle-emitters";
    private static final StreamCodec<FriendlyByteBuf, ParticleEmitters> CODEC = StreamCodec.of(FireClassParticleEmitters::CODEC$lambda$3, FireClassParticleEmitters::CODEC$lambda$4);

    public FireClassParticleEmitters(@NotNull UUID player, @NotNull Vec3 pos, @Nullable Level world) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(pos, world);
        this.player = player;
        this.templateData = new ControlableParticleData();
        this.fireSize = 0.5;
        this.fireForce = 0.6;
        this.setAirDensity(1.225);
        this.setWind(new GlobalWindDirection(new Vec3(0.0, this.fireForce * (double)30, 0.0)).loadEmitters(this));
        this.random = RandomKt.Random((long)System.currentTimeMillis());
    }

    @NotNull
    public final UUID getPlayer() {
        return this.player;
    }

    public final void setPlayer(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.player = uUID;
    }

    @NotNull
    public final ControlableParticleData getTemplateData() {
        return this.templateData;
    }

    public final void setTemplateData(@NotNull ControlableParticleData controlableParticleData) {
        Intrinsics.checkNotNullParameter((Object)controlableParticleData, (String)"<set-?>");
        this.templateData = controlableParticleData;
    }

    public final double getFireSize() {
        return this.fireSize;
    }

    public final void setFireSize(double d) {
        this.fireSize = d;
    }

    public final double getFireForce() {
        return this.fireForce;
    }

    public final void setFireForce(double d) {
        this.fireForce = d;
    }

    @Override
    public void doTick() {
    }

    @Override
    @NotNull
    public Map<ControlableParticleData, RelativeLocation> genParticles() {
        double step;
        List<RelativeLocation> velocityList = new PointsBuilder().addRoundShape(this.fireSize, 0.25, 10, MathKt.roundToInt((double)((double)120 * this.fireSize))).rotateTo(new Vec3(0.0, 0.0, 1.0)).pointsOnEach((Function1<? super RelativeLocation, Unit>)((Function1)FireClassParticleEmitters::genParticles$lambda$0)).create();
        HashMap res = new HashMap();
        Random random = RandomKt.Random((long)System.currentTimeMillis());
        double current = step = 1.0;
        for (int i = 0; i < 60; ++i) {
            ControlableParticleData controlableParticleData;
            RelativeLocation it = (RelativeLocation)CollectionsKt.random((Collection)velocityList, (Random)((Random)Random.Default));
            Map map = res;
            ControlableParticleData $this$genParticles_u24lambda_u241 = controlableParticleData = this.templateData.clone();
            boolean bl = false;
            $this$genParticles_u24lambda_u241.setVelocity(it.normalize().multiply(this.fireForce).toVector());
            RelativeLocation relativeLocation = new RelativeLocation(0.0, current, 0.0);
            map.put(controlableParticleData, relativeLocation);
        }
        return res;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @Override
    public void singleParticleAction(@NotNull ParticleControler controler, @NotNull ControlableParticleData data, @NotNull Vec3 spawnPos, @NotNull Level spawnWorld) {
        Intrinsics.checkNotNullParameter((Object)controler, (String)"controler");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)spawnPos, (String)"spawnPos");
        Intrinsics.checkNotNullParameter((Object)spawnWorld, (String)"spawnWorld");
        Vec3 vec3 = data.getVelocity().add(new Vec3(this.random.nextDouble(-this.fireForce * (double)10, this.fireForce * (double)10), this.random.nextDouble(-10.0, 10.0), this.random.nextDouble(-this.fireForce * (double)10, this.fireForce * (double)10)).normalize().scale(0.125));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        data.setVelocity(vec3);
        data.setColor(Math3DUtil.INSTANCE.colorOf(this.random.nextInt(240, 255), this.random.nextInt(160, 180), this.random.nextInt(40, 80)));
        List<RelativeLocation> alphaBezier = Math3DUtil.INSTANCE.generateBezierCurve(new RelativeLocation((double)data.getMaxAge(), 0.0, 0.0), new RelativeLocation(0.0, 1.0, 0.0), new RelativeLocation(-((double)data.getMaxAge()), 1.0, 0.0), data.getMaxAge());
        int size = alphaBezier.size();
        double maxY = this.random.nextDouble(0.6, 0.8);
        controler.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> FireClassParticleEmitters.singleParticleAction$lambda$2(data, maxY, arg_0)));
    }

    @Override
    @NotNull
    public String getEmittersID() {
        return ID;
    }

    @Override
    @NotNull
    public StreamCodec<FriendlyByteBuf, ParticleEmitters> getCodec() {
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec = CODEC;
        Intrinsics.checkNotNullExpressionValue(streamCodec, (String)"CODEC");
        return streamCodec;
    }

    private static final Unit genParticles$lambda$0(RelativeLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setY(it.getY() + 6.0);
        return Unit.INSTANCE;
    }

    private static final Unit singleParticleAction$lambda$2(ControlableParticleData $data, double $maxY, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        Vec3 vec3 = $data.getVelocity().add(0.0, 0.05, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        $data.setVelocity(vec3);
        if ($data.getVelocity().y >= $maxY) {
            $data.setVelocity(new Vec3($data.getVelocity().x, $maxY, $data.getVelocity().z));
        }
        $this$addPreTickAction.setSize(0.3f);
        $this$addPreTickAction.colorOfRGB(MathKt.roundToInt((float)RangesKt.coerceIn((float)($this$addPreTickAction.getColor().x * (float)255), (float)0.0f, (float)255.0f)), MathKt.roundToInt((float)RangesKt.coerceIn((float)($this$addPreTickAction.getColor().y * (float)255 - (float)($this$addPreTickAction.getCurrentAge() * 1)), (float)0.0f, (float)255.0f)), MathKt.roundToInt((float)RangesKt.coerceIn((float)($this$addPreTickAction.getColor().z * (float)255 - (float)($this$addPreTickAction.getCurrentAge() * 1)), (float)0.0f, (float)255.0f)));
        return Unit.INSTANCE;
    }

    private static final void CODEC$lambda$3(FriendlyByteBuf buf, ParticleEmitters data) {
        Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type cn.coostack.cooparticlesapi.network.particle.emitters.impl.FireClassParticleEmitters");
        FireClassParticleEmitters cfr_ignored_0 = (FireClassParticleEmitters)data;
        buf.writeUUID(((FireClassParticleEmitters)data).player);
        ClassParticleEmitters classParticleEmitters = (ClassParticleEmitters)data;
        Intrinsics.checkNotNull((Object)buf);
        ClassParticleEmitters.Companion.encodeBase(classParticleEmitters, buf);
        buf.writeDouble(((FireClassParticleEmitters)data).fireSize);
        buf.writeDouble(((FireClassParticleEmitters)data).fireForce);
        ControlableParticleData.Companion.getPACKET_CODEC().encode((Object)buf, (Object)((FireClassParticleEmitters)data).templateData);
    }

    private static final ParticleEmitters CODEC$lambda$4(FriendlyByteBuf it) {
        UUID player = it.readUUID();
        Intrinsics.checkNotNull((Object)player);
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        FireClassParticleEmitters instance = new FireClassParticleEmitters(player, vec3, null);
        ClassParticleEmitters classParticleEmitters = instance;
        Intrinsics.checkNotNull((Object)it);
        ClassParticleEmitters.Companion.decodeBase(classParticleEmitters, it);
        instance.fireSize = it.readDouble();
        instance.fireForce = it.readDouble();
        Object object = ControlableParticleData.Companion.getPACKET_CODEC().decode((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decode(...)");
        instance.templateData = (ControlableParticleData)object;
        return instance;
    }

    public static final StreamCodec<FriendlyByteBuf, ParticleEmitters> getCODEC() {
        return Companion.getCODEC();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\\\u0010\u0006\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n\u0018\u00010\u00070\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/impl/FireClassParticleEmitters$Companion;", "", "<init>", "()V", "ID", "", "CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "kotlin.jvm.PlatformType", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmitters;", "getCODEC$annotations", "getCODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "cooparticlesapi-fabric-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final StreamCodec<FriendlyByteBuf, ParticleEmitters> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCODEC$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

