/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.client;

import cn.coostack.cooparticlesapi.renderer.RenderEntity;
import cn.coostack.cooparticlesapi.renderer.client.ClientRenderPipelineManager;
import cn.coostack.cooparticlesapi.renderer.client.RenderUtil;
import cn.coostack.cooparticlesapi.renderer.client.ShaderPipeManagers;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.ShaderPipeManager;
import com.mojang.blaze3d.platform.Window;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u000e2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0013J\u001c\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u000eJ\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eJ\u001e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u0006\u0010)\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\r\u001a>\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\u000fj\b\u0012\u0004\u0012\u00020\u000b`\u00100\tj\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\u000fj\b\u0012\u0004\u0012\u00020\u000b`\u0010`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\tj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0012\u001a6\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u00130\tj\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0013`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcn/coostack/cooparticlesapi/renderer/client/ClientRenderEntityManager;", "", "<init>", "()V", "minecraft", "Lnet/minecraft/client/Minecraft;", "getMinecraft", "()Lnet/minecraft/client/Minecraft;", "entities", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "Lkotlin/collections/HashMap;", "entitiesPipeClassifier", "Lnet/minecraft/resources/ResourceLocation;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "entityPipeType", "entityCodecs", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "getFrom", "uuid", "register", "", "entity", "bindEntityRenderPipe", "type", "pipeID", "id", "codec", "getCodecFromID", "clear", "add", "getPipeIDFromType", "renderTick", "tickDelta", "", "viewMatrix", "Lorg/joml/Matrix4f;", "projMatrix", "tick", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nClientRenderEntityManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientRenderEntityManager.kt\ncn/coostack/cooparticlesapi/renderer/client/ClientRenderEntityManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n640#2:103\n640#2:105\n216#2,2:114\n1#3:104\n1#3:106\n382#4,7:107\n1869#5,2:116\n*S KotlinDebug\n*F\n+ 1 ClientRenderEntityManager.kt\ncn/coostack/cooparticlesapi/renderer/client/ClientRenderEntityManager\n*L\n46#1:103\n49#1:105\n74#1:114,2\n46#1:104\n49#1:106\n60#1:107,7\n79#1:116,2\n*E\n"})
public final class ClientRenderEntityManager {
    @NotNull
    public static final ClientRenderEntityManager INSTANCE = new ClientRenderEntityManager();
    @NotNull
    private static final Minecraft minecraft;
    @NotNull
    private static final HashMap<UUID, RenderEntity> entities;
    @NotNull
    private static final HashMap<ResourceLocation, HashSet<RenderEntity>> entitiesPipeClassifier;
    @NotNull
    private static final HashMap<ResourceLocation, ResourceLocation> entityPipeType;
    @NotNull
    private static final HashMap<ResourceLocation, StreamCodec<FriendlyByteBuf, RenderEntity>> entityCodecs;

    private ClientRenderEntityManager() {
    }

    @NotNull
    public final Minecraft getMinecraft() {
        return minecraft;
    }

    @Nullable
    public final RenderEntity getFrom(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return entities.get(uuid);
    }

    public final void register(@NotNull RenderEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ((Map)entityCodecs).put(entity.getRenderID(), entity.getCodec());
    }

    public final void bindEntityRenderPipe(@NotNull ResourceLocation type, @NotNull ResourceLocation pipeID) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pipeID, (String)"pipeID");
        ((Map)entityPipeType).put(type, pipeID);
    }

    public final void register(@NotNull ResourceLocation id, @NotNull StreamCodec<FriendlyByteBuf, RenderEntity> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        ((Map)entityCodecs).put(id, codec);
    }

    @Nullable
    public final StreamCodec<FriendlyByteBuf, RenderEntity> getCodecFromID(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return entityCodecs.get(id);
    }

    public final void clear() {
        Map.Entry it;
        Map.Entry element$iv;
        Map map;
        Map $this$onEach$iv = entities;
        boolean $i$f$onEach = false;
        Map $this$onEach_u24lambda_u242$iv = map = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl2 = false;
            ((RenderEntity)it.getValue()).release();
        }
        ((HashMap)map).clear();
        $this$onEach$iv = entitiesPipeClassifier;
        $i$f$onEach = false;
        $this$onEach_u24lambda_u242$iv = map = $this$onEach$iv;
        bl = false;
        iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            it = element$iv = iterator.next();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(((HashSet)it.getValue()).iterator(), (String)"iterator(...)");
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                RenderEntity entity = (RenderEntity)e;
                entity.release();
            }
        }
        ((HashMap)map).clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull RenderEntity entity) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.init$cooparticlesapi_fabric_1_21_1();
        ((Map)entities).put(entity.getUuid(), entity);
        ResourceLocation pipe = this.getPipeIDFromType(entity.getRenderID());
        Map map = entitiesPipeClassifier;
        ResourceLocation key$iv = pipe;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashSet answer$iv = new HashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((HashSet)object).add(entity);
    }

    @NotNull
    public final ResourceLocation getPipeIDFromType(@NotNull ResourceLocation type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ResourceLocation resourceLocation = entityPipeType.get(type);
        if (resourceLocation == null) {
            resourceLocation = ShaderPipeManagers.INSTANCE.getDefault().getPipeID();
        }
        return resourceLocation;
    }

    public final void renderTick(float tickDelta, @NotNull Matrix4f viewMatrix, @NotNull Matrix4f projMatrix) {
        Intrinsics.checkNotNullParameter((Object)viewMatrix, (String)"viewMatrix");
        Intrinsics.checkNotNullParameter((Object)projMatrix, (String)"projMatrix");
        Window window = minecraft.getWindow();
        if (window.getScreenWidth() != ClientRenderEntityManager.minecraft.getMainRenderTarget().viewWidth || window.getScreenHeight() != ClientRenderEntityManager.minecraft.getMainRenderTarget().viewHeight) {
            return;
        }
        Matrix4fStack stack = new Matrix4fStack(16);
        Map $this$forEach$iv = entitiesPipeClassifier;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ShaderPipeManager pipe;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation pipeID = (ResourceLocation)it.getKey();
            HashSet entities = (HashSet)it.getValue();
            Intrinsics.checkNotNull((Object)ClientRenderPipelineManager.INSTANCE.getPipeManager(pipeID));
            pipe.writeFrame(() -> ClientRenderEntityManager.renderTick$lambda$5$lambda$4(entities, stack, tickDelta, viewMatrix, projMatrix));
            pipe.render();
        }
    }

    public final void tick() {
        Iterator iterator = ((Map)entities).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RenderEntity entity = (RenderEntity)entry.getValue();
            entity.tick();
            if (!entity.getCanceled()) continue;
            entity.release();
            iterator.remove();
        }
    }

    private static final void renderTick$lambda$5$lambda$4(HashSet $entities, Matrix4fStack $stack, float $tickDelta, Matrix4f $viewMatrix, Matrix4f $projMatrix) {
        Iterable $this$forEach$iv = $entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderEntity entity = (RenderEntity)element$iv;
            boolean bl = false;
            $stack.pushMatrix();
            RenderUtil.setRenderStackWithEntity($stack, entity, $tickDelta);
            entity.renderOnWorld($stack, $viewMatrix, $projMatrix, $tickDelta);
            $stack.popMatrix();
        }
    }

    static {
        Minecraft minecraft = Minecraft.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance(...)");
        ClientRenderEntityManager.minecraft = minecraft;
        entities = new HashMap();
        entitiesPipeClassifier = new HashMap();
        entityPipeType = new HashMap();
        entityCodecs = new HashMap();
    }
}

