/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader;

import cn.coostack.cooparticlesapi.renderer.shader.api.CooShaderProgram;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix2f;
import org.joml.Matrix3f;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Matrix4x3f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL33;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J!\u0010\u0019\u001a\u00020\u00152\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00150\u001b\u00a2\u0006\u0002\b\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/SimpleShaderProgram;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "vertexShader", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "fragmentShader", "<init>", "(Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;)V", "getVertexShader", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "setVertexShader", "(Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;)V", "getFragmentShader", "setFragmentShader", "program", "", "getProgram", "()I", "setProgram", "(I)V", "prevProgram", "init", "", "use", "reset", "release", "useOnContext", "drawMethod", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "assertProgram", "cooparticlesapi-fabric-1.21.1"})
public final class SimpleShaderProgram
implements CooShaderProgram {
    @NotNull
    private GlShader vertexShader;
    @NotNull
    private GlShader fragmentShader;
    private int program;
    private int prevProgram;

    public SimpleShaderProgram(@NotNull GlShader vertexShader, @NotNull GlShader fragmentShader) {
        Intrinsics.checkNotNullParameter((Object)vertexShader, (String)"vertexShader");
        Intrinsics.checkNotNullParameter((Object)fragmentShader, (String)"fragmentShader");
        this.vertexShader = vertexShader;
        this.fragmentShader = fragmentShader;
    }

    @Override
    @NotNull
    public GlShader getVertexShader() {
        return this.vertexShader;
    }

    @Override
    public void setVertexShader(@NotNull GlShader glShader) {
        Intrinsics.checkNotNullParameter((Object)glShader, (String)"<set-?>");
        this.vertexShader = glShader;
    }

    @Override
    @NotNull
    public GlShader getFragmentShader() {
        return this.fragmentShader;
    }

    @Override
    public void setFragmentShader(@NotNull GlShader glShader) {
        Intrinsics.checkNotNullParameter((Object)glShader, (String)"<set-?>");
        this.fragmentShader = glShader;
    }

    @Override
    public int getProgram() {
        return this.program;
    }

    @Override
    public void setProgram(int n) {
        this.program = n;
    }

    @Override
    public void init() {
        this.setProgram(GL33.glCreateProgram());
        this.getVertexShader().compile();
        this.getFragmentShader().compile();
        GL33.glAttachShader((int)this.getProgram(), (int)this.getVertexShader().shaderID());
        GL33.glAttachShader((int)this.getProgram(), (int)this.getFragmentShader().shaderID());
        GL33.glLinkProgram((int)this.getProgram());
        this.assertProgram();
        this.getVertexShader().deleteShader();
        this.getFragmentShader().deleteShader();
    }

    @Override
    public void use() {
        this.prevProgram = GL33.glGetInteger((int)35725);
        GL33.glUseProgram((int)this.getProgram());
    }

    @Override
    public void reset() {
        GL33.glUseProgram((int)this.prevProgram);
    }

    @Override
    public void release() {
        if (this.getProgram() > 0) {
            GL33.glDeleteProgram((int)this.getProgram());
        }
    }

    @Override
    public void useOnContext(@NotNull Function1<? super CooShaderProgram, Unit> drawMethod) {
        Intrinsics.checkNotNullParameter(drawMethod, (String)"drawMethod");
        this.use();
        drawMethod.invoke((Object)this);
        this.reset();
    }

    private final void assertProgram() {
        if (!(GL33.glGetProgrami((int)this.getProgram(), (int)35714) != 0)) {
            boolean bl = false;
            String string = "program " + this.getProgram() + " link error: " + GL33.glGetProgramInfoLog((int)this.getProgram());
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void setInt(@NotNull String key, int value) {
        CooShaderProgram.super.setInt(key, value);
    }

    @Override
    public void setBoolean(@NotNull String key, boolean value) {
        CooShaderProgram.super.setBoolean(key, value);
    }

    @Override
    public void setFloat(@NotNull String key, float value) {
        CooShaderProgram.super.setFloat(key, value);
    }

    @Override
    public void setFloat2(@NotNull String key, @NotNull Vector2f value) {
        CooShaderProgram.super.setFloat2(key, value);
    }

    @Override
    public void setFloat3(@NotNull String key, @NotNull Vector3f value) {
        CooShaderProgram.super.setFloat3(key, value);
    }

    @Override
    public void setFloat4(@NotNull String key, @NotNull Vector4f value) {
        CooShaderProgram.super.setFloat4(key, value);
    }

    @Override
    public void setMatrix4(@NotNull String key, @NotNull Matrix4f value) {
        CooShaderProgram.super.setMatrix4(key, value);
    }

    @Override
    public void setMatrix4x3(@NotNull String key, @NotNull Matrix4x3f value) {
        CooShaderProgram.super.setMatrix4x3(key, value);
    }

    @Override
    public void setMatrix3x2(@NotNull String key, @NotNull Matrix3x2f value) {
        CooShaderProgram.super.setMatrix3x2(key, value);
    }

    @Override
    public void setMatrix3f(@NotNull String key, @NotNull Matrix3f value) {
        CooShaderProgram.super.setMatrix3f(key, value);
    }

    @Override
    public void setMatrix2f(@NotNull String key, @NotNull Matrix2f value) {
        CooShaderProgram.super.setMatrix2f(key, value);
    }
}

