/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.glsl;

import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShaderType;
import cn.coostack.cooparticlesapi.renderer.shader.utils.GlslUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL33;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/glsl/FileShader;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "path", "", "type", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShaderType;", "<init>", "(Ljava/lang/String;Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShaderType;)V", "getPath", "()Ljava/lang/String;", "getType", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShaderType;", "shaderID", "", "compile", "", "assertCompiled", "deleteShader", "readFromJar", "cooparticlesapi-fabric-1.21.1"})
public final class FileShader
implements GlShader {
    @NotNull
    private final String path;
    @NotNull
    private final GlShaderType type;
    private int shaderID;

    public FileShader(@NotNull String path, @NotNull GlShaderType type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.path = path;
        this.type = type;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public GlShaderType getType() {
        return this.type;
    }

    @Override
    public int shaderID() {
        return this.shaderID;
    }

    @Override
    public void compile() {
        this.shaderID = GL33.glCreateShader((int)this.getType().getGl());
        GL33.glShaderSource((int)this.shaderID, (CharSequence)this.readFromJar());
        GL33.glCompileShader((int)this.shaderID);
        this.assertCompiled();
    }

    @Override
    public void assertCompiled() {
        boolean bl;
        boolean bl2 = bl = GL33.glGetShaderi((int)this.shaderID, (int)35713) != 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "compile code failed info:" + GL33.glGetShaderInfoLog((int)this.shaderID);
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public void deleteShader() {
        GL33.glDeleteShader((int)this.shaderID);
    }

    private final String readFromJar() {
        return GlslUtil.INSTANCE.readGlslCodeFromJar(this.path);
    }
}

