/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.glsl;

import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlFrameBuffer;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL33;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000fH\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J!\u0010\"\u001a\u00020\u001c2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001c0$\u00a2\u0006\u0002\b%H\u0016J!\u0010&\u001a\u00020\u001c2\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001c0$\u00a2\u0006\u0002\b%H\u0016J\b\u0010(\u001a\u00020\u001cH\u0016J\b\u0010)\u001a\u00020\u001cH\u0016J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u000fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/glsl/MinecraftHookFrameBuffer;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlFrameBuffer;", "mcFrame", "Lcom/mojang/blaze3d/pipeline/RenderTarget;", "<init>", "(Lcom/mojang/blaze3d/pipeline/RenderTarget;)V", "getMcFrame", "()Lcom/mojang/blaze3d/pipeline/RenderTarget;", "setMcFrame", "colorAttachments", "", "getColorAttachments", "()[I", "depthSupplier", "Ljava/util/function/Supplier;", "", "getDepthSupplier", "()Ljava/util/function/Supplier;", "setDepthSupplier", "(Ljava/util/function/Supplier;)V", "getCurrentDepthAttachment", "width", "height", "prevFBO", "initialized", "", "fbo", "init", "", "clear", "setTextureFilterMod", "mod", "bit", "bindFramebuffer", "writeFrameBufferWith", "writeScope", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "readFrameBufferWith", "readScope", "reset", "release", "bindTextureTo", "textureID", "fc", "Ljava/lang/Runnable;", "resize", "copyDepthBuffer", "srcFBO", "cooparticlesapi-fabric-1.21.1"})
public class MinecraftHookFrameBuffer
implements GlFrameBuffer {
    @NotNull
    private RenderTarget mcFrame;
    @NotNull
    private final int[] colorAttachments;
    @NotNull
    private Supplier<Integer> depthSupplier;
    private int prevFBO;
    private boolean initialized;

    public MinecraftHookFrameBuffer(@NotNull RenderTarget mcFrame) {
        Intrinsics.checkNotNullParameter((Object)mcFrame, (String)"mcFrame");
        this.mcFrame = mcFrame;
        this.colorAttachments = new int[1];
        this.depthSupplier = () -> MinecraftHookFrameBuffer.depthSupplier$lambda$0(this);
    }

    @NotNull
    public final RenderTarget getMcFrame() {
        return this.mcFrame;
    }

    public final void setMcFrame(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkNotNullParameter((Object)renderTarget, (String)"<set-?>");
        this.mcFrame = renderTarget;
    }

    @Override
    @NotNull
    public int[] getColorAttachments() {
        return this.colorAttachments;
    }

    @Override
    @NotNull
    public Supplier<Integer> getDepthSupplier() {
        return this.depthSupplier;
    }

    @Override
    public void setDepthSupplier(@NotNull Supplier<Integer> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.depthSupplier = supplier;
    }

    @Override
    public int getCurrentDepthAttachment() {
        Integer n = this.getDepthSupplier().get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        return ((Number)n).intValue();
    }

    @Override
    public int width() {
        return this.mcFrame.width;
    }

    @Override
    public int height() {
        return this.mcFrame.height;
    }

    @Override
    public int fbo() {
        return this.mcFrame.frameBufferId;
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.getColorAttachments()[0] = this.mcFrame.getColorTextureId();
    }

    @Override
    public void clear() {
        this.clear(16640);
    }

    @Override
    public void setTextureFilterMod(int mod) {
    }

    @Override
    public void clear(int bit) {
        GL33.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL33.glClear((int)bit);
    }

    @Override
    public void bindFramebuffer() {
        this.prevFBO = GL33.glGetInteger((int)36006);
        GL33.glBindFramebuffer((int)36160, (int)this.fbo());
    }

    @Override
    public void writeFrameBufferWith(@NotNull Function1<? super GlFrameBuffer, Unit> writeScope) {
        Intrinsics.checkNotNullParameter(writeScope, (String)"writeScope");
        this.mcFrame.bindWrite(true);
        writeScope.invoke((Object)this);
        this.mcFrame.unbindWrite();
    }

    @Override
    public void readFrameBufferWith(@NotNull Function1<? super GlFrameBuffer, Unit> readScope) {
        Intrinsics.checkNotNullParameter(readScope, (String)"readScope");
        this.mcFrame.bindRead();
        readScope.invoke((Object)this);
        this.mcFrame.unbindRead();
    }

    @Override
    public void reset() {
        GL33.glBindFramebuffer((int)36160, (int)this.prevFBO);
    }

    @Override
    public void release() {
        if (!this.initialized) {
            return;
        }
    }

    private final void bindTextureTo(int textureID, Runnable fc) {
        int prev = GL33.glGetInteger((int)32873);
        GL33.glBindTexture((int)3553, (int)textureID);
        fc.run();
        GL33.glBindTexture((int)3553, (int)prev);
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void copyDepthBuffer(int srcFBO) {
    }

    private static final Integer depthSupplier$lambda$0(MinecraftHookFrameBuffer this$0) {
        return this$0.mcFrame.getDepthTextureId();
    }
}

