/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.glsl;

import cn.coostack.cooparticlesapi.CooParticlesConstants;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlFrameBuffer;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.Arrays;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL33;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\u001dH\u0016J!\u0010#\u001a\u00020\u001d2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001d0%\u00a2\u0006\u0002\b&H\u0016J!\u0010'\u001a\u00020\u001d2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001d0%\u00a2\u0006\u0002\b&H\u0016J\b\u0010)\u001a\u00020\u001dH\u0016J\b\u0010*\u001a\u00020\u001dH\u0016J\b\u0010+\u001a\u00020\u001dH\u0002J\b\u0010,\u001a\u00020\u001dH\u0002J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/glsl/SimpleFrameBuffer;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlFrameBuffer;", "colorChannelCount", "", "depthSupplier", "Ljava/util/function/Supplier;", "<init>", "(ILjava/util/function/Supplier;)V", "getColorChannelCount", "()I", "getDepthSupplier", "()Ljava/util/function/Supplier;", "setDepthSupplier", "(Ljava/util/function/Supplier;)V", "colorAttachments", "", "getColorAttachments", "()[I", "depthAttachment", "fbo", "prevFBO", "initialized", "", "newDepth", "textureFilterMod", "width", "height", "getCurrentDepthAttachment", "init", "", "setTextureFilterMod", "mod", "clear", "bit", "bindFramebuffer", "writeFrameBufferWith", "writeScope", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "readFrameBufferWith", "readScope", "reset", "release", "initColorChannel", "initDepthChannel", "bindTextureTo", "textureID", "fc", "Ljava/lang/Runnable;", "resize", "copyDepthBuffer", "srcFBO", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSimpleFrameBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleFrameBuffer.kt\ncn/coostack/cooparticlesapi/renderer/shader/glsl/SimpleFrameBuffer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,241:1\n13567#2,3:242\n13567#2,3:245\n*S KotlinDebug\n*F\n+ 1 SimpleFrameBuffer.kt\ncn/coostack/cooparticlesapi/renderer/shader/glsl/SimpleFrameBuffer\n*L\n121#1:242,3\n139#1:245,3\n*E\n"})
public class SimpleFrameBuffer
implements GlFrameBuffer {
    private final int colorChannelCount;
    @NotNull
    private Supplier<Integer> depthSupplier;
    @NotNull
    private final int[] colorAttachments;
    private int depthAttachment;
    private int fbo;
    private int prevFBO;
    private boolean initialized;
    private boolean newDepth;
    private int textureFilterMod;

    public SimpleFrameBuffer(int colorChannelCount, @NotNull Supplier<Integer> depthSupplier) {
        Intrinsics.checkNotNullParameter(depthSupplier, (String)"depthSupplier");
        this.colorChannelCount = colorChannelCount;
        this.depthSupplier = depthSupplier;
        this.colorAttachments = new int[this.colorChannelCount];
        this.depthAttachment = -1;
        this.textureFilterMod = 9729;
    }

    public final int getColorChannelCount() {
        return this.colorChannelCount;
    }

    @Override
    @NotNull
    public Supplier<Integer> getDepthSupplier() {
        return this.depthSupplier;
    }

    @Override
    public void setDepthSupplier(@NotNull Supplier<Integer> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.depthSupplier = supplier;
    }

    @Override
    @NotNull
    public int[] getColorAttachments() {
        return this.colorAttachments;
    }

    @Override
    public int fbo() {
        return this.fbo;
    }

    @Override
    public int width() {
        return Minecraft.getInstance().getMainRenderTarget().width;
    }

    @Override
    public int height() {
        return Minecraft.getInstance().getMainRenderTarget().height;
    }

    @Override
    public int getCurrentDepthAttachment() {
        return this.depthAttachment;
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.fbo = GL33.glGenFramebuffers();
        this.bindFramebuffer();
        this.prevFBO = 0;
        this.initColorChannel();
        this.initDepthChannel();
        if (GL33.glCheckFramebufferStatus((int)36160) != 36053) {
            Minecraft mc = Minecraft.getInstance();
            RenderTarget target = mc.getMainRenderTarget();
            String string = Arrays.toString(this.getColorAttachments());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            CooParticlesConstants.logger.error("\n                    Failed to bind framebuffer " + this.fbo + " \n                    depth: " + this.depthAttachment + " \n                    color:" + string + " \n                    status undefined: " + (GL33.glCheckFramebufferStatus((int)36160) == 33305) + "\n                    status incomplete attachment: " + (GL33.glCheckFramebufferStatus((int)36160) == 36054) + "\n                    status missing attachment: " + (GL33.glCheckFramebufferStatus((int)36160) == 36055) + "\n                    height: " + this.height() + " width: " + this.width() + " \n                    mc_height:" + target.height + " mc_width: " + target.width + "\n                    vew mc_height:" + target.viewHeight + " mc_width: " + target.viewWidth + "\n                    window h: " + mc.getWindow().getScreenHeight() + " w " + mc.getWindow().getScreenWidth() + "\n                ");
            Integer n = this.getDepthSupplier().get();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            this.depthAttachment = ((Number)n).intValue();
        }
        this.reset();
    }

    @Override
    public void setTextureFilterMod(int mod) {
        this.textureFilterMod = mod;
    }

    @Override
    public void clear() {
        this.clear(16640);
    }

    @Override
    public void clear(int bit) {
        GL33.glClear((int)bit);
    }

    @Override
    public void bindFramebuffer() {
        this.prevFBO = GL33.glGetInteger((int)36006);
        GL33.glBindFramebuffer((int)36160, (int)this.fbo);
    }

    @Override
    public void writeFrameBufferWith(@NotNull Function1<? super GlFrameBuffer, Unit> writeScope) {
        Intrinsics.checkNotNullParameter(writeScope, (String)"writeScope");
        if (this.fbo == 0) {
            CooParticlesConstants.logger.error("trying to write frame buffer but fbo is zero");
            this.initialized = false;
            this.init();
            return;
        }
        this.bindFramebuffer();
        if (this.newDepth) {
            this.clear();
        } else {
            this.clear(16384);
        }
        writeScope.invoke((Object)this);
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readFrameBufferWith(@NotNull Function1<? super GlFrameBuffer, Unit> readScope) {
        Intrinsics.checkNotNullParameter(readScope, (String)"readScope");
        if (this.fbo == 0) {
            CooParticlesConstants.logger.error("trying to read frame buffer but fbo is zero");
            this.initialized = false;
            return;
        }
        int zero = 33984;
        int[] activeChannels = new int[this.colorChannelCount];
        int prevActive = GL33.glGetInteger((int)34016);
        int prevTexture = GL33.glGetInteger((int)32873);
        int n = this.colorChannelCount;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            int channel = zero + it;
            GL33.glActiveTexture((int)channel);
            activeChannels[it] = GL33.glGetInteger((int)32873);
            GL33.glBindTexture((int)3553, (int)this.getColorAttachments()[it]);
        }
        readScope.invoke((Object)this);
        int[] $this$forEachIndexed$iv = activeChannels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            void texture;
            int n3 = index$iv++;
            int n4 = item$iv;
            int channel = n3;
            boolean bl = false;
            GL33.glActiveTexture((int)(zero + channel));
            GL33.glBindTexture((int)3553, (int)texture);
        }
        GL33.glActiveTexture((int)prevActive);
        GL33.glBindTexture((int)3553, (int)prevTexture);
    }

    @Override
    public void reset() {
        GL33.glBindFramebuffer((int)36160, (int)this.prevFBO);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void release() {
        if (!this.initialized) {
            return;
        }
        GL33.glDeleteFramebuffers((int)this.fbo);
        this.fbo = 0;
        int[] $this$forEachIndexed$iv = this.getColorAttachments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            void texture;
            int n = index$iv++;
            int n2 = item$iv;
            int channel = n;
            boolean bl = false;
            GL33.glDeleteTextures((int)texture);
            this.getColorAttachments()[channel] = 0;
        }
        if (this.newDepth) {
            GL33.glDeleteTextures((int)this.depthAttachment);
            this.depthAttachment = -1;
        }
    }

    private final void initColorChannel() {
        int zero = 36064;
        int[] channels = new int[this.colorChannelCount];
        int n = this.colorChannelCount;
        int n2 = 0;
        while (n2 < n) {
            int texture;
            int channel;
            int it = n2++;
            boolean bl = false;
            channels[it] = channel = zero + it;
            this.getColorAttachments()[it] = texture = GL33.glGenTextures();
            this.bindTextureTo(texture, () -> SimpleFrameBuffer.initColorChannel$lambda$4$lambda$3(this, channel, texture));
        }
        GL33.glDrawBuffers((int[])channels);
    }

    private final void initDepthChannel() {
        boolean bl;
        Integer n = this.getDepthSupplier().get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        int get = ((Number)n).intValue();
        boolean bl2 = bl = get == -1;
        if (bl) {
            this.depthAttachment = GL33.glGenTextures();
            this.newDepth = true;
        } else {
            this.depthAttachment = get;
        }
        this.bindTextureTo(this.depthAttachment, () -> SimpleFrameBuffer.initDepthChannel$lambda$5(bl, this));
    }

    private final void bindTextureTo(int textureID, Runnable fc) {
        int prev = GL33.glGetInteger((int)32873);
        GL33.glBindTexture((int)3553, (int)textureID);
        fc.run();
        GL33.glBindTexture((int)3553, (int)prev);
    }

    @Override
    public void resize(int width, int height) {
        if (!this.initialized) {
            return;
        }
        this.readFrameBufferWith((Function1<? super GlFrameBuffer, Unit>)((Function1)SimpleFrameBuffer::resize$lambda$6));
        this.release();
        this.initialized = false;
        this.prevFBO = 0;
        this.init();
    }

    @Override
    public void copyDepthBuffer(int srcFBO) {
        int lastReadReader = GL33.glGetInteger((int)36010);
        int lastDrawReader = GL33.glGetInteger((int)36006);
        GL33.glBindFramebuffer((int)36008, (int)srcFBO);
        GL33.glBindFramebuffer((int)36009, (int)this.fbo);
        GL33.glBlitFramebuffer((int)0, (int)0, (int)this.width(), (int)this.height(), (int)0, (int)0, (int)this.width(), (int)this.height(), (int)256, (int)9728);
        GL33.glBindFramebuffer((int)36008, (int)lastReadReader);
        GL33.glBindFramebuffer((int)36009, (int)lastDrawReader);
    }

    private static final void initColorChannel$lambda$4$lambda$3(SimpleFrameBuffer this$0, int $channel, int $texture) {
        GL33.glTexImage2D((int)3553, (int)0, (int)6408, (int)this$0.width(), (int)this$0.height(), (int)0, (int)6408, (int)5121, null);
        GL33.glTexParameteri((int)3553, (int)10241, (int)this$0.textureFilterMod);
        GL33.glTexParameteri((int)3553, (int)10240, (int)this$0.textureFilterMod);
        GL33.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL33.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL33.glGenerateMipmap((int)3553);
        GL33.glFramebufferTexture2D((int)36160, (int)$channel, (int)3553, (int)$texture, (int)0);
    }

    private static final void initDepthChannel$lambda$5(boolean $new, SimpleFrameBuffer this$0) {
        if ($new) {
            GL33.glTexImage2D((int)3553, (int)0, (int)6402, (int)this$0.width(), (int)this$0.height(), (int)0, (int)6402, (int)5121, null);
            GL33.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL33.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL33.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL33.glTexParameteri((int)3553, (int)10243, (int)33071);
        }
        GL33.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this$0.depthAttachment, (int)0);
    }

    private static final Unit resize$lambda$6(GlFrameBuffer $this$readFrameBufferWith) {
        Intrinsics.checkNotNullParameter((Object)$this$readFrameBufferWith, (String)"$this$readFrameBufferWith");
        $this$readFrameBufferWith.clear();
        return Unit.INSTANCE;
    }
}

