/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.pipe;

import cn.coostack.cooparticlesapi.renderer.shader.ShaderProgramBuilder;
import cn.coostack.cooparticlesapi.renderer.shader.api.CooShaderProgram;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlFrameBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShaderType;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.ShaderPipe;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.handler.ShaderProgramUploader;
import cn.coostack.cooparticlesapi.renderer.shader.glsl.IdentifierShader;
import cn.coostack.cooparticlesapi.renderer.shader.glsl.MinecraftHookFrameBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.SimpleVertexBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.VertexBuffers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020(H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\rH\u0016J!\u0010+\u001a\u00020%2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020%0-\u00a2\u0006\u0002\b.H\u0016J\b\u0010/\u001a\u00020%H\u0016J\u0010\u00100\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\rH\u0016J\b\u00104\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/pipe/MCHookedShaderPipe;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/ShaderPipe;", "fragment", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "mcFrame", "Lcom/mojang/blaze3d/pipeline/RenderTarget;", "<init>", "(Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;Lcom/mojang/blaze3d/pipeline/RenderTarget;)V", "getFragment", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlShader;", "getMcFrame", "()Lcom/mojang/blaze3d/pipeline/RenderTarget;", "count", "", "getCount", "()I", "setCount", "(I)V", "shareDepth", "", "getShareDepth", "()Z", "setShareDepth", "(Z)V", "screenVertex", "Lcn/coostack/cooparticlesapi/renderer/shader/glsl/IdentifierShader;", "shaderVertexes", "Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "handles", "Ljava/util/ArrayList;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/handler/ShaderProgramUploader;", "Lkotlin/collections/ArrayList;", "screenProgram", "Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "fbo", "Lcn/coostack/cooparticlesapi/renderer/shader/glsl/MinecraftHookFrameBuffer;", "init", "", "addRenderHandler", "handler", "Lcn/coostack/cooparticlesapi/renderer/shader/api/glsl/GlFrameBuffer;", "textureFilterMod", "mod", "write", "invoker", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "drawPipeFrame", "setPipeRenderCount", "resize", "width", "height", "release", "cooparticlesapi-fabric-1.21.1"})
public final class MCHookedShaderPipe
implements ShaderPipe {
    @NotNull
    private final GlShader fragment;
    @NotNull
    private final RenderTarget mcFrame;
    private int count;
    private boolean shareDepth;
    @NotNull
    private final IdentifierShader screenVertex;
    @NotNull
    private final SimpleVertexBuffer shaderVertexes;
    @NotNull
    private final ArrayList<ShaderProgramUploader> handles;
    @NotNull
    private final CooShaderProgram screenProgram;
    @NotNull
    private final MinecraftHookFrameBuffer fbo;

    public MCHookedShaderPipe(@NotNull GlShader fragment, @NotNull RenderTarget mcFrame) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)mcFrame, (String)"mcFrame");
        this.fragment = fragment;
        this.mcFrame = mcFrame;
        this.count = 1;
        this.shareDepth = true;
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cooparticlesapi", (String)"pipe/vertexes/screen.vsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        this.screenVertex = new IdentifierShader(resourceLocation, GlShaderType.VERTEX);
        this.shaderVertexes = VertexBuffers.INSTANCE.getScreenBuffer();
        this.handles = new ArrayList();
        this.screenProgram = new ShaderProgramBuilder().vertex(this.screenVertex).fragment(this.fragment).build();
        this.fbo = new MinecraftHookFrameBuffer(this.mcFrame);
    }

    @NotNull
    public final GlShader getFragment() {
        return this.fragment;
    }

    @NotNull
    public final RenderTarget getMcFrame() {
        return this.mcFrame;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int n) {
        this.count = n;
    }

    public final boolean getShareDepth() {
        return this.shareDepth;
    }

    public final void setShareDepth(boolean bl) {
        this.shareDepth = bl;
    }

    @Override
    public void init() {
        if (!(this.fragment.getType() == GlShaderType.FRAGMENT)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.screenProgram.init();
        this.fbo.init();
        this.shaderVertexes.init();
    }

    @Override
    @NotNull
    public ShaderPipe addRenderHandler(@NotNull ShaderProgramUploader handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handles.add(handler);
        return this;
    }

    @Override
    @NotNull
    public GlFrameBuffer fbo() {
        return this.fbo;
    }

    @Override
    public boolean shareDepth() {
        return this.shareDepth;
    }

    @Override
    @NotNull
    public ShaderPipe textureFilterMod(int mod) {
        return this;
    }

    @Override
    public void write(@NotNull Function1<? super ShaderPipe, Unit> invoker) {
        Intrinsics.checkNotNullParameter(invoker, (String)"invoker");
        this.fbo.writeFrameBufferWith((Function1<? super GlFrameBuffer, Unit>)((Function1)arg_0 -> MCHookedShaderPipe.write$lambda$0(invoker, this, arg_0)));
    }

    @Override
    public void drawPipeFrame() {
        this.screenProgram.useOnContext((Function1<? super CooShaderProgram, Unit>)((Function1)arg_0 -> MCHookedShaderPipe.drawPipeFrame$lambda$2(this, arg_0)));
    }

    @Override
    @NotNull
    public ShaderPipe setPipeRenderCount(int count) {
        this.count = RangesKt.coerceAtLeast((int)count, (int)1);
        return this;
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void release() {
        this.fbo.release();
        this.screenProgram.release();
        this.shaderVertexes.release();
    }

    private static final Unit write$lambda$0(Function1 $invoker, MCHookedShaderPipe this$0, GlFrameBuffer $this$writeFrameBufferWith) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFrameBufferWith, (String)"$this$writeFrameBufferWith");
        $invoker.invoke((Object)this$0);
        return Unit.INSTANCE;
    }

    private static final Unit drawPipeFrame$lambda$2$lambda$1(MCHookedShaderPipe this$0, GlFrameBuffer $this$readFrameBufferWith) {
        Intrinsics.checkNotNullParameter((Object)$this$readFrameBufferWith, (String)"$this$readFrameBufferWith");
        this$0.shaderVertexes.draw();
        return Unit.INSTANCE;
    }

    private static final Unit drawPipeFrame$lambda$2(MCHookedShaderPipe this$0, CooShaderProgram $this$useOnContext) {
        Intrinsics.checkNotNullParameter((Object)$this$useOnContext, (String)"$this$useOnContext");
        Iterator<ShaderProgramUploader> iterator = this$0.handles.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ShaderProgramUploader> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ShaderProgramUploader handler;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            handler.uploadShaderData(this$0.screenProgram);
        }
        this$0.fbo.readFrameBufferWith((Function1<? super GlFrameBuffer, Unit>)((Function1)arg_0 -> MCHookedShaderPipe.drawPipeFrame$lambda$2$lambda$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }
}

