/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.pipe;

import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShaderType;
import cn.coostack.cooparticlesapi.renderer.shader.api.pipe.ShaderPipe;
import cn.coostack.cooparticlesapi.renderer.shader.glsl.IdentifierShader;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.MCHookedShaderPipe;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.SimpleShaderPipe;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.SimpleVertexBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.VertexBuffers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010$\u001a\u00020\u001bJ\u001f\u0010%\u001a\u00020\u00002\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cJ\u0006\u0010'\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000eJ\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020\u001bJ\u0006\u00101\u001a\u00020\u001bJ\u0016\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001c0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/pipe/ShaderPipeManager;", "", "pipeID", "Lnet/minecraft/resources/ResourceLocation;", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "getPipeID", "()Lnet/minecraft/resources/ResourceLocation;", "initialized", "", "screenBuffer", "Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "pipes", "Ljava/util/LinkedList;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/pipe/ShaderPipe;", "getPipes", "()Ljava/util/LinkedList;", "depthSupplier", "Ljava/util/function/Supplier;", "", "getDepthSupplier", "()Ljava/util/function/Supplier;", "setDepthSupplier", "(Ljava/util/function/Supplier;)V", "beforeInitPipe", "", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getBeforeInitPipe", "()Ljava/util/List;", "useDepth", "getUseDepth", "()Z", "setUseDepth", "(Z)V", "init", "beforeInit", "invoke", "addMcHookedPipe", "addPipe", "pipe", "handlePipeDepthAttachmentAtIndex", "lastIndex", "handlePipeDepthAttachment", "writeFrame", "draw", "Ljava/lang/Runnable;", "render", "release", "resize", "width", "height", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nShaderPipeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderPipeManager.kt\ncn/coostack/cooparticlesapi/renderer/shader/pipe/ShaderPipeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1869#2,2:182\n1878#2,3:184\n1869#2,2:187\n1869#2,2:189\n*S KotlinDebug\n*F\n+ 1 ShaderPipeManager.kt\ncn/coostack/cooparticlesapi/renderer/shader/pipe/ShaderPipeManager\n*L\n41#1:182,2\n58#1:184,3\n171#1:187,2\n177#1:189,2\n*E\n"})
public final class ShaderPipeManager {
    @NotNull
    private final ResourceLocation pipeID;
    private boolean initialized;
    @NotNull
    private final SimpleVertexBuffer screenBuffer;
    @NotNull
    private final LinkedList<ShaderPipe> pipes;
    @NotNull
    private Supplier<Integer> depthSupplier;
    @NotNull
    private final List<Function1<ShaderPipeManager, Unit>> beforeInitPipe;
    private boolean useDepth;

    public ShaderPipeManager(@NotNull ResourceLocation pipeID) {
        Intrinsics.checkNotNullParameter((Object)pipeID, (String)"pipeID");
        this.pipeID = pipeID;
        this.screenBuffer = VertexBuffers.INSTANCE.getScreenBuffer();
        this.pipes = new LinkedList();
        this.depthSupplier = ShaderPipeManager::depthSupplier$lambda$0;
        this.beforeInitPipe = new ArrayList();
        this.useDepth = true;
    }

    @NotNull
    public final ResourceLocation getPipeID() {
        return this.pipeID;
    }

    @NotNull
    public final LinkedList<ShaderPipe> getPipes() {
        return this.pipes;
    }

    @NotNull
    public final Supplier<Integer> getDepthSupplier() {
        return this.depthSupplier;
    }

    public final void setDepthSupplier(@NotNull Supplier<Integer> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.depthSupplier = supplier;
    }

    @NotNull
    public final List<Function1<ShaderPipeManager, Unit>> getBeforeInitPipe() {
        return this.beforeInitPipe;
    }

    public final boolean getUseDepth() {
        return this.useDepth;
    }

    public final void setUseDepth(boolean bl) {
        this.useDepth = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        if (this.initialized) {
            return;
        }
        Iterable $this$forEach$iv = this.beforeInitPipe;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)this);
        }
        this.initialized = true;
        if (this.pipes.isEmpty()) {
            Minecraft mc = Minecraft.getInstance();
            Window window = mc.getWindow();
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cooparticlesapi", (String)"pipe/frags/screen.fsh");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
            SimpleShaderPipe simplePipe = new SimpleShaderPipe(new IdentifierShader(resourceLocation, GlShaderType.FRAGMENT), this.depthSupplier, 0, 4, null);
            this.addPipe(simplePipe);
        }
        Iterable $this$forEachIndexed$iv = this.pipes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ShaderPipe shaderPipe = (ShaderPipe)item$iv;
            int current = n;
            boolean bl = false;
            this.handlePipeDepthAttachmentAtIndex(current - 1, (ShaderPipe)it);
            it.init();
        }
        this.screenBuffer.init();
    }

    @NotNull
    public final ShaderPipeManager beforeInit(@NotNull Function1<? super ShaderPipeManager, Unit> invoke) {
        Intrinsics.checkNotNullParameter(invoke, (String)"invoke");
        this.beforeInitPipe.add(invoke);
        return this;
    }

    @NotNull
    public final ShaderPipeManager addMcHookedPipe() {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cooparticlesapi", (String)"pipe/frags/screen.fsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        GlShader glShader = new IdentifierShader(resourceLocation, GlShaderType.FRAGMENT);
        RenderTarget renderTarget = Minecraft.getInstance().getMainRenderTarget();
        Intrinsics.checkNotNullExpressionValue((Object)renderTarget, (String)"getMainRenderTarget(...)");
        MCHookedShaderPipe pipe = new MCHookedShaderPipe(glShader, renderTarget);
        if (this.initialized) {
            pipe.init();
        }
        this.pipes.add(pipe);
        return this;
    }

    @NotNull
    public final ShaderPipeManager addPipe(@NotNull ShaderPipe pipe) {
        Intrinsics.checkNotNullParameter((Object)pipe, (String)"pipe");
        this.handlePipeDepthAttachment(pipe);
        if (this.initialized) {
            pipe.init();
        }
        this.pipes.add(pipe);
        return this;
    }

    private final void handlePipeDepthAttachmentAtIndex(int lastIndex, ShaderPipe pipe) {
        if (!pipe.shareDepth()) {
            return;
        }
        Supplier<Integer> lastPipe = (0 <= lastIndex ? lastIndex < ((Collection)this.pipes).size() : false) ? this.pipes.get(lastIndex).fbo().getDepthSupplier() : this.depthSupplier;
        pipe.fbo().setDepthSupplier(lastPipe);
    }

    private final void handlePipeDepthAttachment(ShaderPipe pipe) {
        Integer n = this.depthSupplier.get();
        int n2 = -1;
        if (n != null && n == n2) {
            return;
        }
        if (pipe.shareDepth()) {
            Supplier<Integer> supplier;
            if (!((Collection)this.pipes).isEmpty()) {
                ShaderPipe last = (ShaderPipe)CollectionsKt.last((List)this.pipes);
                supplier = last.fbo().getDepthSupplier();
            } else {
                supplier = this.depthSupplier;
            }
            Supplier<Integer> useAttachment = supplier;
            pipe.fbo().setDepthSupplier(useAttachment);
        }
    }

    @NotNull
    public final ShaderPipeManager writeFrame(@NotNull Runnable draw) {
        Intrinsics.checkNotNullParameter((Object)draw, (String)"draw");
        if (!this.initialized) {
            return this;
        }
        if (this.useDepth) {
            RenderSystem.depthMask((boolean)true);
        }
        ShaderPipe first = (ShaderPipe)CollectionsKt.first((List)this.pipes);
        first.write((Function1<? super ShaderPipe, Unit>)((Function1)arg_0 -> ShaderPipeManager.writeFrame$lambda$3(draw, arg_0)));
        return this;
    }

    public final void render() {
        if (!this.initialized) {
            return;
        }
        Iterator iterator = this.pipes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        Ref.ObjectRef last = new Ref.ObjectRef();
        Object e = iterator2.next();
        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
        last.element = e;
        while (iterator2.hasNext()) {
            Object e2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
            ShaderPipe current = (ShaderPipe)e2;
            current.write((Function1<? super ShaderPipe, Unit>)((Function1)arg_0 -> ShaderPipeManager.render$lambda$4(last, arg_0)));
            last.element = current;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)1, (int)1);
        RenderSystem.depthMask((boolean)false);
        ((ShaderPipe)last.element).drawPipeFrame();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
    }

    public final void release() {
        Iterable $this$forEach$iv = this.pipes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShaderPipe it = (ShaderPipe)element$iv;
            boolean bl = false;
            it.release();
        }
    }

    public final void resize(int width, int height) {
        Iterable $this$forEach$iv = this.pipes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShaderPipe it = (ShaderPipe)element$iv;
            boolean bl = false;
            it.resize(width, height);
        }
    }

    private static final Integer depthSupplier$lambda$0() {
        return -1;
    }

    private static final Unit writeFrame$lambda$3(Runnable $draw, ShaderPipe $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        $draw.run();
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$4(Ref.ObjectRef $last, ShaderPipe $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        RenderSystem.enableBlend();
        ((ShaderPipe)$last.element).drawPipeFrame();
        return Unit.INSTANCE;
    }
}

