/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.renderer.shader.vertex;

import cn.coostack.cooparticlesapi.renderer.shader.api.VertexBuffer;
import cn.coostack.cooparticlesapi.renderer.shader.data.CooVertexFormat;
import cn.coostack.cooparticlesapi.renderer.shader.data.VertexData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL33;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0014\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0002J\u001e\u0010!\u001a\u00020\u001f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\"2\u0006\u0010#\u001a\u00020\u000eH\u0016J\b\u0010$\u001a\u00020\u001fH\u0016J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\b\u0010(\u001a\u00020\u001fH\u0016J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcn/coostack/cooparticlesapi/renderer/shader/vertex/DynamicVertexBuffer;", "Lcn/coostack/cooparticlesapi/renderer/shader/api/VertexBuffer;", "<init>", "()V", "value", "", "vao", "getVao", "()I", "vbo", "getVbo", "lastVAO", "getLastVAO", "currentVertexFormat", "Lcn/coostack/cooparticlesapi/renderer/shader/data/CooVertexFormat;", "getCurrentVertexFormat", "()Lcn/coostack/cooparticlesapi/renderer/shader/data/CooVertexFormat;", "setCurrentVertexFormat", "(Lcn/coostack/cooparticlesapi/renderer/shader/data/CooVertexFormat;)V", "drawMode", "getDrawMode", "setDrawMode", "(I)V", "vertexes", "Ljava/util/ArrayList;", "Lcn/coostack/cooparticlesapi/renderer/shader/data/VertexData;", "Lkotlin/collections/ArrayList;", "dirty", "", "uploadedProgram", "uploadVertexes", "", "upload", "setVertexes", "", "format", "draw", "init", "use", "reset", "release", "dataOffsetCount", "", "vertexToData", "", "cooparticlesapi-fabric-1.21.1"})
public final class DynamicVertexBuffer
implements VertexBuffer {
    private int vao;
    private int vbo;
    private int lastVAO;
    @NotNull
    private CooVertexFormat currentVertexFormat = CooVertexFormat.POINT_FORMAT;
    private int drawMode = 4;
    @NotNull
    private final ArrayList<VertexData> vertexes = new ArrayList();
    private boolean dirty;
    private int uploadedProgram;

    public final int getVao() {
        return this.vao;
    }

    public final int getVbo() {
        return this.vbo;
    }

    public final int getLastVAO() {
        return this.lastVAO;
    }

    @NotNull
    public final CooVertexFormat getCurrentVertexFormat() {
        return this.currentVertexFormat;
    }

    public final void setCurrentVertexFormat(@NotNull CooVertexFormat cooVertexFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cooVertexFormat), (String)"<set-?>");
        this.currentVertexFormat = cooVertexFormat;
    }

    public final int getDrawMode() {
        return this.drawMode;
    }

    public final void setDrawMode(int n) {
        this.drawMode = n;
    }

    @Override
    public void uploadVertexes() {
        boolean updateProgram;
        int programNow = GL33.glGetInteger((int)35725);
        boolean bl = updateProgram = programNow != this.uploadedProgram;
        if (this.dirty || updateProgram) {
            int currentVAO = GL33.glGetInteger((int)34229);
            boolean needReset = false;
            if (currentVAO != this.vao) {
                this.use();
                needReset = true;
            }
            this.upload();
            if (needReset) {
                this.reset();
            }
            this.dirty = false;
        }
        if (updateProgram) {
            this.uploadedProgram = programNow;
        }
    }

    private final void upload() {
        float[] data = this.vertexToData();
        GL33.glBindBuffer((int)34962, (int)this.vbo);
        GL33.glBufferData((int)34962, (float[])data, (int)35048);
        int offset = (int)this.dataOffsetCount() * 4;
        GL33.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)offset, (long)0L);
        GL33.glEnableVertexAttribArray((int)0);
        if (this.currentVertexFormat == CooVertexFormat.POINT_COLOR_TEXTURE_UV_FORMAT) {
            GL33.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)offset, (long)12L);
            GL33.glEnableVertexAttribArray((int)1);
            GL33.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)offset, (long)28L);
            GL33.glEnableVertexAttribArray((int)2);
        } else if (this.currentVertexFormat != CooVertexFormat.POINT_FORMAT) {
            int size = this.currentVertexFormat == CooVertexFormat.POINT_COLOR_FORMAT ? 4 : 2;
            GL33.glVertexAttribPointer((int)1, (int)size, (int)5126, (boolean)false, (int)offset, (long)12L);
            GL33.glEnableVertexAttribArray((int)1);
        }
    }

    @Override
    public void setVertexes(@NotNull List<VertexData> vertexes, @NotNull CooVertexFormat format) {
        Intrinsics.checkNotNullParameter(vertexes, (String)"vertexes");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        this.vertexes.clear();
        this.vertexes.addAll((Collection<VertexData>)vertexes);
        this.currentVertexFormat = format;
        this.dirty = true;
    }

    @Override
    public void draw() {
        this.use();
        this.uploadVertexes();
        GL33.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexes.size());
        this.reset();
    }

    @Override
    public void init() {
        this.vao = GL33.glGenVertexArrays();
        this.vbo = GL33.glGenBuffers();
        this.use();
        GL33.glBindBuffer((int)34962, (int)this.vbo);
        this.reset();
    }

    @Override
    public void use() {
        this.lastVAO = GL33.glGetInteger((int)34229);
        GL33.glBindVertexArray((int)this.vao);
    }

    @Override
    public void reset() {
        GL33.glBindVertexArray((int)this.lastVAO);
    }

    @Override
    public void release() {
        GL33.glDeleteVertexArrays((int)this.vao);
        GL33.glDeleteBuffers((int)this.vbo);
    }

    private final long dataOffsetCount() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.currentVertexFormat.ordinal()]) {
            case 1 -> 7L;
            case 2 -> 5L;
            case 3 -> 3L;
            case 4 -> 9L;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final float[] vertexToData() {
        int count = this.vertexes.size();
        if (count <= 0) {
            return new float[0];
        }
        float[] res = new float[count *= (int)this.dataOffsetCount()];
        int n = ((Collection)this.vertexes).size();
        block6: for (int i = 0; i < n; ++i) {
            VertexData vertex;
            Intrinsics.checkNotNullExpressionValue((Object)this.vertexes.get(i), (String)"get(...)");
            Vector3f pos = vertex.getPos();
            Vector4f color = vertex.getColor();
            Vector2f uv = vertex.getUv();
            switch (WhenMappings.$EnumSwitchMapping$0[this.currentVertexFormat.ordinal()]) {
                case 2: {
                    res[i * 5] = pos.x;
                    res[i * 5 + 1] = pos.y;
                    res[i * 5 + 2] = pos.z;
                    res[i * 5 + 3] = uv.x;
                    res[i * 5 + 4] = uv.y;
                    continue block6;
                }
                case 3: {
                    res[i * 3] = pos.x;
                    res[i * 3 + 1] = pos.y;
                    res[i * 3 + 2] = pos.z;
                    continue block6;
                }
                case 1: {
                    res[i * 7] = pos.x;
                    res[i * 7 + 1] = pos.y;
                    res[i * 7 + 2] = pos.z;
                    res[i * 7 + 3] = color.x;
                    res[i * 7 + 4] = color.y;
                    res[i * 7 + 5] = color.z;
                    res[i * 7 + 6] = color.w;
                    continue block6;
                }
                case 4: {
                    res[i * 9] = pos.x;
                    res[i * 9 + 1] = pos.y;
                    res[i * 9 + 2] = pos.z;
                    res[i * 9 + 3] = color.x;
                    res[i * 9 + 4] = color.y;
                    res[i * 9 + 5] = color.z;
                    res[i * 9 + 6] = color.w;
                    res[i * 9 + 7] = uv.x;
                    res[i * 9 + 8] = uv.y;
                    continue block6;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return res;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CooVertexFormat.values().length];
            try {
                nArray[CooVertexFormat.POINT_COLOR_FORMAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CooVertexFormat.POINT_TEXTURE_UV_FORMAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CooVertexFormat.POINT_FORMAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CooVertexFormat.POINT_COLOR_TEXTURE_UV_FORMAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

