/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.test.particle.client;

import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.particles.ControlableParticle;
import cn.coostack.cooparticlesapi.particles.ParticleDisplayer;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroup;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroupProvider;
import cn.coostack.cooparticlesapi.particles.control.group.SequencedParticleGroup;
import cn.coostack.cooparticlesapi.particles.impl.ControlableEndRodEffect;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lcn/coostack/cooparticlesapi/test/particle/client/SequencedMagicCircleClient;", "Lcn/coostack/cooparticlesapi/particles/control/group/SequencedParticleGroup;", "uuid", "Ljava/util/UUID;", "bindPlayer", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;)V", "getBindPlayer", "()Ljava/util/UUID;", "maxScaleTick", "", "getMaxScaleTick", "()I", "setMaxScaleTick", "(I)V", "current", "getCurrent", "setCurrent", "loadParticleLocationsWithIndex", "Ljava/util/SortedMap;", "Lcn/coostack/cooparticlesapi/particles/control/group/SequencedParticleGroup$SequencedParticleRelativeData;", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "beforeDisplay", "", "locations", "toggle", "", "getToggle", "()Z", "setToggle", "(Z)V", "onGroupDisplay", "Provider", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSequencedMagicCircleClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SequencedMagicCircleClient.kt\ncn/coostack/cooparticlesapi/test/particle/client/SequencedMagicCircleClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1878#2,2:76\n1880#2:79\n1#3:78\n*S KotlinDebug\n*F\n+ 1 SequencedMagicCircleClient.kt\ncn/coostack/cooparticlesapi/test/particle/client/SequencedMagicCircleClient\n*L\n40#1:76,2\n40#1:79\n*E\n"})
public final class SequencedMagicCircleClient
extends SequencedParticleGroup {
    @NotNull
    private final UUID bindPlayer;
    private int maxScaleTick;
    private int current;
    private boolean toggle;

    public SequencedMagicCircleClient(@NotNull UUID uuid, @NotNull UUID bindPlayer) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)bindPlayer, (String)"bindPlayer");
        super(uuid);
        this.bindPlayer = bindPlayer;
        this.maxScaleTick = 36;
    }

    @NotNull
    public final UUID getBindPlayer() {
        return this.bindPlayer;
    }

    public final int getMaxScaleTick() {
        return this.maxScaleTick;
    }

    public final void setMaxScaleTick(int n) {
        this.maxScaleTick = n;
    }

    public final int getCurrent() {
        return this.current;
    }

    public final void setCurrent(int n) {
        this.current = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SortedMap<SequencedParticleGroup.SequencedParticleRelativeData, RelativeLocation> loadParticleLocationsWithIndex() {
        TreeMap res = new TreeMap();
        List<RelativeLocation> points = Math3DUtil.INSTANCE.getCycloidGraphic(3.0, 5.0, -2, 3, 360, 0.5);
        Iterable $this$forEachIndexed$iv = points;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            void var14_14;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RelativeLocation relativeLocation = (RelativeLocation)item$iv;
            int index = n;
            boolean bl = false;
            Map map = res;
            SequencedParticleGroup.SequencedParticleRelativeData sequencedParticleRelativeData = this.withEffect((Function1<? super UUID, ? extends ParticleDisplayer>)((Function1)SequencedMagicCircleClient::loadParticleLocationsWithIndex$lambda$3$lambda$0), (Function1<? super ControlableParticle, Unit>)((Function1)SequencedMagicCircleClient::loadParticleLocationsWithIndex$lambda$3$lambda$1), index);
            void it2 = var14_14 = it;
            boolean bl2 = false;
            it2.setY(it2.getY() + 15.0);
            map.put(sequencedParticleRelativeData, var14_14);
        }
        return res;
    }

    @Override
    public void beforeDisplay(@NotNull SortedMap<SequencedParticleGroup.SequencedParticleRelativeData, RelativeLocation> locations) {
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        super.beforeDisplay(locations);
        this.setScale(1.0 / (double)this.maxScaleTick);
    }

    public final boolean getToggle() {
        return this.toggle;
    }

    public final void setToggle(boolean bl) {
        this.toggle = bl;
    }

    @Override
    public void onGroupDisplay() {
        this.addPreTickAction((Function1<? super ControlableParticleGroup, Unit>)((Function1)arg_0 -> SequencedMagicCircleClient.onGroupDisplay$lambda$4(this, arg_0)));
    }

    private static final ParticleDisplayer loadParticleLocationsWithIndex$lambda$3$lambda$0(UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return ParticleDisplayer.Companion.withSingle(new ControlableEndRodEffect(id, false, 2, null));
    }

    private static final Unit loadParticleLocationsWithIndex$lambda$3$lambda$1(ControlableParticle $this$withEffect) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withEffect), (String)"$this$withEffect");
        $this$withEffect.setColor(new Vector3f(0.39215687f, 0.39215687f, 1.0f));
        return Unit.INSTANCE;
    }

    private static final Unit onGroupDisplay$lambda$4(SequencedMagicCircleClient this$0, ControlableParticleGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.current < this$0.maxScaleTick && !this$0.toggle) {
            var2_2 = this$0.current;
            this$0.current = var2_2 + 1;
            this$0.scale(this$0.getScale() + 1.0 / (double)this$0.maxScaleTick);
        } else if (this$0.current < this$0.maxScaleTick) {
            var2_2 = this$0.current;
            this$0.current = var2_2 + 1;
            this$0.scale(this$0.getScale() - 1.0 / (double)this$0.maxScaleTick);
        } else {
            this$0.toggle = !this$0.toggle;
            this$0.current = 0;
        }
        this$0.rotateParticlesAsAxis(Math.toRadians(10.0));
        ClientLevel clientLevel = this$0.getWorld();
        Intrinsics.checkNotNull((Object)clientLevel);
        Player player = clientLevel.getPlayerByUUID(this$0.bindPlayer);
        if (player == null) {
            return Unit.INSTANCE;
        }
        Player player2 = player;
        Vec3 dir = player2.getForward();
        Intrinsics.checkNotNull((Object)dir);
        this$0.rotateParticlesToPoint(RelativeLocation.Companion.of(dir));
        Vec3 vec3 = player2.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        this$0.teleportTo(vec3);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcn/coostack/cooparticlesapi/test/particle/client/SequencedMagicCircleClient$Provider;", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroupProvider;", "<init>", "()V", "createGroup", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup;", "uuid", "Ljava/util/UUID;", "args", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "changeGroup", "", "group", "cooparticlesapi-fabric-1.21.1"})
    public static final class Provider
    implements ControlableParticleGroupProvider {
        @Override
        @NotNull
        public ControlableParticleGroup createGroup(@NotNull UUID uuid, @NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("bind_player");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object obj = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.util.UUID");
            UUID bindUUID = (UUID)obj;
            return new SequencedMagicCircleClient(uuid, bindUUID);
        }

        @Override
        public void changeGroup(@NotNull ControlableParticleGroup group, @NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter(args, (String)"args");
        }
    }
}

