/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.test.particle.server;

import cn.coostack.cooparticlesapi.barrages.HitBox;
import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffers;
import cn.coostack.cooparticlesapi.network.particle.ServerParticleGroup;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroup;
import cn.coostack.cooparticlesapi.test.particle.client.BarrierSwordGroupClient;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00140\u0012H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcn/coostack/cooparticlesapi/test/particle/server/BarrierSwordGroupServer;", "Lcn/coostack/cooparticlesapi/network/particle/ServerParticleGroup;", "box", "Lcn/coostack/cooparticlesapi/barrages/HitBox;", "filter", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/LivingEntity;", "direction", "Lnet/minecraft/world/phys/Vec3;", "<init>", "(Lcn/coostack/cooparticlesapi/barrages/HitBox;Ljava/util/function/Predicate;Lnet/minecraft/world/phys/Vec3;)V", "getDirection", "()Lnet/minecraft/world/phys/Vec3;", "setDirection", "(Lnet/minecraft/world/phys/Vec3;)V", "tick", "", "otherPacketArgs", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "", "getClientType", "Ljava/lang/Class;", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup;", "cooparticlesapi-fabric-1.21.1"})
public final class BarrierSwordGroupServer
extends ServerParticleGroup {
    @NotNull
    private final HitBox box;
    @NotNull
    private final Predicate<LivingEntity> filter;
    @NotNull
    private Vec3 direction;

    public BarrierSwordGroupServer(@NotNull HitBox box, @NotNull Predicate<LivingEntity> filter, @NotNull Vec3 direction) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        super(64.0);
        this.box = box;
        this.filter = filter;
        this.direction = direction;
    }

    @NotNull
    public final Vec3 getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.direction = vec3;
    }

    @Override
    public void tick() {
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        List entities = level.getEntitiesOfClass(LivingEntity.class, this.box.ofBox(this.getPos()), this.filter);
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            if (closestEntity == null) {
                closestEntity = entity;
                continue;
            }
            if (!(this.getPos().distanceTo(closestEntity.position()) > this.getPos().distanceTo(entity.position()))) continue;
            closestEntity = entity;
        }
        if (closestEntity == null) {
            return;
        }
        Vec3 vec3 = closestEntity.position().subtract(this.getPos()).normalize().scale(0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        this.direction = vec3;
        this.change((Function1<? super ServerParticleGroup, Unit>)((Function1)BarrierSwordGroupServer::tick$lambda$0), MapsKt.mapOf((Pair)TuplesKt.to((Object)"target_entity_id", (Object)ParticleControlerDataBuffers.INSTANCE.int(closestEntity.getId()))));
    }

    @Override
    @NotNull
    public Map<String, ParticleControlerDataBuffer<? extends Object>> otherPacketArgs() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"direction", (Object)ParticleControlerDataBuffers.INSTANCE.vec3d(this.direction)));
    }

    @Override
    @NotNull
    public Class<? extends ControlableParticleGroup> getClientType() {
        return BarrierSwordGroupClient.class;
    }

    private static final Unit tick$lambda$0(ServerParticleGroup $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        return Unit.INSTANCE;
    }
}

