/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.test.renderer;

import cn.coostack.cooparticlesapi.renderer.RenderEntity;
import cn.coostack.cooparticlesapi.renderer.shader.ShaderProgramBuilder;
import cn.coostack.cooparticlesapi.renderer.shader.api.CooShaderProgram;
import cn.coostack.cooparticlesapi.renderer.shader.data.CooVertexFormat;
import cn.coostack.cooparticlesapi.renderer.shader.utils.ShaderUtil;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.SimpleVertexBuffer;
import com.mojang.blaze3d.systems.RenderSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Random;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J(\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcn/coostack/cooparticlesapi/test/renderer/TestRendererEntity;", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "random", "Lorg/joml/Random;", "getRandom", "()Lorg/joml/Random;", "randomColor", "Lorg/joml/Vector3f;", "getRandomColor", "()Lorg/joml/Vector3f;", "initialize", "", "getCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "getRenderID", "Lnet/minecraft/resources/ResourceLocation;", "release", "render", "matrices", "Lorg/joml/Matrix4fStack;", "viewMatrix", "Lorg/joml/Matrix4f;", "projMatrix", "tickDelta", "", "Companion", "cooparticlesapi-fabric-1.21.1"})
public final class TestRendererEntity
extends RenderEntity {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Random random = new Random();
    @NotNull
    private final Vector3f randomColor = new Vector3f(this.random.nextFloat(), this.random.nextFloat(), this.random.nextFloat());
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, RenderEntity> codec;
    @NotNull
    private static final SimpleVertexBuffer ballBuffer;
    @NotNull
    private static final CooShaderProgram ballShader;
    private static boolean initialized;
    @NotNull
    private static final ResourceLocation id;

    public TestRendererEntity(@Nullable Level world) {
        super(world, null, 2, null);
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @NotNull
    public final Vector3f getRandomColor() {
        return this.randomColor;
    }

    @Override
    public void initialize() {
        Companion.initStatic();
    }

    @Override
    @NotNull
    public StreamCodec<FriendlyByteBuf, RenderEntity> getCodec() {
        return codec;
    }

    @Override
    @NotNull
    public ResourceLocation getRenderID() {
        return id;
    }

    @Override
    public void release() {
    }

    @Override
    public void render(@NotNull Matrix4fStack matrices, @NotNull Matrix4f viewMatrix, @NotNull Matrix4f projMatrix, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)viewMatrix, (String)"viewMatrix");
        Intrinsics.checkNotNullParameter((Object)projMatrix, (String)"projMatrix");
        RenderSystem.disableCull();
        ballShader.useOnContext((Function1<? super CooShaderProgram, Unit>)((Function1)arg_0 -> TestRendererEntity.render$lambda$0(matrices, projMatrix, viewMatrix, this, arg_0)));
    }

    private static final Unit render$lambda$0(Matrix4fStack $matrices, Matrix4f $projMatrix, Matrix4f $viewMatrix, TestRendererEntity this$0, CooShaderProgram $this$useOnContext) {
        Intrinsics.checkNotNullParameter((Object)$this$useOnContext, (String)"$this$useOnContext");
        $matrices.pushMatrix();
        $this$useOnContext.setMatrix4("projMat", $projMatrix);
        $this$useOnContext.setMatrix4("viewMat", $viewMatrix);
        $this$useOnContext.setMatrix4("transMat", (Matrix4f)$matrices);
        $this$useOnContext.setFloat3("color", this$0.randomColor);
        ballBuffer.draw();
        $matrices.popMatrix();
        return Unit.INSTANCE;
    }

    private static final void codec$lambda$1(FriendlyByteBuf buf, RenderEntity data) {
        Intrinsics.checkNotNull((Object)buf);
        Intrinsics.checkNotNull((Object)data);
        RenderEntity.Companion.encodeBase(buf, data);
    }

    private static final RenderEntity codec$lambda$2(FriendlyByteBuf it) {
        TestRendererEntity instance = new TestRendererEntity(null);
        Intrinsics.checkNotNull((Object)it);
        RenderEntity.Companion.decodeBase(it, instance);
        return instance;
    }

    static {
        SimpleVertexBuffer simpleVertexBuffer;
        Companion = new Companion(null);
        StreamCodec streamCodec = StreamCodec.of(TestRendererEntity::codec$lambda$1, TestRendererEntity::codec$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"of(...)");
        codec = streamCodec;
        SimpleVertexBuffer $this$ballBuffer_u24lambda_u243 = simpleVertexBuffer = new SimpleVertexBuffer();
        boolean bl = false;
        $this$ballBuffer_u24lambda_u243.setVertexes(ShaderUtil.INSTANCE.genBall(5.0f, 64, 64), CooVertexFormat.POINT_FORMAT);
        ballBuffer = simpleVertexBuffer;
        ballShader = new ShaderProgramBuilder().vertex("core/vertex/point.vsh").fragment("core/fragment/color.fsh").build();
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cooparticlesapi", (String)"test_shader");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        id = resourceLocation;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001c\u001a\u00020\u001dR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcn/coostack/cooparticlesapi/test/renderer/TestRendererEntity$Companion;", "", "<init>", "()V", "codec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "getCodec", "()Lnet/minecraft/network/codec/StreamCodec;", "ballBuffer", "Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "getBallBuffer", "()Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "ballShader", "Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "getBallShader", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "initStatic", "", "cooparticlesapi-fabric-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, RenderEntity> getCodec() {
            return codec;
        }

        @NotNull
        public final SimpleVertexBuffer getBallBuffer() {
            return ballBuffer;
        }

        @NotNull
        public final CooShaderProgram getBallShader() {
            return ballShader;
        }

        public final boolean getInitialized() {
            return initialized;
        }

        public final void setInitialized(boolean bl) {
            initialized = bl;
        }

        @NotNull
        public final ResourceLocation getId() {
            return id;
        }

        public final void initStatic() {
            if (this.getInitialized()) {
                return;
            }
            this.setInitialized(true);
            this.getBallBuffer().init();
            this.getBallShader().init();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

