/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.builder;

import cn.coostack.cooparticlesapi.utils.ImageUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\tJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcn/coostack/cooparticlesapi/utils/builder/ImagePointBuilder;", "", "image", "Lnet/minecraft/resources/ResourceLocation;", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "getImage", "()Lnet/minecraft/resources/ResourceLocation;", "scale", "", "step", "build", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nImagePointBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePointBuilder.kt\ncn/coostack/cooparticlesapi/utils/builder/ImagePointBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n2756#2:36\n1#3:37\n*S KotlinDebug\n*F\n+ 1 ImagePointBuilder.kt\ncn/coostack/cooparticlesapi/utils/builder/ImagePointBuilder\n*L\n30#1:36\n30#1:37\n*E\n"})
public final class ImagePointBuilder {
    @NotNull
    private final ResourceLocation image;
    private double scale;
    private double step;

    public ImagePointBuilder(@NotNull ResourceLocation image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.image = image;
        this.scale = 1.0;
        this.step = 0.01;
    }

    @NotNull
    public final ResourceLocation getImage() {
        return this.image;
    }

    @NotNull
    public final ImagePointBuilder scale(double scale) {
        this.scale = scale;
        return this;
    }

    @NotNull
    public final ImagePointBuilder step(double step) {
        this.step = step;
        return this;
    }

    @NotNull
    public final List<RelativeLocation> build() {
        Iterable iterable;
        BufferedImage bufferedImage = ImageUtil.INSTANCE.loadFromIdentifier(this.image);
        if (bufferedImage == null) {
            return new ArrayList();
        }
        BufferedImage picture = bufferedImage;
        BufferedImage scaled = ImageUtil.INSTANCE.scale(this.scale, picture);
        double offsetX = (double)scaled.getWidth() * this.step / 2.0;
        double offsetZ = (double)scaled.getHeight() * this.step / 2.0;
        Iterable $this$onEach$iv = ImageUtil.INSTANCE.toPoints(scaled, this.step);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            RelativeLocation it = (RelativeLocation)element$iv;
            boolean bl2 = false;
            it.setX(it.getX() - offsetX);
            it.setZ(it.getZ() - offsetZ);
        }
        return (List)iterable;
    }
}

